#!/bin/csh

rm -fr ft1.smile

xyz2pipe -in ft1/test%04d.ft1 -x             \
| nmrPipe  -fn SMILE -thresh 0.95 -report 2  \
           -nThread 16 -maxMem 64            \
           -sample nuslist -sampleCount 5482 \
           -xP0  90 -xP1   0 -xzf 1          \
           -yP0 -45 -yP1   0 -yzf 1 -yAlt    \
           -zP0  90 -zP1 180 -zzf 1 -zAlt    \
| pipe2xyz -out ft1.smile/test%04d.ft1 -x

rm -fr ft.tmp

xyz2pipe -in ft1.smile/test%04d.ft1 -x \
| nmrPipe  -fn ZF -zf 2                \
| nmrPipe  -fn FT                      \
| nmrPipe  -fn PS -p0 90 -p1 0 -di     \
| nmrPipe  -fn TP                      \
| nmrPipe  -fn ZF -zf 2                \
| nmrPipe  -fn FT -alt                 \
| nmrPipe  -fn PS -p0 -45 -p1 0 -di    \
| pipe2xyz -out ft.tmp/test%04d.ft3 -y

xyz2pipe -in ft.tmp/test%04d.ft3 -z    \
| nmrPipe  -fn ZF -zf 2                \
| nmrPipe  -fn FT -alt                 \
| nmrPipe  -fn PS -p0 90 -p1 180 -di   \
| nmrPipe  -fn TP                      \
| pipe2xyz -out ft.tmp/test%04d.ft4 -z

rm -fr ft

xyz2pipe -in ft.tmp/test%04d.ft4 -a \
| nmrPipe -fn FLATT -first -last    \
| pipe2xyz -out ft/test%04d.ft4 -a

proj4D.tcl -in ft/test%04d.ft4

rm -fr ft.tmp/test*.ft3

