#!/bin/csh

#FLATT requires the latest SMILE Version 2.1 Rev 2019.337.11.19

nusExpand.tcl -mode bruker -sampleCount 5482 -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

rm -fr ft1

bruk2pipe -verb -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 1248 -dspfvs 20 -grpdly 67.9840850830078  \
  -xN         3072  -yN              180  -zN         120  -aN         120  \
  -xT         1536  -yT               90  -zT          60  -aT          60  \
  -xMODE       DQD  -yMODE Echo-AntiEcho  -zMODE  Complex  -aMODE  Complex  \
  -xSW   16025.641  -ySW        2564.103  -zSW   5000.000  -aSW   5000.000  \
  -xOBS    800.134  -yOBS         81.086  -zOBS   800.134  -aOBS   800.134  \
  -xCAR      4.773  -yCAR        116.682  -zCAR     8.316  -aCAR     8.316  \
  -xLAB        Htr  -yLAB            Ntr  -zLAB        Hz  -aLAB        Ha  \
  -ndim          4  -aq2D        Complex                                    \
| nmrPipe  -fn POLY -time                                  \
| nmrPipe  -fn EXT -xn 960 -sw                             \
| nmrPipe  -fn SP -off 0.4 -end 0.98 -pow 2 -elb 15 -c 0.5 \
| nmrPipe  -fn ZF -zf 1 -auto                              \
| nmrPipe  -fn FT                                          \
| nmrPipe  -fn PS -p0 139 -p1 0 -di                        \
| nmrPipe  -fn FLATT -x1 14.5ppm -xn 5.2ppm -noauto -m 1   \
              -fitNodes 14.5ppm to 10.5ppm, 6ppm to 5.2ppm \
| nmrPipe  -fn POLY -auto -ord 1 -x1 14.5ppm -xn 5.2ppm    \
| nmrPipe  -fn EXT -x1 10.8ppm -xn 6.0ppm -sw              \
| pipe2xyz -out ft1/test%04d.ft1 -a

rm -fr prof*.dat ser_full

exit


#below is the equivalent conversion script that runs faster
#it treats 4D as 2D and convert the data before expanding it


rm -fr ft1 

bruk2pipe -verb -in ./ser \
  -bad 0.0 -ext -aswap -AMX -decim 1248 -dspfvs 20 -grpdly 67.9840850830078  \
  -xN         3072  -yN            43856  -zN           1  -aN           1  \
  -xT         1536  -yT               90  -zT          60  -aT          60  \
  -xMODE       DQD  -yMODE Echo-AntiEcho  -zMODE     Real  -aMODE     Real  \
  -xSW   16025.641  -ySW        2564.103  -zSW   5000.000  -aSW   5000.000  \
  -xOBS    800.134  -yOBS         81.086  -zOBS   800.134  -aOBS   800.134  \
  -xCAR      4.773  -yCAR        116.682  -zCAR     8.316  -aCAR     8.316  \
  -xLAB        Htr  -yLAB            Ntr  -zLAB        Hz  -aLAB        Ha  \
  -ndim          2  -aq2D        Complex  -nusDim       4                   \
| nmrPipe  -fn POLY -time                                  \
| nmrPipe  -fn EXT -xn 960 -sw                             \
| nmrPipe  -fn SP -off 0.4 -end 0.98 -pow 2 -elb 15 -c 0.5 \
| nmrPipe  -fn ZF -zf 1 -auto                              \
| nmrPipe  -fn FT                                          \
| nmrPipe  -fn PS -p0 139 -p1 0 -di                        \
| nmrPipe  -fn FLATT -x1 14.5ppm -xn 5.2ppm -noauto -m 1   \
              -fitNodes 14.5ppm to 10.5ppm, 6ppm to 5.2ppm \
| nmrPipe  -fn POLY -auto -ord 1 -x1 14.5ppm -xn 5.2ppm    \
| nmrPipe  -fn EXT -x1 10.8ppm -xn 6.0ppm -sw              \
| nusExpand.tcl -in stdin -out stdout -aqORD 0             \
              -sample nuslist -sampleCount 5482            \
| pipe2xyz -out ft1/test%04d.ft1 -a

rm -fr prof*.dat



