#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Feb 23 09:41:23 2021
comprova que les mitjanes del datset 0.9 siguin iguals que les noves
exclou els parells eliminats
crea el nou dataset 1.0

@author: carme
"""



#IMPORTS


import pandas as pd


#Establim el directori arrel
rootdir = "//home/carme/Desktop/STS/analisi"
#os.chdir(rootdir)

# llegim el dataset original com a dataframe de referència
df_ref = pd.read_csv("sts_dataset.tsv", delimiter="\t")


def comprova_mitjanes(df, infile):
    
    
    # iniciem el comptador
    c = 0
    # a cada fila mirem la id i l'avg
    for k,row in df.iterrows():
        id = df.loc[k,"id"]
        avg = df.loc[k,"avg"]
        
        # busquem al df de referència la fila amb aquesta id
        rslt = df_ref[df_ref["id"] == id]
       
        # si al dt de referència està marcada com a excluded, ho anotem a avg i augmenetem el comptador
        if rslt.iloc[0,11] == "excluded":
            df.loc[k,"avg"] = "exc"
            c += 1
            
        # ens assegurem que les mitjanes siguin iguals. si no és el cas, avisa.
        elif rslt.iloc[0,9] != avg:
            print("problema:", df.loc[k,"id"], df.loc[k,"avg"], rslt.iloc[0,9])
                   
    # fem un nou df amb les que no han estat marcades com a excloses, i el retornem        
    new_df = df[df["avg"] != "exc"]
    print(infile, "-- S'han exclòs", c, "parells de frases")
    return new_df
            
            
        
    
    
def fes_els_nous_datasets(infile, outfile): 
    
    # obrim el fitxer que volem comprovar
    df = pd.read_csv(infile, names=["id", "sentence1", "sentence2", "avg"], delimiter="\t")
    # obtenim el dataset sense les excloses
    new_df = comprova_mitjanes(df, infile)
    #creem el nou fitxer i hi imprimim el nou dataset
    t = open(outfile, "w")
    new_df.to_csv(outfile, sep='\t')
    t.close()


fes_els_nous_datasets("zeronou/sts_cat_dev_v0.9.tsv", "sts_cat_dev_v1.tsv")
fes_els_nous_datasets("zeronou/sts_cat_test_v0.9.tsv", "sts_cat_test_v1.tsv")
fes_els_nous_datasets("zeronou/sts_cat_train_v0.9.tsv", "sts_cat_train_v1.tsv")
