# Generated by Django 2.2.4 on 2020-09-28 18:55

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import script.models.enums
import script.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='County',
            fields=[
                ('name', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('total_session', models.IntegerField()),
                ('total_energy', models.FloatField()),
                ('peak_energy', models.FloatField()),
            ],
            options={
                'db_table': 'script_county',
            },
        ),
        migrations.CreateModel(
            name='LoadForecastConfig',
            fields=[
                ('config_name', models.CharField(max_length=100, primary_key=True, serialize=False)),
                ('aggregation_level', models.CharField(choices=[('STATE', 'state'), ('COUNTY', 'county'), ('ZIP', 'zip')], default=script.models.enums.AggregationLevel('county'), max_length=10)),
                ('num_evs', models.IntegerField(validators=[script.validators.validate_positive])),
                ('choice', models.CharField(max_length=30)),
                ('fast_percent', models.FloatField()),
                ('work_percent', models.FloatField()),
                ('res_percent', models.FloatField()),
                ('l1_percent', models.FloatField()),
                ('public_l2_percent', models.FloatField()),
                ('res_daily_use', models.FloatField()),
                ('work_daily_use', models.FloatField()),
                ('fast_daily_use', models.FloatField()),
                ('rent_percent', models.FloatField()),
                ('res_l2_smooth', models.CharField(max_length=30)),
                ('week_day', models.CharField(max_length=30)),
                ('publicl2_daily_use', models.FloatField()),
                ('mixed_batteries', models.CharField(max_length=50)),
                ('timer_control', models.CharField(max_length=30)),
                ('work_control', models.CharField(max_length=30)),
            ],
            options={
                'db_table': 'script_config_ev_load_forecast',
                'unique_together': {('aggregation_level', 'num_evs', 'choice', 'fast_percent', 'work_percent', 'res_percent', 'l1_percent', 'public_l2_percent', 'res_daily_use', 'work_daily_use', 'fast_daily_use', 'rent_percent', 'res_l2_smooth', 'week_day', 'publicl2_daily_use', 'mixed_batteries', 'timer_control', 'work_control')},
            },
        ),
        migrations.CreateModel(
            name='Vehicle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('make', models.CharField(choices=[('NISSAN', 'Nissan'), ('CHEVROLET', 'Chevrolet'), ('AUDI', 'Audi'), ('BMW', 'BMW'), ('HONDA', 'Honda'), ('UNKNOWN', 'Unknown')], default=script.models.enums.VehicleMake('Unknown'), max_length=20)),
                ('model', models.CharField(max_length=30)),
                ('year', models.IntegerField(validators=[script.validators.validate_year])),
                ('battery_capacity', models.FloatField(validators=[script.validators.validate_positive])),
                ('ev_type', models.CharField(choices=[('PLUGIN', 'PLUGIN'), ('HYBRID', 'HYBRID'), ('UNKNOWN', 'UNKNOWN')], default=script.models.enums.EVType('UNKNOWN'), max_length=10)),
                ('max_power', models.FloatField(validators=[script.validators.validate_positive])),
            ],
            options={
                'db_table': 'script_vehicle',
            },
        ),
        migrations.CreateModel(
            name='ZipCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=5, validators=[script.validators.validate_zipcode])),
                ('county', models.ForeignKey(db_column='county', on_delete=django.db.models.deletion.CASCADE, to='script.County')),
            ],
            options={
                'db_table': 'script_zip_code',
                'unique_together': {('code', 'county')},
            },
        ),
        migrations.CreateModel(
            name='NetPresentValueConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField()),
                ('lf_config', models.ForeignKey(db_column='lf_config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadForecastConfig')),
            ],
            options={
                'db_table': 'script_config_cba_net_present_value',
                'unique_together': {('lf_config', 'year')},
            },
        ),
        migrations.CreateModel(
            name='LoadProfileConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('poi', models.CharField(choices=[('ALL', 'All'), ('WORKPLACE', 'Workplace'), ('DCFC', 'DC Fast Charger'), ('RESIDENTIAL', 'Residential'), ('PUBLIC_L2', 'Public L2'), ('UNKNOWN', 'Unknown')], default=script.models.enums.POI('Unknown'), max_length=20)),
                ('year', models.IntegerField()),
                ('day_type', models.CharField(choices=[('WEEKDAY', 'weekday'), ('WEEKEND', 'weekend'), ('PEAK', 'peak')], default=script.models.enums.DayType('weekday'), max_length=20)),
                ('lf_config', models.ForeignKey(db_column='lf_config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadForecastConfig')),
            ],
            options={
                'db_table': 'script_config_cba_load_profile',
                'unique_together': {('lf_config', 'poi', 'year', 'day_type')},
            },
        ),
        migrations.CreateModel(
            name='LoadControllerConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rate_energy_peak', models.FloatField(validators=[script.validators.validate_positive])),
                ('rate_energy_partpeak', models.FloatField(validators=[script.validators.validate_positive])),
                ('rate_energy_offpeak', models.FloatField(validators=[script.validators.validate_positive])),
                ('rate_demand_peak', models.FloatField(validators=[script.validators.validate_positive])),
                ('rate_demand_partpeak', models.FloatField(validators=[script.validators.validate_positive])),
                ('rate_demand_overall', models.FloatField(validators=[script.validators.validate_positive])),
                ('county', models.ForeignKey(db_column='county', on_delete=django.db.models.deletion.CASCADE, to='script.County')),
            ],
            options={
                'db_table': 'script_config_load_controller',
                'unique_together': {('county', 'rate_energy_peak', 'rate_energy_partpeak', 'rate_energy_offpeak', 'rate_demand_peak', 'rate_demand_partpeak', 'rate_demand_overall')},
            },
        ),
        migrations.CreateModel(
            name='GasConsumptionConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField()),
                ('lf_config', models.ForeignKey(db_column='lf_config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadForecastConfig')),
            ],
            options={
                'db_table': 'script_config_cba_gas_consumption',
                'unique_together': {('lf_config', 'year')},
            },
        ),
        migrations.CreateModel(
            name='EmissionConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField()),
                ('lf_config', models.ForeignKey(db_column='lf_config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadForecastConfig')),
            ],
            options={
                'db_table': 'script_config_cba_emission',
                'unique_together': {('lf_config', 'year')},
            },
        ),
        migrations.CreateModel(
            name='Driver',
            fields=[
                ('id', models.CharField(max_length=7, primary_key=True, serialize=False)),
                ('zipcode', models.ForeignKey(db_column='zipcode', on_delete=django.db.models.deletion.CASCADE, to='script.ZipCode')),
            ],
            options={
                'db_table': 'script_driver',
            },
        ),
        migrations.CreateModel(
            name='CostBenefitConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField()),
                ('lf_config', models.ForeignKey(db_column='lf_config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadForecastConfig')),
            ],
            options={
                'db_table': 'script_config_cba_cost_benefit',
                'unique_together': {('lf_config', 'year')},
            },
        ),
        migrations.CreateModel(
            name='ChargingStation',
            fields=[
                ('id', models.CharField(max_length=6, primary_key=True, serialize=False)),
                ('zipcode', models.ForeignKey(db_column='zipcode', on_delete=django.db.models.deletion.CASCADE, to='script.ZipCode')),
            ],
            options={
                'db_table': 'script_charging_station',
            },
        ),
        migrations.CreateModel(
            name='ChargingSession',
            fields=[
                ('id', models.CharField(max_length=9, primary_key=True, serialize=False)),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField()),
                ('session_time', models.IntegerField()),
                ('charging_time', models.IntegerField()),
                ('driver', models.ForeignKey(db_column='driver', on_delete=django.db.models.deletion.CASCADE, to='script.Driver')),
            ],
            options={
                'db_table': 'script_charging_session',
            },
        ),
        migrations.CreateModel(
            name='ChargingPort',
            fields=[
                ('id', models.CharField(max_length=6, primary_key=True, serialize=False)),
                ('connector', models.CharField(choices=[('CHADEMO', 'CHAdeMO'), ('COMBO', 'Combo'), ('J1772', 'J1772'), ('UNKNOWN', 'Unknown')], default=script.models.enums.ChargingConnector('Unknown'), max_length=20)),
                ('station', models.ForeignKey(db_column='station', on_delete=django.db.models.deletion.CASCADE, to='script.ChargingStation')),
            ],
            options={
                'db_table': 'script_charging_port',
            },
        ),
        migrations.CreateModel(
            name='ChargingInterval',
            fields=[
                ('id', models.CharField(max_length=9, primary_key=True, serialize=False)),
                ('peak_power', models.FloatField(validators=[script.validators.validate_positive])),
                ('avg_power', models.FloatField(validators=[script.validators.validate_positive])),
                ('energy', models.FloatField(validators=[script.validators.validate_positive])),
                ('start_time', models.DateTimeField(validators=[script.validators.validate_positive])),
                ('duration', models.IntegerField(validators=[script.validators.validate_positive])),
                ('session', models.ForeignKey(db_column='session', on_delete=django.db.models.deletion.CASCADE, to='script.ChargingSession')),
            ],
            options={
                'db_table': 'script_charging_interval',
            },
        ),
        migrations.CreateModel(
            name='NetPresentValue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.NetPresentValueConfig')),
            ],
            options={
                'db_table': 'script_algorithm_cba_net_present_value',
                'unique_together': {('config',)},
            },
        ),
        migrations.CreateModel(
            name='LoadProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadProfileConfig')),
            ],
            options={
                'db_table': 'script_algorithm_cba_load_profile',
                'unique_together': {('config',)},
            },
        ),
        migrations.CreateModel(
            name='LoadForecast',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('residential_l1_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('residential_l2_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('residential_mud_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('work_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('fast_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('public_l2_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('total_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadForecastConfig')),
            ],
            options={
                'db_table': 'script_algorithm_ev_load_forecast',
                'unique_together': {('config',)},
            },
        ),
        migrations.CreateModel(
            name='LoadController',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uncontrolled_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('controlled_load', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.LoadControllerConfig')),
            ],
            options={
                'db_table': 'script_algorithm_load_controller',
                'unique_together': {('config',)},
            },
        ),
        migrations.CreateModel(
            name='GasConsumption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.GasConsumptionConfig')),
            ],
            options={
                'db_table': 'script_algorithm_cba_gas_consumption',
                'unique_together': {('config',)},
            },
        ),
        migrations.CreateModel(
            name='Energy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField(validators=[script.validators.validate_year])),
                ('month', models.IntegerField(validators=[script.validators.validate_month])),
                ('energy', models.FloatField()),
                ('county', models.ForeignKey(db_column='county', on_delete=django.db.models.deletion.CASCADE, to='script.County')),
            ],
            options={
                'db_table': 'script_energy',
                'unique_together': {('county', 'year', 'month')},
            },
        ),
        migrations.CreateModel(
            name='Emission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.EmissionConfig')),
            ],
            options={
                'db_table': 'script_algorithm_cba_emission',
                'unique_together': {('config',)},
            },
        ),
        migrations.CreateModel(
            name='CostBenefit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', django.contrib.postgres.fields.jsonb.JSONField()),
                ('config', models.ForeignKey(db_column='config', on_delete=django.db.models.deletion.CASCADE, to='script.CostBenefitConfig')),
            ],
            options={
                'db_table': 'script_algorithm_cba_cost_benefit',
                'unique_together': {('config',)},
            },
        ),
    ]
