# Title     : bpic_15_cluster.R
# Objective : Cluster enriched event logs using FMMs (step 2)
# Created by: G. van Hulzen

library(flexmix)

wdir <- dirname(rstudioapi::getActiveDocumentContext()$path)
setwd(wdir)

# Read BPIC 15 enriched event logs from step 1.
bpi_15_1 <- readRDS("data/bpi_15_1_cleaned.RDS")
bpi_15_2 <- readRDS("data/bpi_15_2_cleaned.RDS")
bpi_15_3 <- readRDS("data/bpi_15_3_cleaned.RDS")
bpi_15_4 <- readRDS("data/bpi_15_4_cleaned.RDS")
bpi_15_5 <- readRDS("data/bpi_15_5_cleaned.RDS")

### Municipality 1 ###

bpi_15_1_mm <- stepFlexmix(formula = . ~ 1,
                           data = bpi_15_1,
                           k = 2:10,
                           nrep = 5,
                           model = list(FLXMRmultinom(Phase ~ .),
                                        FLXMRmultinom(Resource ~ .),
                                        FLXMRmultinom(CaseProcedure ~ .),
                                        FLXMRmultinom(CaseStatus ~ .),
                                        FLXMRmultinom(Weekday ~ .),
                                        FLXMCmvbinary(CaseParts_Aanleg ~ .),
                                        FLXMCmvbinary(CaseParts_Bouw ~ .),
                                        FLXMCmvbinary(CaseParts_Brandveilig ~ .),
                                        FLXMCmvbinary(CaseParts_FloraFauna ~ .),
                                        FLXMCmvbinary(CaseParts_Gebiedsbescherming ~ .),
                                        FLXMCmvbinary(CaseParts_HandelenInStrijd ~ .),
                                        FLXMCmvbinary(CaseParts_Kap ~ .),
                                        FLXMCmvbinary(CaseParts_InritUitweg ~ .),
                                        FLXMCmvbinary(CaseParts_Milieu ~ .),
                                        FLXMCmvbinary(CaseParts_Monument ~ .),
                                        FLXMCmvbinary(CaseParts_Reclame ~ .),
                                        FLXMCmvbinary(CaseParts_Sloop ~ .)),
                           verbose = TRUE,
                           control = list(verbose = 1, tolerance = 1e-06, iter.max = 500))

### Municipality 2 ###

bpi_15_2_mm <- stepFlexmix(formula = . ~ 1,
                           data = bpi_15_2_cleaned,
                           k = 2:10,
                           nrep = 5,
                           model = list(FLXMRmultinom(Phase ~ .),
                                        FLXMRmultinom(Resource ~ .),
                                        FLXMRmultinom(CaseProcedure ~ .),
                                        FLXMRmultinom(CaseStatus ~ .),
                                        FLXMRmultinom(Weekday ~ .),
                                        FLXMCmvbinary(CaseParts_Aanleg ~ .),
                                        FLXMCmvbinary(CaseParts_Bouw ~ .),
                                        FLXMCmvbinary(CaseParts_Brandveilig ~ .),
                                        FLXMCmvbinary(CaseParts_Gebiedsbescherming ~ .),
                                        FLXMCmvbinary(CaseParts_HandelenInStrijd ~ .),
                                        FLXMCmvbinary(CaseParts_Kap ~ .),
                                        FLXMCmvbinary(CaseParts_InritUitweg ~ .),
                                        FLXMCmvbinary(CaseParts_Milieu ~ .),
                                        FLXMCmvbinary(CaseParts_Monument ~ .),
                                        FLXMCmvbinary(CaseParts_Reclame ~ .),
                                        FLXMCmvbinary(CaseParts_Sloop ~ .)),
                           verbose = TRUE,
                           control = list(verbose = 1, tolerance = 1e-06, iter.max = 500))

### Municipality 3 ###

bpi_15_3_mm <- stepFlexmix(formula = . ~ 1,
                           data = bpi_15_3_cleaned,
                           k = 2:10,
                           nrep = 5,
                           model = list(FLXMRmultinom(Phase ~ .),
                                        FLXMRmultinom(Resource ~ .),
                                        FLXMRmultinom(CaseProcedure ~ .),
                                        FLXMRmultinom(CaseStatus ~ .),
                                        FLXMRmultinom(Weekday ~ .),
                                        FLXMCmvbinary(CaseParts_Aanleg ~ .),
                                        FLXMCmvbinary(CaseParts_Bouw ~ .),
                                        FLXMCmvbinary(CaseParts_Brandveilig ~ .),
                                        FLXMCmvbinary(CaseParts_FloraFauna ~ .),
                                        FLXMCmvbinary(CaseParts_Gebiedsbescherming ~ .),
                                        FLXMCmvbinary(CaseParts_HandelenInStrijd ~ .),
                                        FLXMCmvbinary(CaseParts_Kap ~ .),
                                        FLXMCmvbinary(CaseParts_InritUitweg ~ .),
                                        FLXMCmvbinary(CaseParts_Milieu ~ .),
                                        FLXMCmvbinary(CaseParts_Monument ~ .),
                                        FLXMCmvbinary(CaseParts_Reclame ~ .),
                                        FLXMCmvbinary(CaseParts_RoerendeZaken ~ .),
                                        FLXMCmvbinary(CaseParts_Sloop ~ .)),
                           verbose = TRUE,
                           control = list(verbose = 1, tolerance = 1e-06, iter.max = 500))

### Municipality 4 ###

bpi_15_4_mm <- stepFlexmix(formula = . ~ 1,
                           data = bpi_15_4_cleaned,
                           k = 2:10,
                           nrep = 5,
                           model = list(FLXMRmultinom(Phase ~ .),
                                        FLXMRmultinom(Resource ~ .),
                                        FLXMRmultinom(CaseProcedure ~ .),
                                        FLXMRmultinom(CaseStatus ~ .),
                                        FLXMRmultinom(Weekday ~ .),
                                        FLXMCmvbinary(CaseParts_Aanleg ~ .),
                                        FLXMCmvbinary(CaseParts_Bouw ~ .),
                                        FLXMCmvbinary(CaseParts_Brandveilig ~ .),
                                        FLXMCmvbinary(CaseParts_Gebiedsbescherming ~ .),
                                        FLXMCmvbinary(CaseParts_HandelenInStrijd ~ .),
                                        FLXMCmvbinary(CaseParts_Kap ~ .),
                                        FLXMCmvbinary(CaseParts_InritUitweg ~ .),
                                        FLXMCmvbinary(CaseParts_Milieu ~ .),
                                        FLXMCmvbinary(CaseParts_Monument ~ .),
                                        FLXMCmvbinary(CaseParts_Reclame ~ .),
                                        FLXMCmvbinary(CaseParts_Sloop ~ .)),
                           verbose = TRUE,
                           control = list(verbose = 1, tolerance = 1e-06, iter.max = 500))

### Municipality 5 ###

bpi_15_5_mm <- stepFlexmix(formula = . ~ 1,
                           data = bpi_15_5_cleaned,
                           k = 2:10,
                           nrep = 5,
                           model = list(FLXMRmultinom(Phase ~ .),
                                        FLXMRmultinom(Resource ~ .),
                                        FLXMRmultinom(CaseProcedure ~ .),
                                        FLXMRmultinom(CaseStatus ~ .),
                                        FLXMRmultinom(Weekday ~ .),
                                        FLXMCmvbinary(CaseParts_Aanleg ~ .),
                                        FLXMCmvbinary(CaseParts_Bouw ~ .),
                                        FLXMCmvbinary(CaseParts_Brandveilig ~ .),
                                        FLXMCmvbinary(CaseParts_FloraFauna ~ .),
                                        FLXMCmvbinary(CaseParts_Gebiedsbescherming ~ .),
                                        FLXMCmvbinary(CaseParts_HandelenInStrijd ~ .),
                                        FLXMCmvbinary(CaseParts_Kap ~ .),
                                        FLXMCmvbinary(CaseParts_InritUitweg ~ .),
                                        FLXMCmvbinary(CaseParts_Integraal ~ .),
                                        FLXMCmvbinary(CaseParts_Milieu ~ .),
                                        FLXMCmvbinary(CaseParts_Monument ~ .),
                                        FLXMCmvbinary(CaseParts_Reclame ~ .),
                                        FLXMCmvbinary(CaseParts_RoerendeZaken ~ .),
                                        FLXMCmvbinary(CaseParts_Sloop ~ .)),
                           verbose = TRUE,
                           control = list(verbose = 1, tolerance = 1e-06, iter.max = 500))