#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# rsmtool documentation build configuration file, created by
# sphinx-quickstart on Wed Jul 20 09:24:36 2016.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys
from datetime import datetime

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('..'))

from rsmtool.version import __version__ as version  # isort:skip


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.

extensions = ['sphinx.ext.autodoc', 'sphinx.ext.viewcode',
              'sphinx.ext.mathjax', 'sphinx.ext.napoleon']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Rater Scoring Modeling Tool'
current_year = datetime.now().year
copyright = f'{current_year}, Educational Testing Service'
author = 'Nitin Madnani, Jeremy Biggs, and Anastassia Loukina'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
# version = rsmtool.version.__version__
# The full version, including alpha/beta/rc tags.
release = version

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store',
                    'add_dash_anchors.py'
                    'builtin_models.rst',
                    'column_selection_rsmtool.rst',
                    'config_rsmcompare.rst',
                    'config_rsmeval.rst',
                    'config_rsmpredict.rst',
                    'config_rsmsummarize.rst',
                    'config_rsmtool.rst',
                    'intermediate_files_rsmeval.rst',
                    'intermediate_files_rsmtool.rst',
                    'tutorial_rsmcompare.rst',
                    'tutorial_rsmeval.rst',
                    'tutorial_rsmpredict.rst',
                    'tutorial_rsmsummarize.rst',
                    'usage_rsmcompare.rst',
                    'usage_rsmeval.rst',
                    'usage_rsmpredict.rst',
                    'usage_rsmsummarize.rst']


# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# concatenate both the  class’ and the __init__ method’s docstring and insert
autoclass_content = 'both'

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
on_rtd = os.environ.get('READTHEDOCS', None) == 'True'
for_dash = os.environ.get('DASH', None) == 'True'
if not on_rtd and not for_dash:
    import sphinx_rtd_theme
    html_theme = 'sphinx_rtd_theme'
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
elif for_dash:
    import alabaster
    html_theme = 'alabaster'
    html_theme_path = [alabaster.get_path()]
    html_theme_options = {
        'nosidebar': True
    }

# copy over any static assets
html_static_path = ['assets']

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'RSMTool', 'RSMTool Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'RSMTool', 'RSMTool Documentation',
     author, 'RSMTool', 'One line description of project.',
     'Miscellaneous'),
]
