# Additional Resources / Readings

## Git

* ["Git for humans"](https://speakerdeck.com/alicebartlett/git-for-humans)
  - slides from Alice Bartlett on the essential *concepts* of Git

* ["How to Write a Git Commit Message"](https://chris.beams.io/posts/git-commit/)
  - blogpost from Chris Beams about writing good commit messages

* ["Version Control with Git"](https://swcarpentry.github.io/git-novice/)
  - Software Carpentry lesson on Git

* ["git - the simple guide"](https://rogerdudler.github.io/git-guide/)
  - guide from Roger Dudler on essential Git commands for the command line
  
* ["How to Use Git/GitHub with R"](https://rfortherestofus.com/2021/02/how-to-use-git-github-with-r/)
  - guide from David Keyes on an initial setup of Git/GitHub for R users

## Github

* ["Friendly Github Workshop"](https://kirstiejane.github.io/friendly-github-intro/)
  - website from Kirstie Whitaker on getting started in GitHub
  
* "Developing Collaborative Documents: Friendly Introduction to GitHub" [slides](https://docs.google.com/presentation/d/1_bmRZcLwQrUkVTAMvq7W_x4ML_aphSwVEnkLrDy-Fd4/edit?usp=sharing) and [video](https://youtu.be/QRUvQgKbVZQ)
  - from Open Life Science training materials on GitHub and GitHub Pages lesson

## Advanced Git (collaboration, debugging, etc.)

* ["Understanding the GitHub flow"](https://guides.github.com/introduction/flow/)
  - GitHub documentation for a workflow for collaborative teams using Git branches and GitHub pull requests

* ["Oh Shit, Git!?!"](https://ohshitgit.com/)
  - guide from Katie Sylor-Miller on common troubleshooting fixes for Git

## Other

* ["Happy Git and GitHub for the useR"](https://happygitwithr.com/)
  - Detailed instructions and workflows for installing Git, connecting it with GitHub, and configuring RStudio to work with Git and GitHub

* ["Markdown Cheatsheet"](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet)
  - A guide from Adam Pritchard on formatting of Markdown documents

* ["Choose an Open Source License"](https://choosealicense.com/)
  - A guide for selecting an open source license
