# Introduction

These are the raw results that were used to present the results in:

 Matthew Bradbury, Arshad Jhumka, Tim Watson, Denys Flores, Jonathan Burton and Matthew Buttler.
 Threat Modelling Guided Trust-based Task Offloading in Resource-constrained Internet of Things Systems.

Generating the graphs requires scripts from: [iot-trust-task-alloc](https://github.com/MBradbury/iot-trust-task-alloc)

# Reproducing Results

In order to reproduce the results, the setup instructions provided at [iot-trust-task-alloc](https://github.com/MBradbury/iot-trust-task-alloc) should first be followed.

Then the test scripts in tests/run need to be edited to match the configuration used for these experiements. Six nodes were used, one configured as the root, two as edges and three as wsn nodes.

## Profile

To build profile firmware for ECC Sign and Verify:
```bash
cd wsn/profile
make TARGET=zoul PLATFORM=remote-revb PROFILE_ECC=1
```

To build profile firmware for AES-CCM:
```bash
cd wsn/profile
make TARGET=zoul PLATFORM=remote-revb PROFILE_AES=1
```

## Two Good Edge nodes

Building and deploying:
```bash
./tools/setup.py basic_with_reputation banded --applications routing monitoring --with-pcap
```

The start script for edge needs to be the same on both rr2 and rr6 to contain the correct configurations.

On both rr2 and rr6:
```bash
nohup python3 -m tools.run.edge --application monitoring 2 --application routing 0 &
```

## One Good Edge and One Bad Edge

The start script for edge needs to be edited differently on rr2 and rr6 to contain the correct configurations.

On rr2:
```bash
nohup python3 -m tools.run.edge --application monitoring 2 --application routing 0 &
```

On rr6:
```bash
nohup python3 -m tools.run.edge --application monitoring 2 --application bad_routing 0 " --duration inf  --approach random" &
```

## With DoS Adversary

```bash
./tools/setup.py basic_with_reputation banded --applications routing monitoring --with-pcap --with-adversary dos_certificate_verification
```

On wsn5 instead of running `tests/run/wsn.sh` run `tests/run/adversary.sh`.

## With DoS Adversary and Small Buffer

```bash
./tools/setup.py basic_with_reputation banded --applications routing monitoring --with-pcap --with-adversary dos_certificate_verification --defines MESSAGES_TO_SIGN_SIZE 2 --defines MESSAGES_TO_VERIFY_SIZE 2
```

## With Aggressive Information Removal on unannounce/capability remove

```bash
./tools/setup.py basic banded --applications routing monitoring --with-pcap --defines BAND_SIZE 0.5f --defines AGGRESSIVE_REMOVAL_ON_UNANNOUNCE 1
```

On rr6 with `capability remove`:
```bash
nohup python3 -m tools.run.edge --application monitoring 2 --application bad_routing 0 " --duration inf --fake-restart-type application --fake-restart-duration 180 --fake-restart-period 1800 --approach random" &
```

On rr6 with `unannounce`:
```bash
nohup python3 -m tools.run.edge --application monitoring 2 --application bad_routing 0 " --duration inf --fake-restart-type server --fake-restart-duration 180 --fake-restart-period 1800 --fake-restart-applications envmon --approach random" &
```

## With Lasy Information Removal on unannounce

```bash
./tools/setup.py basic banded --applications routing monitoring --with-pcap --defines BAND_SIZE 0.5f --defines NO_ACTIVE_REMOVAL_ON_UNANNOUNCE 1 
```

On rr6:
```bash
nohup python3 -m tools.run.edge --application monitoring 2 --application bad_routing 0 " --duration inf --fake-restart-type server --fake-restart-duration 180 --fake-restart-period 1800 --fake-restart-applications envmon --approach random" &
```

# Generating Graphs and Tables

## Table 4

```bash
make -C wsn TRUST_MODEl=basic TRUST_CHOOSE=banded
./tools/binprof.py wsn/node/node.zoul
```

## Table 5

```bash
./analysis/parser/profile_pyterm.py --log-dir results/2020-08-28-profile
./analysis/parser/profile_pyterm.py --log-dir results/2020-09-01-profile-aes-ccm
```

## Figure 10

```bash
./analysis/graph/trust_choose_evolution.py --log-dir results/2021-02-09-pm-dadspp-two-good --ax2-ymax 12
```

## Figure 11

```bash
./analysis/graph/trust_choose_evolution.py --log-dir results/2021-02-09-pm-dadspp-one-good-one-bad --ax2-ymax 12
```

## Figure 12 and 13

```bash
./tools/regenerate_pcaps.py results/2021-02-09-pm-dadspp-two-good --timeout None
./analysis/graph/messages.py --log-dir results/2021-02-09-pm-dadspp-two-good --tx-ymax 140000 --rx-ymax 55000
```

## Figure 14 and 15

```bash
./tools/regenerate_pcaps.py results/2021-02-09-pm-dadspp-one-good-one-bad --timeout None
./analysis/graph/messages.py --log-dir results/2021-02-09-pm-dadspp-one-good-one-bad --tx-ymax 140000 --rx-ymax 55000
```

## Table 6

```bash
./analysis/parser/wsn_pyterm.py --log-dir results/2021-02-09-pm-dadspp-two-good
./analysis/parser/wsn_pyterm.py --log-dir results/2021-02-09-pm-dadspp-one-good-one-bad
./analysis/parser/wsn_pyterm.py --log-dir results/2021-02-09-am-dadspp-two-good-dcv
./analysis/parser/wsn_pyterm.py --log-dir results/2021-02-09-am-dadspp-two-good-dcv-small-ver-buf
```

## Figure 16 and 17

```bash
./analysis/graph/trust_choose_evolution.py --log-dir results/2021-02-26-pm-capability-remove-attack-capability --ax2-ymax 20
./analysis/graph/trust_choose_evolution.py --log-dir results/2021-02-26-pm-capability-remove-attack-server --ax2-ymax 20
./analysis/graph/trust_choose_evolution.py --log-dir results/2021-02-26-pm-capability-remove-attack-server-lazy --ax2-ymax 20
```
