const ColorMapPresetIcons = new Map()

ColorMapPresetIcons.set(
  'Viridis (matplotlib)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAxklEQVQ4T+WTUU4DMQxEnxPbaZseq0fo/c9BuxsHZQOtKoQECJAQH6OZJF+jvJGTnHvyghRH3MFtyozuCpYJU7olwkdOhAmhMv2WmXc6HMKgv2a95659ex8+xE1B0iBroNowbbg2iq6UvLLTlV1e2OvCIV/Z54WaL1uu6bLpmIc/cZSXc7pSpVFFqMk4SEFOco7/Vrh9uLBlmif6H//h9d3CprBh/DWkJ7oT8bt/M9I6sP0c0subwjZ3/JMbjof9ji3/zoafAa6pEjNEHZsCAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Plasma (matplotlib)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAt0lEQVQ4T9WTy25DIQxEjy9g0yr57nx0AFc87iZKlAh10S5GM2Y3Ooxc880vLfFN5MsjmYh5GMocmE/pyIIhqIAJ00NDo6OpoakOpdi9kJbiQ46x0N9OhVRHDuut30Hn3fOhhaNnLYiue2XRAlaZ3nCr+HDHDaoJLcvyO3LNt7ZbeJT+h4XrbuEtwg90J9lfIpwbru8Jl93Cf5pwdlyff+n7buEtwn2nLzZ87vijDVtB0rndzzf8A9HeIj3mfi1WAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Inferno (matplotlib)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAv0lEQVQ4T+WTwU4DMQxEX+ys7Syl0P7/l252YxRVVOLUA4gicRi9uY5mpkBNKY5IQ6Wx6IrJ1AvGirMS2fA0Ig0visuU4FJw5Sb5ZOKSmA5cBn7ngeuB6X6n1Y7VHVs6y6R16vS2Uaf3jtqGRkd9Q6aiU2KnRFJCIRwiyNbIWBntxIgTo50Z8Ub6heJXql2w5Z0Cdfy3wMdTA+ut2d9seH9q4B+ddGO014eT7n8p8LJ06vzw5Pzutz58Jv365cMfOKjLEgYA0aMAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Magma (matplotlib)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAwElEQVQ4T9WT20oEMRAFqy9JJ7P//7VuJtKJioKswojiQ3E6j8XJEfCpUlHtmHXcOiXRg6oHRW6EHMRMOm0GQSHUCdWNCdVkZSj7rZMw9nvdc6eeG3vNQdggfFAXd0oZlDrwOBfWQBeKLAxpjvQCLanviH1HY7a8M9vKRMDP68JKTbmHwin+IvnHwuO68MWGdRDlNxruq+H7deH/1fDTI2GXG+2LDb/tN7+0QPhPbPiOx/xkw7L3+60N527jw4afARTJfpA8jM5iAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Grayscale',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAYklEQVQ4T8VSSQrAQAjLoOP//9uV3EopRU2hJz1kRQeAw90x5wRnZ+9w/vIbAHY1sMqvllf8WHhTBLpfUS15xSt5WXjNCJgZIuLx7TP8LzF3LeZivowHCy8Z4BtG5VevrfidE8UT6MnfR0YAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'X Ray',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAYUlEQVQ4T8VSSwqAUAj03f/GT21idhER6gStdDFfdAFARJi7G+dkn3D+8lsADjWwyu+WV/xYOBWB6Vd0S17xSl4WjopAZtre+/HtK/wvMXct5mK+igcLewX4hlH53WsrficmEnokOp1YogAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'BkMa',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAY0lEQVQ4T8WSSQqAQAwEa5jl//91pW8iIpm04Ck59EpSgKPR6HQ0M3uG85dfAXY3sMufLe/4qfDmCGS/YrbkFe/kVeE1IlCpDMbj20f4X2LuWsqlfBEPFV4iwDeMy5+9tuN3AmHODu0pCn69AAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'BkCy',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAVklEQVQ4T2NkYGD4z8DCwsDAysoApslhk6NngOxjZGBg+EeWJ5EdPMQ8/HekefgPUR5mZmZgYGPDnuwHOoZB7gK5jwh3gJL0b2IU4lVDhEUU20GlLAQAXNMO7ZdYpGcAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'gray_Matlab',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAZ0lEQVQ4T92TSw6AMAhEy+few739hp0WNZKgMS66IQ3DPBgCsIhIY+bwquos3ISf1TibtdcmM5uPzHrtl4YBTFXG7lLeAn5b2zc8fnXDDoOIdlHLAgonDWDINsn+r8ywqgYIV/HrtVeUThPozHrNVQAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'bone_Matlab',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAjElEQVQ4T92T3QqDMAyFz88e2Gtfwgd2c5KOSaWdhYkoXpSEkDQJXw67fnjTgiQobO4vMYJfv5aXaojmP+KqhyWUjzDLeMy3yiUrte0cdv0wpUFri0YTC/S9Fn41yexe2JCZriC/orMIPy9F2IRx7EmP24SDDkoNPwQx1/1vDQfJT48dhG041+2fGp4Be5oT6CFo9DwAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'pink_Matlab',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAlUlEQVQ4T+VTyQ2AMAyzU/b/sAXTsA+n0jS09IM4hIR4IBfHIKW22XftQiEYBIaMiJLT826WtM4njN+UWor9p9ZROQEZ0iMA/Gxo764p58YBivU8c3le6fuunf+28HS4sLqurmzuf9vhsVxYgsX5UqT9Yjz+j0XaI5xjfifSw6HDsYMCrY71e++wpAt6r8MNAE3d+Q6v73kT6FKU6qEAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  '2hot',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAlElEQVQ4T+VTyw7DMAgzDdD2G/v/X7FHJq8gRUy7TJ2mqQcLMOFAjKVv6DAAXpAcY+2PPc6ZvMKDUwOaA00L2l6LA1PCgMkA0YgLgHVHj1wYiTl49pOLXJKLuaGWvuF+toVvhyxMRXVQ+iOFqax/XeHrIQvXs57jA3520nHWtEI56Qs0LDH6+J2HaR2+f3o34/94+AHB0CLoaujV1gAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'gist_earth',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAm0lEQVQ4T+WTzQrCQBCDv5n99cl66+P25dSOTDu1HgQRqpceQpJZWAgkMkyjNZ1palQl2LVR1GhidFE6QhOhOaNP3c3fEs7N9cKrL3MmzYVkZeUN4UUqUEH8V+fNV9AMmgK66xQ35xT3Rb8gZyjlLWSYxvlsge9nC3w7MvDFlPrvSnuFVfdaf6j09dvAHaXGno/bcAMpsenfbfgBpkt86Bn+d34AAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Haze',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAqklEQVQ4T8VUWxKDIAwMIelFPCjeuyZ2QpBSqy3OaPvBDIib1+4SeEgzogBFBY4KhJr3eaH4t3r2vf/nmGVxi4uS41RsufOz33Xhmnp4hct11DjPmOuclq/tK/AwKuL0/4apDLEd1DUNJ+lmOCgQncGwqWP2IX9SxjUNj1Nl+CX5jyW9ybBJtQzmPEmn+x7DEQVuux42G3gxX5k66GHLGd/ejcWnW+ro9/ADh/80vNSw528AAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Haze_green',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAlElEQVQ4T+VUQQ7DIAxLAqgv6vvYv1vCZAhtinacVk09RAE7gMAxvC65siiFpCSxkEQlCS4wR6RC3LK23AP11fiOoRb4OTa+4ZUYe9v6njt/1nu+Gj7yVBc8jn3s3AM3Prh16/JSlvKkC+dyn8JQhH6u8P4/CuOBnAU+tTSsKZMVri2dt/sU/paHR6dMHk72Z7gLvwEQyDHMFbb/rgAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Haze_lime',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAk0lEQVQ4T81TUQ6FMAjrgGt4CC/tJXXby4BFjPphosv7YqzpoCukeVoqUQFzBbFHKiDPe1T87r7zOPLsfHjXcdZ4jRu296K5hN5CLX1brOcDT/a88zue5mkpYwQDxNk/4SxYuCKpmO8F5zGCzSVzfYDDUkDktYLjzeFtjOD/cXh9W3Aczdd3uO0stWnJEAbSwx3+AWa2MkOC82ICAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Haze_cyan',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAp0lEQVQ4T+VU0Q7DIAikAvXFf3b/PcUF0LZZTLYs7fawBxK9E1A5WHJMTSiArAhCbhURBANI0D2BsFsjgkpsWO1rxdTGOcV3fnDcfT3O0ddi95jOsfGez3ONM+bHHZvmZShHfPPd77TcYpL6kwev0PSDv/3gHFP9twqX9yqMJrHzJH12hV3qLyWdY7pfUmHUfvuwh03m8x4u7PPA+efZwVA0J3Z80sMPESU1z7RU/B0AAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Black, Blue and White',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAXklEQVQ4T92TuwqAMAxFTwvmKtj//1ifgxVEsGToEodwlmQ4uUkCDhBgdGE2kMBaNDCBHvyYmZQpxlVqc3b0JGDvInovLIDwFl54hDKAN+E1vHA9da/w8kvhmvr770+O7xPo4c8kpAAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Black, Orange and White',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAYElEQVQ4T92TywqAMAwEx4K7Cvb/P9YnIj0olPbQSz2EuSSHySYDcBoQ0IQBbJDylMGCFzMzwTMoPuUCtRR7BuBoIpoW1oHw3r3wFGG8069LeOteOJ16pfD6S+GU+ufvL47vE+hPhfMGAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Black-Body Radiation',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAcklEQVQ4T82SyQrAIAxEn1FKl1Ohy/9/Z1dS7MGeDPXgIQTDMPiSccDVAx2g/a1S7yZE01KGnw9KGBFZYs1J917n6cwBpxV4ANrMBdUIfFiBLfoagXcLgGp/XVijrQaFIp4X6RWR6Ym7RnqzAlv0tV34BrWHE+gE36UrAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Cool to Warm',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAx0lEQVQ4T92TMW4DMQwE504idX/yF/xoP8d1kMQnUtIFlIN07hw4SDEYtotdLqfz5ZCtIEXvbIoWmbeWjJQ8rRpOqK53JLygEoAIaD6+GUgaaAp3dG3I2slL2Mk4gpN7JQ8jdyO1SmrG2upk8TuYgYUrR1CNYZWxV3o1engPG74b7Wb4zfHwp2Mfhr079taoV2c5nS/jYeAtIzPo/wrc81bQv9ZwtDybfX7D7eUNDyP5b0/aqdc2J+2PAv/879Mn3VCM9IIf/gLj9LxcOY7OJQAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Warm to Cool',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAA0ElEQVQ4T92Ty27CQBAEy96dGUgiznwB/3/g49iZfUQ2hhtKDkaKcij1uVXd0zVfhp0FPWX0S9BPRT4EOSpyFPKSByU9MZIp88GY1ZhMmdTgiTLEVnq+07LSslGTUmelJiMQKkJ0oY5M9IT3TLSEt5loM14XppUI8JWB+8Cj475RGu4VL5Uoj3S8BHFzomzcCtM1X/q/KrwUvy3FXxduuxdWY2x2/4phL07dDFc7Z/Qk75202H3O7570LwzH7oZ/+HBLhqNUlu/u++HHj19N+hshjKpp+CdA7QAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Cool to Warm (Extended)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAA30lEQVQ4T+WTu07EMAAEJ46fSUjLt93/F9BBiB3bceygO9HQQHOC4orVNtuMtNPB5VRWop2it5LeKqRTqEEjR3NrNWpuGytR7toK7QzmmuErVuMGyzgNzKNjniyTUYxaMhvJk1EMSjLLk+cuooRAxxda+KD6N9q6UJd3agi0sFF9oK4bx+IpfmPfIslvhHUjhkTyhZx2ci7kWEjpIB8dexXk1pNPTe40GUmmJwtBFj0dXNqjAddHAz7+D/iVFpY/v3S5B7C2muGbw47JyDs4vFJ8/NHhPRbiLw4nIdhFzydAO3orQqN1cQAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Warm to Cool (Extended)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAA6klEQVQ4T+WTvU7DMBRGz712k+bHLSwdkfJYfXck1KmV2HCakNiOUZgZIgaEYDgPcPR9R850uZJALQmnC04Tbhdpi0DbWOpGqWplf7QUzmCdxbQG0yi2MRin6EqtaLnDVCWmKbH1SoWpDtjqAS0fkfKEFCfEdFzME6954MrMLSVu0XKZLc/jwsuo+CGR+kj0C+IT2Sd0SORxQe4R6RPqwyf4mewD2U8sfiL1MzJO7Od3ah2RMKDxjsYeOdMt/004bRI+WIrDL174LZD7bQvHTcJ/6NLhK2FXBJqNDa8dy7caHrky/VjDEns+AEvpg4p+ccXrAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Blue to Red Rainbow',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAWUlEQVQ4T+WTwQrAIAxDnzDQ7f+/VTfmVil4ck7ZcfRQGpL2EJo6EFmBAGh/wzP9695CBlKtvYN7nM7P+LHuQG5rhi9rhnNr2ANbE+//RToCx+NVNNKnpQsX/Pif8u6bT0gAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Red to Blue Rainbow',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAWklEQVQ4T+WTUQuAIAyEPyFI+/+/1YqsidZDpBI+yh7GHdvu4djNCAg4wHJji//N+3SBiRVybQ++ea3X2u3RGYFLm+FTm+FQGp6B5RPvsSLtgb3yKinSh6YLRx8gn/KBGWDTAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'jet',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAUElEQVQ4T2Ns/1/xn5PhOwMHww8GEI3Mhonhohl+MDAwfGdgoDdNibWM7f8r/o00D/8daR7+Q8jDMHn0pE3zpAzLLmhpmNIk/ZuQh4dTHgYAGGMuhpYUxcAAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'rainbow',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAWUlEQVQ4T+WTzQqAMAyDv4Gw6fs/q244rRQ87YfiUXooDUl7CE0DgqxAArTPsKV/3VsqcLyVB3jE6bzFG3pAuL0ZvrwZrq3hCGxNvH8X6R0o/atopE9PF34Akwef8n4QTNkAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'hsv',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAWUlEQVQ4T2Nk+P//PwPDZwby8BcMfSwM3xl4GRiohlm+Y3EaprVEO5+R4f//f0SrxgiYoenhvyPNw39o5WEeBgYGPhKTN0g9SB8sW9AiSf+mlYepkZep7WEAn+jR8hNeDScAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Rainbow Desaturated',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAr0lEQVQ4T92TsQ6CMBRFDwkOJUFIEMfyOf3/mUldBSyB0EREQySRIgNs6PByXrud3HcdpdKnMZqm0Yw53lvfhSQCeQAZQTLh0QN9/p7y8xfvGmQISQAymDCE2AUyIB843TPQFeQVFLXNvIaigrZz2Qthje951ttRKu3+STgQAn8kPSf8+DnhPuk+1SHptQm3mxIugOvMeS886SUJ323hEmNuVp/XdfgC+vTu8wY7/ALmVGBoc5I6iwAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Cold and Hot',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAb0lEQVQ4T+WTzQpAUBBGz11Y4EEU74MHd9+CJRYXI39FISQWdzHN9E1NnZqjEBEqoIZNfytb3zEFoMeKyEjQxGgCJwcPcJn60by3v5kpRDrbgFvbgJs/gEMy0p9e2lwCHhwvH7j+hcP+7P/i84nXPT82uO2FaAb2AAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Rainbow Blended Black',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAeElEQVQ4T+WUywqAIBBFj61z3+P/P63aS7u0QlBQm1oVQS2G0etrLkdVwAYt0CHnZKxV+RRpmdeqCRguQ2OyU88q0DPgtxuLXGibqbH0uBBp22uxr4D1aDSa92V8z7B7k7BEtgeacOeeIGz/Rnh5k3D6eKRf5G7COyjIqVIQRHJVAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Rainbow Blended Grey',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAfklEQVQ4T+WTOwqAMBBEn9Z+Wj+nsvIW3lrtRciCX6IRQpBYiYXFMLtTDAw7G1R1s4lKEEk5WKWInKwcnRwOFIbt2dbCHmi9iBkerbRlPALarnPY0bYhYqZkMbBnrV17UNXN+rfAy5eB70pSApkp0hsXnr8M7PuOtyo9/SnwDu6XDWHq89sRAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Rainbow Blended White',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAcUlEQVQ4T+WTvQqAMAyEP53t7s/7P5rtXtysnhQUSil1Kg4O4ZIbDj6SdJLkHFgLJU09jcAEzLemfer1DlirZfCvUTHSbECMs5lmnvxAYOG4K+2j98ydpPNvwMeXwKUjWYB4TK02HL4Ern1HK+D9T8AX/1USYcw4csAAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'nic_CubicL',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAApUlEQVQ4T9WTSw6DMAwF59mBXo5TcUOuQ35VQoSKKnXFoiys8UtWT9Zo2dZqFpFFTI0Js71njRxUcCu4CqEzn3mSmBGzxITRc9/V984xAc73tocqvBMc4RXCoBewLKyAZzovOYEnHX/pGG/MQrGiCOwHW6ZxBy3bWu4o/JIIDymc7yj8pAunOwo/6cLxZ2FPBP7A4do8/XB6OPvtsKFYhsPN36vDbya36ax4ixSiAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'Spectral_lowBlue',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAgElEQVQ4T+WTQQ7EMAgDnf+/qQ8rBryCNFJ3L+05e7AYcwErZCgPIRNIAuFAEMiqDq2eT9/65fKtmJUBLV/MmD0rzi8uL6r7udgmp49WXLpzr8FrLDXH1/rFBtDVck+QAq36Ak9hKI/8t8CxU+AwwB5e2LcJXKfL55PmNoFf/OEPYpjKesZkFyMAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Yellow 15',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAnklEQVQ4T+WTsYoDMQwFx7v//7UXIlmy9YKdJdXBXZdii2GMDYZXTJOGpAfSD6UHYDRsW9WhHGn5Yna0cTQcFtMgDaV/rAwUyduxzfK6i3G9TRQT5aJQCkVRIdSLcOFWm9FhBMxc3zQ8Gz0bcXmdPRq2DVYnVgemA28n1k6cgyaNutvgebfB426D83+DY/fMbw2XQTxR9u81fHX9V8Mv8S3IResi7K8AAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Asymmtrical Earth Tones (6_21b)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAxUlEQVQ4T+WTS27DMAwFxxIp2UqPEeQCuf+lLMof2U0KJWkLdNFVUBTtYvDedvDI7ng6X8OQiOlAS58UNyguKT64Bx2iVzRckACx98TBf2br0ROkIUQVktwZVOhF6N9T/K1HUYJvBNQFfBcfJJw74LoX1mUnZyPnguURG/MtJzOWYsxmzGViKRPzVKhzZVsr21Kpa2Oj1sb+0bvj6Xz5b8Kvf1e43tf9svD+u4UL2Qwbn3fS248Kq6cXJYo8/4enyla//+E3Xh1NOvT2YcEAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Green-Blue Asymmetric Divergent (62Blbc)',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAA2klEQVQ4T+WTu1IDMRAEW1pJq/MFFEQmcuQv8P//DhHJPVeSeZUPJwQEEPEIpnrTrp1xh9PxNXWK5sSFqYvEHIldICRBkhDUv98qG/WarJ5ePTt19OrI13TRoyGQJW7UoGhMaIhkEVQCSZTgesTtEN/hfcb5TAi3hHRPkRseamEojcEa1hqlnSmtYdPKOs6s08wyTMzDxDJOlNm21KVQV6OZbaxlpdpCmR9xh9Px5b8JP/9V4WpGW4xaP3746WcJ3xHS/vNKnxs2fr3SxRbqtdLn7wtftiu/asNvehtHVE0BanQAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Muted Blue-Green',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAx0lEQVQ4T92TS27DMAxExxB/QoyeIOfJLvc/RbcSRVl2YbvpOi2KAs3iYUjuBsOZrrf7RmZIrEjEINFzZgURnzcSMAmE+FBlhbIdaiIw2dUwZ8PF8sGc9dxVkIWQJeGihLecMGeAqWKb3lF6gS8NbXS0JRDrglgHYhvwHvBoBzX2+aS1QPNdO7w6SnHU4vCHVofXhvZJj44H0/V2X79lmAVK/9vweMbwnrK+SMLLM4a/XvoFEu7JDPSDDgsr8i91OEaH/0GHPwChV7smZTI6wQAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'BkRd',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAYUlEQVQ4T8WSOwqAQAxE3+Lq/e+rrjKdCEqSEaySYr4kDTg6MAOalb3C+cuvAcMN7PKz5R0/Fd4dgepXZEte8U5eFd4iAhOwPLx9hP8l5q6lXMoX8VDhNQJ8w7j87LUdvxO00gny7iMvrwAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'BkGn',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAVUlEQVQ4T2NkYGD4z8DCwMDAysAApslhk6NngOxjZGBg+EeWJ5EdPMQ8/HekefgPUR5mZmBgYMOR7Ac6hkHuArmPCHeAkvRvYhTiVUOERRTbQaUsBACv1wnyhDHKpwAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'BkBu',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAVUlEQVQ4T2NkYGD4z8DAwsDAwMoAoclhk6NnYOxjZGBg+EeeJ5EdPLQ8/HekefgPcR5mZmBgYMOR7Ac6hkHuArmPsDtASfo3MQrxqyFsEeV2UCcLAQCq3AnypgxRmwAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'Purples',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAj0lEQVQ4T+VTWwrDMAyT5N3/AP3oeXqnbd2w0oQWCn2MMUY/gm3ZmBhJ7LvhJREKwXGeR9YTvtKPOn8ykoRIUEDLCf8ha2bufs6VmXmOiiWOqd8wA95Rdzn23TBe7eDnJwdHFDaaOg6w/SuGH9sHC7K8l5L/V0nffchN9st5D6fXi//2vsqwAmm44tcve/gNvYMTu+Wg0JMAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'Oranges',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAhElEQVQ4T9VT0Q6AIAg81P7KX/SLy2oQFA/W1uaaPTDGIeANjmrJG0IEYoJ4b5Fjh0vsMJ+XejPrp7VnTmttFmk/54n7N3CZy7jkAkBtoxvc3lMtee1LeDo+5EkORrj2JaxbTQmgMTe89CX8csMsC1yn/cVJz4+E+RxNU7/RMGudmjrfASUoE1Iv4qLWAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'PuBu',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAmUlEQVQ4T+VTQQ7DIAyLk+/3zJP6qXZrFScwtE4TEr1MO1QOxESY2ljKesAgUBUlQmBK5DprR2UvuI6+5odAU2l122NPGs8aP/Ysz9Y57HczP3E4DxD4WUhiX0vcn5zKTVzK+vw3wY9pwfmav/KH9zHBRmveZmkLi32ztNvbrfnOmbX0Nib4muF6oWuGldl65e++DLt4TGT4BCECE6fvwvj3AAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'BuPu',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAhElEQVQ4T+WTSw6AIAxEZ4pH9lKexgP5DS0tkrjDjbqizJuSFBiO03wMJJIQiYDXuhZ9IApn8KtX1Fs91georue23HTjIoyVRLOv3HRmv/Yg6tyTdWNeV7/zYOM0738beOsaOBGCd73wej+wxDf92pdeul64ZLBm2C/qgQx7vku2n8jwCVBxE6z5mXacAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'BuGn',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAjElEQVQ4T+VTSQqAQAxLOv7a73n0R66kVUcUQVBE8VDSHUoalnU1JA6QFUILX2YH+bkePUQiYbSVP+cyLn2IXs1QhpgTKlbNowmpvcps8j6zqin2TsepttnvM2Vd9X87uNsfDCT2tzBciBkis/8ChttDhvXe2L/611+6ufzSFvrJen5KwwkGhJZPangEi8xdZol1lYAAAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'GnBu',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAlElEQVQ4T+VTWw6DMAzzo2flZJyEa409lLTAmKYNJDQJTf1w6qQfbmx2Q38vFCxjQcMSTKOsUCgyvJpXfcfoNcz+G67x07xIkITiRA0milrqqFj7yc6INhOI5CsC+nTvhv72b4Kv2wVPG392xPk2PG4XLBQbxvGCHV78kaUvuwR/y7CEkh/ymuHIPpPfm+HM9EEZfgBX1hOn6/4s/AAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'PuRd',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAfElEQVQ4T+VTyw7AIAhr0f3rfsuv9LBnRBbN5smDS7YDKdRCJA2MczjgCXgBE7qcK+cIVnlTI6YT5N4UysEw11T+phEBUtDQaj741NvQklAtr3farILU2VUd57A3F57sox9ceBvrsBT3X3J4/ZvDy1iHqzvvcbi++Y4bPgEMFROEHSZGdgAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'RdPu',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAnElEQVQ4T+VTWw7DIAyzDTsq9+NG3T26wUQCVVmlaR/dpGkfKOSBURKbS8q1BqFEwmx4sj1+yEWvpQQGAqLZ2Re4i8Pycx2DoBELjqWOOd8dS+MPwrHYDtya73fDHHHL9Zol5fKy4QtRpeMwfrjh+79t+Pb5DTsdB6UbLbHR9suUvqa8lrM0HJtu9pp+V8PtDdD0PHRrQ5n0fI6GH7KlXmuUkZHCAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'RdOr',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAjUlEQVQ4T9VT0Q6DMAi8o/3JfpRfbKdLEbRdfJBkW/SBAAchOQ5Yp7IiJeyWE6i5HFhfH2IBpDPyyOk4gT0Wi62PCWgm5i2m9o+Yzhh6LXdcvYA686y24axTWeKEsy3kmYRfccJ+EUa4XYNu9VcK5232lxSuccJ3U9gXcu2k5zjhD4X9j0MKd7/2xx9+A3wmE2GgDJ73AAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'BuRd',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAq0lEQVQ4T+VTMQ7DQAjz9f/vPSmATUVpmg4d0uoydUA2iMWyPeaceUsCDAzFgQoMBiAHwgHWxBvve4Yh3Zp78/2W7pA7aAFZ88LH/rrHY++fg9OLE3Q11mw9YYJTMBYmPHr3SFgIpoQxsRXqQMvEmHPq3wRziWA60q5wuFwV6ITK3QUOxxLBiyJdsY6K9leR5jPa5yLtnwUTo3p7cYdzF/hLh6u7OtthwRK4A4HRK8JPJN7MAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'GnRP',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAApklEQVQ4T+VTQQrDMAxz///fHCrJHYqTtgw2NjrYYAcjWclFyFpaa1tkRCpj09YnO9Zu7rdkhsyZtQ8u62N44qK6TiO0o/VdQ711bXL/7ZyhVZFrYU1xgjVEkMbTDgasayDRd4hBIZbWWv6bYV02rAzBaR5p/2LCGAnzsmGfOTPwDcM+bZ/rPPEXThpPDefo7V2H3e/qrnH29dMJZ+SKtzqMafxBh28D+XLa7dKmVQAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'GYPi',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAl0lEQVQ4T+VTywoCMRBL//9/rbuTZKSdouhBRPew4CHk0VPopPV+yWYABpoTcKL84PITSqQeGvLMkyM3kgtTV+YQMgQHX3jkhPdC7rrr8uttI7wRug4OuHNCG0EWJJWO5UMIEWGCk1V6cev94n8rrMMLj2vgeX+Yhxc++UnHx4XXlsee328YSI3t/rphze1+v+FA2E8bvgEqfyiJNWxHKwAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'GBBr',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAmElEQVQ4T+VTyw7DMAhz/v9308PAwERCo3aXrdoOm3ZAfnCywK1vPVoYEARC0RI9+dQxtCIOc9ROgdvD7B4Fpje4FOrE4Q0usLFTcNeFVEJpIB2kFU9d3AJqDmWAxSfmoDwMnh59Yutb938LbNcC58VlXfwXL8xrgfX04iuwCxb/8pfWjwQ+9viVwNnv7O/TDs8ezz6/3+E7c0Y70T8nz20AAAAASUVORK5CYII='
)

ColorMapPresetIcons.set(
  'PRGn',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAl0lEQVQ4T+WT0WpDMQxDdf//fwM3kuyi3LTbWzsY7WAEcyyRF8XOMcboQo7h9hfbceDW8kNtrr7uXnqCFV7F5kUTMyXi9Fy86wfjpZg7u5cwKTCl0IuTxtzaMkzDqkVtra3rO1VoGvGOMUb9t8D+WOBMlO+fsF4PXHDzWu+frLSJU39npfkscLWht/3hPIx/+Q8bnZQq3ABoeWf/yz5kpwAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'PiYG',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAiElEQVQ4T92TQQ7DQAgDnf//N6sGGyqzG6mnqD12D2gYxMVCHGOcVUgkiIKQJRSIhGl3H5BZnwwIhPIC8wWWeddyXQjNmdl9M5YHSPezaLZ7TyAFKhFm92YuFsiC2k17Lk4XAeneQ8+OMc7cKrADxnNgbRW4L/0cmFsF/uLC8WvgqgD9z3/4w29mxUtY5qAONAAAAABJRU5ErkJggg=='
)

ColorMapPresetIcons.set(
  'OrPu',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAApUlEQVQ4T+WTwQ7DMAhDnf//33QJNkw06VppmtZqp2oHy0ByseCVpdYoYShugPcP3lDUgVT+mQ41rOL0Qx1sCHY425DN2kavlBFOg1I23NkhdpACGaACor/qbUZhfUs33+u9z3lZ3+mATS9Lrf4vgeVABtadAosBm5s9veHtCmZg3inwLye9bdhOB/bB8c5w9o/rDCv5fWd48Jssf2E42T5we4XhJ6yo2OFpMEgEAAAAAElFTkSuQmCC'
)

ColorMapPresetIcons.set(
  'BrBG',
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAFCAYAAAAZiY8XAAAAfklEQVQ4T+WTsQ4DMQxCuf//3dzQGOyKXHLt0KHdKmWwHuCJgaOdrVQAK8EqqOrW9s7Dl4saeuSZ6Cl06TNJPEj0dfHyziP8i0miD28GggTfb2YrTxIpYpBE+XQRU5uQvUZmfbSz5W6FtVth7lY4fi/sbV9b/osNx9zvFxt+AsjWWUD6OtYJAAAAAElFTkSuQmCC'
)
export default ColorMapPresetIcons
