%Openen CSV LALS peaks in MATLAB
clear all; close all; clc;

PS = csvread('LALS_203nm_PSbeads.csv');
silica = csvread('LALS_182nm_silicabeads.csv');
HOBs = csvread('LALS_180nm_HOBs.csv');

%% PS bead data in histogram line plot
PS = PS(:,1:1); %length of the data used

indices = find(abs(PS)<20000); %removes outliers
PS(indices) = [];
indices = find(abs(PS)>1000000); %removes outliers
PS(indices) = [];

binrangePS = 100; %use bin size of 100

figure
[n, x] = hist(PS,binrangePS);  %to get values for your histogram
bar(x, n, 1); 
hold on
plot(x, n, 'r'); 

%% Silica data in histogram line plot
q = length(PS);    
silica = silica(1:q); %same length as the PS dataset

binrangeSi = 100; %use bin size of 100

figure
[m, y] = hist(silica,binrangeSi); %to get values for your histogram
bar(y, m, 1); 
hold on
plot(y, m, 'r'); 

%% HOB data in histogram line plot
HOBs = HOBs(1:q); %same length as the other datasets

binrangeHOBs = 100; %use bin size of 100

figure
[o, z] = hist(HOBs,binrangeHOBs); %to get values for your histogram
bar(z, o, 1); %histogram
hold on
plot(z, o, 'r'); %outline of the histogram

%% Figure including all particles
figure
set(gca, 'XScale', 'log') %scale is logaritmic
hold on
plot((z), o, 'r'); 
plot((y), m, 'b');
plot((x), n, 'g'); 

