@parameters
default,taver1,2.
pc_read_param,/param2,obj=param2
pc_read_param,obj=param
pc_read_ts,obj=ts
good=where(ts.t gt taver1)
it1=min(good)
force=param2.force
default,lkin,0
if lkin then begin
  EEi=ts.EEK
  eta=param2.nu
endif else begin
  EEi=ts.EEM
  eta=param2.eta
endelse
itx=max(where(EEi eq max(EEi)))
EEM=max(EEi)
EEGW=mean(ts.EEGW(good))
hrms=mean(ts.hrms(good))
;
print,'$echo lk1_old=1 >> parameters.pro'
print,'$echo lwav1=1 & wav1=200. >> parameters.pro'
default,lk1_old,0
default,lwav1,0
if lwav1 then begin
  k1=wav1
endif else begin
  if lk1_old then k1=param.k1 else k1=param.wav1
endelse
etak1=eta*k1
;
cwd,run
fo="(i3, 3e9.1, 3e11.3, 2x,a)"
openw,1,'psum.tmp'
printf,1,k1,force,eta,etak1,EEM,EEGW,hrms,run,fo=fo
close,1
spawn,'cat psum.tmp'
spawn,'cat psum.tmp >> ../idl/psum.txt'
;
default,yr,[1e-7,1.]
plot_io,ts.t,EEi,yr=yr
oplot,ts.t,ts.EEGW,col=188
oplot,ts.t(good),ts.EEGW(good)*0.+EEGW,col=122
oplot,ts.t,ts.hrms,col=155
oplot,ts.t(good),ts.hrms(good)*0.+hrms
oplot,[1,1]*ts.t[it1],yr,col=122
oplot,[1,1]*ts.t[itx],yr,col=55
print,'EEi=max at t=',ts.t[itx],ts.t[it1]
END
