;$Id: pspecm_other.pro,v 1.7 2021/02/22 17:11:01 brandenb Exp $
if !d.name eq 'PS' then begin
  ;device,xsize=18,ysize=8,yoffset=3
  device,xsize=18,ysize=22,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
dir1='M1024sig0_k6_wav03_1p9em1'
dir2='K512sig1_k6_wav03_4p0em1f'
;dir3='K512sig0_k6_wav03_4p0em1f'
dir4='K512irro_k6_wav03_7p0em1d_512procs'
xs=.34
ys1=.06
ys2=.6
;
yr_pspecm_scl3=ys1*[5d-22,4d-6]
yr_pspechm_scl3=ys2*[1d-22,3.2d-13]
;
thick4=5
siz=1.3
si2=1.5
!p.charsize=1.7
!p.charsize=2.0
!x.margin=[7.3,0.5]
!y.margin=[3.2,0.2]
!p.multi=[0,1,2]
;fac_h=1.263e-18
fac2=2.
half='!s!u 1!n!r!s-!r!d 2!n'
specm='/specm.sav'
label=''
;
;  determine normalization
;
default,maglabel,'mag'
default,green_lines,0
default,plot_polarization,1
ytickf='logticks_exp'
yr=yr_pspecm_scl3
;
;  new units
;
T_in100GeV=1. & gstar_in100=1.
T_in100GeV=1.5d-3 & gstar_in100=.15
;gS_in100=1.
;gS_in100=.0391
tend=1.
Hstar=2.066d10*T_in100GeV^2*gstar_in100^.5
H0=3.241d-18
;a0=1.254d15*T_in100GeV*gS_in100^(1./3.)
a0=1d12
fact=(Hstar/H0)^2*(tend/a0)^4
print,'fact=',fact
;
;Hstar=2.066d10
;a0=1.2545d15
freq=Hstar/(2.*!pi*a0)
H0=3.24d-18
;changed from H0 = 100 km/s/Mpc to 70 km/s/Mpc
;H0=2.268545d-18
rhocrit_fac=3./(8.*!pi)
;fac_h=1.263e-18
;changed H0 from 100 to 70 km/s/Mpc, and computed h_c
;from formula 
fac_h=sqrt(3./2.)*H0/!pi
fac=(Hstar/H0)^2/rhocrit_fac*(1./a0)^4
facGW=1./(16.*!pi)
xr=xs*[2e-9,1.2e-6]
circ_sym,0.7,1
mixed=0.
;
;  1st panel
;
!p.title='!6';+run
!x.title='!6'
!y.title='!6!8h!6!s!d0!n!r!u2!n!7X!6!dGW!n(!8f!6)'
;
loadct,0
plot_oo,xr,yr,ytickf=ytickf,/nodata
up=rtable('data/GreenUpper2021.csv',2)
dn=rtable('data/GreenLower2021.csv',2)
xxx=10.^[reform(dn[0,*]),reverse(reform(up[0,*])),dn[0,0]]
yyy=10.^[reform(dn[1,*]),reverse(reform(up[1,*])),dn[1,0]]
polyfill,xxx,yyy<(.9*yr[1]),col=222
loadct,5
;
restore,'../'+dir1+specm
grav_tot=grav1m+grah1m/tm^2+mixed
OmegaGW=facGW*fac*k*grav_tot
oplot,freq*k,OmegaGW;,col=155
;
;restore,'../'+dirA+specm
;grav_tot=grav1m+grah1m/tm^2+mixed
;OmegaGW=facGW*fac*k*grav_tot
;oplot,freq*k,OmegaGW,col=155,li=2
;
;restore,'../'+dirB+specm
;grav_tot=grav1m+grah1m/tm^2+mixed
;OmegaGW=facGW*fac*k*grav_tot
;oplot,freq*k,OmegaGW,col=155,li=1
;
restore,'../'+dir2+specm
grav_tot=grav1m+grah1m/tm^2+mixed
OmegaGW=facGW*fac*k*grav_tot
oplot,freq*k,OmegaGW,col=122
;
;restore,'../'+dir3+specm
;grav_tot=grav1m+grah1m/tm^2+mixed
;OmegaGW=facGW*fac*k*grav_tot
;oplot,freq*k,OmegaGW,col=55
;
restore,'../'+dir4+specm
grav_tot=grav1m+grah1m/tm^2+mixed
OmegaGW=facGW*fac*k*grav_tot
oplot,freq*k,OmegaGW,col=55
;
xyouts,1.4e-7,1.0e-16,'!6mag',siz=siz
xyouts,2.8e-8,1.0e-18,'!6vort',siz=siz,col=122
;xyouts,xs*1.2e-6,ys1*7.3e-13,'!6helical',siz=siz,col=55
xyouts,2.6e-8,6.8e-11,'!6irro',siz=siz,col=55
;
xx=[1e-9,2e-8] & oplot,li=3,xx,ys1*3e-3*xx^.5
xyouts,2.0e-8,4.3e-9,'!9A!8f!6!u1/2!n',siz=siz
;
xx=[1.7d-8,6d-8] & oplot,li=3,xx,1.4d-64/xx^7.,col=55
xyouts,6.0e-8,1.0e-13,'!9A!8f!6!u-7!n',siz=siz,col=55
;
xx=[3.2d-8,8d-8] & oplot,li=3,xx,2d-45/xx^4.
xyouts,6.0e-8,4.3e-18,'!9A!8f!6!u-4!n',siz=siz
;
xyouts,2.5e-7,2.0e-8,'!6(a)',siz=si2
;
;-----------------------------------------------------------------------------
;  2nd panel
;
!y.title='!8h!6!dc!n(!8f!6)'
!x.title='!8f!6 [Hz]'
default,kin,0
default,hdone,1
ytickf='logticks_exp'
yr=yr_pspechm_scl3
circ_sym,0.7,1
;
restore,'../'+dir1+specm
fach=1.263e-18/(freq*k[1:*])
grav_tot=grav1m+grah1m/tm^2+mixed
OmegaGW=facGW*fac*k*grav_tot
plot_oo,freq*k,sqrt(k*grah1m)/a0,xr=xr,yr=yr,ytickf=ytickf,/nodata
oplot,freq*k,sqrt(k*grah1m)/a0;,col=155
;
;  2nd line
;
restore,'../'+dir2+specm
fach=1.263e-18/(freq*k[1:*])
grav_tot=grav1m+grah1m/tm^2+mixed
OmegaGW=facGW*fac*k*grav_tot
oplot,freq*k,sqrt(k*grah1m)/a0,col=122
;
;  3rd line
;
;restore,'../'+dir3+specm
;fach=1.263e-18/(freq*k[1:*])
;grav_tot=grav1m+grah1m/tm^2+mixed
;OmegaGW=facGW*fac*k*grav_tot
;oplot,freq*k,sqrt(k*grah1m)/a0,col=55
;
;  4th line
;
restore,'../'+dir4+specm
fach=1.263e-18/(freq*k[1:*])
grav_tot=grav1m+grah1m/tm^2+mixed
OmegaGW=facGW*fac*k*grav_tot
oplot,freq*k,sqrt(k*grah1m)/a0,col=55
;
xyouts,1.6e-7,8.3e-19,'!6mag',siz=siz;,col=155
xyouts,2.9e-8,1.0e-19,'!6vort',siz=siz,col=122
;xyouts,xs*1.0e-6,ys2*1.8e-18,'!6helical',siz=siz,col=55
xyouts,1.6e-7,1.6e-20,'!6irro',siz=siz,col=55
;
xx=[1.2e-9,2.0e-8] & oplot,li=3,xx,ys2*6e-18/xx^.5
xyouts,2.2e-8,1.0e-14,'!9A!8f!6!u-1/2!n',siz=siz
;
xx=[3.2d-8,9d-8] & oplot,li=3,xx,1.2d-35/xx^2.5
xyouts,8.0e-8,1.3e-17,'!9A!8f!6!u-2.5!n',siz=siz
;
xx=[3.2d-8,8d-8] & oplot,li=3,xx,5d-55/xx^5.,col=55
xyouts,6.5e-8,5.3e-20,'!9A!8f!6!u-5!n',siz=siz*.8,col=55
;
xyouts,2.5e-7,3.3e-14,'!6(b)',siz=si2
;
print,"$mv idl.ps ~/tex/tina/QCD-GWs/fig/pspecm_other.ps"
END
