file='tab3.txt' & name=['mag','vort','irro'] & ofile='tab3.tex'
;
T_in100GeV=1. & gstar_in100=1.
T_in100GeV=1.5d-3 & gstar_in100=.15
astar=1.
Hstar=2.066d10*T_in100GeV^2*gstar_in100^.5
H0=3.241d-18
a0=1.254d15*T_in100GeV*gstar_in100^(1./3.)
fact=(Hstar/H0)^2*(astar/a0)^4
print,'fact=',fact
;
hbar=1.0545718e-27 ;(erg*s)
c=2.99792458d10 ;(cm/s)
kB=1.3806503d-16;(erg/K)
T=2.73
B2unit=(kB*T)^4/(hbar*c)^3
;
a=rtable(file,5)
f0=reform(a[0,*])
nu=reform(a[1,*])
EEM=reform(a[2,*])
EEGW=reform(a[3,*])
hrms=reform(a[4,*])
;
Bugauss=sqrt(8.*!pi*EEM*B2unit)/1e-6
OmGW=EEGW*fact
hc=hrms/a0
;
n=n_elements(f0)
fo="(a,8('&',a), '\\')"
;
close,1
openw,1,ofile
for i=0,n-1 do begin
  printf,1,name[i],$
  latex(f0[i],1), $
  latex(nu[i],1), $
  latex(EEM[i],2), $
  latex(EEGW[i],2), $
  latex(hrms[i],2), $
  latex_float(Bugauss[i],1), $
  latex(OmGW[i],2), $
  latex(hc[i],2), fo=fo
endfor
close,1
;
spawn,'cat '+ofile
END


