file='tab2.txt' & name='hel' & ofile='tab2.tex'
file='tab1.txt' & name='noh' & ofile='tab1.tex'
;
T_in100GeV=1. & gstar_in100=1.
T_in100GeV=1.5d-3 & gstar_in100=.15
astar=1.
Hstar=2.066d10*T_in100GeV^2*gstar_in100^.5
H0=3.241d-18
a0=1.254d15*T_in100GeV*gstar_in100^(1./3.)
fact=(Hstar/H0)^2*(astar/a0)^4
print,'fact=',fact
;
hbar=1.0545718e-27 ;(erg*s)
c=2.99792458d10 ;(cm/s)
kB=1.3806503d-16;(erg/K)
T=2.73
B2unit=(kB*T)^4/(hbar*c)^3
;
a=rtable(file,8)
kf=reform(a[0,*])
k1=reform(a[1,*])
f0=reform(a[2,*])
pp=reform(a[3,*])
tau=reform(a[4,*])
EEM=reform(a[5,*])
EEGW=reform(a[6,*])
hrms=reform(a[7,*])
;
Bugauss=sqrt(8.*!pi*EEM*B2unit)/1e-6
OmGW=EEGW*fact
hc=hrms/a0
;
n=n_elements(kf)
fo="(a,11('&',a), '\\')"
;
close,1
openw,1,ofile
for i=0,n-1 do begin
  printf,1,name+str(i+1),$
  latex_float(kf[i],0), $
  latex_float(k1[i],0), $
  latex(f0[i],1), $
  latex_float_ordash( pp[i],1, pp[i] eq 0.), $
  latex_float_ordash(tau[i],1,tau[i] eq 0.), $
  latex(EEM[i],2), $
  latex(EEGW[i],2), $
  latex(hrms[i],2), $
  latex_float(Bugauss[i],1), $
  latex(OmGW[i],2), $
  latex(hc[i],2), fo=fo
endfor
close,1
;
spawn,'cat '+ofile
END


