;$Id: EEGW_vs_EEKM.pro,v 1.10 2021/02/20 21:17:06 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=10,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
siz=1.5
!p.charsize=1.7
!x.margin=[8.2,0.5]
!y.margin=[3.2,0.2]
!x.title='!13E!6!s!dM,K!6!n!r!umax!n'
!y.title='!13E!6!s!dGW!n!r!usat!n'
si2=1.3
;
file='EEGW_vs_EEKM.dat'
a=rtable(file,head=1,9)
EEKM=reform(a[2+0,*])
EEGW=reform(a[2+1,*])
kin=reform(a[2+2,*])
hel=reform(a[2+3,*])
chi=reform(a[2+4,*])
tmax=reform(a[2+5,*])
kf=reform(a[2+6,*])
xr=[1e-3,2e-1]
yr=[5e-11,8e-4]
yr=[5e-11,2e-2]
;
ope=where(kin eq 0 and kf eq 600. and hel eq 0 and chi eq 0)
red=where(kin eq 0 and kf eq 600. and hel eq 1 and chi eq 0)
plot_oo,EEKM,EEGW,ps=3,xr=xr,yr=yr,/nodata
xx=[8e-3,1.2e-1] & oplot,xx,(1.1*xx/2.)^2 ;(q=1.1 for kf=2 line)
;
loadct,0
col0=188
circ_sym,0.8,1
oplot,EEKM(red),EEGW(red),ps=8,col=col0
;
ret=where(kin eq 1 and chi eq 1) ;(hel)
ora=where(kin eq 1 and chi eq 2) ;(nohel)
gre=where(kin eq 0 and chi eq 3) ;(hydro)
;
xx=[1.6e-3,1.8e-2] & oplot,xx,3.6e-4*xx^2,col=col0
xx=[3.0e-3,5e-2] & oplot,xx,9.0e-6*xx^2,col=col0
xx=[4.0e-3,1.5e-1] & oplot,xx,2.0e-6*xx^2,col=col0
xyouts,6.2e-3,5e-8,' !6ac',col=col0
xyouts,2.8e-2,2e-8 ,'!6hel',col=col0
xyouts,2.0e-2,4e-10,'!6ini',col=col0
;
loadct,5
circ_sym,1.4,0 & oplot,EEKM(ret),EEGW(ret),ps=8,col=122 ;helical
circ_sym,1.1,1 & oplot,EEKM(ora),EEGW(ora),ps=8,col=55  ;nohel
loadct,6
circ_sym,1.1,1 & oplot,EEKM(gre),EEGW(gre),ps=8,col=122
loadct,5
;
xx=.0014 & dx=0.
circ_sym,1.4,0 & legend,xx,0.,3e-3,0,siz=siz,vshift=-5e-4,'!6  helical',ps=8,col=122
circ_sym,1.1,1 & legend,xx,0.,3e-4,0,siz=siz,vshift=-5e-5,'!6  nohel',ps=8,col=55
loadct,6
circ_sym,1.1,1 & legend,xx,0.,3e-5,0,siz=siz,vshift=-5e-6,'!6  hydro',ps=8,col=122
loadct,5
xyouts,.130,1.2e-10,siz=siz,'!6(b)'
;
print,'$mv idl.ps ../fig/EEGW_vs_EEKM.ps'
print,'$mv idl.ps ~/tex/tina/QCD-GWs/fig/EEGW_vs_EEKM.ps'
END
