if(1){
  library(flopr)
  library(dplyr)
  library(ggplot2)
  library(deSolve) # library for solving differential equations
  devtools::source_gist("07db45251922fdf3bdb500ec9493c1bf") #this gets my plotting theme from the internet
  okabe_ito_pallette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7")
}

plate_data <- read.csv("all_published_data/fig12358-all-processed-plate.csv")


# PLOT FIGURE 1 -----------------------------------------------------------

fig_1_data <- plate_data %>%
  filter(date == 190617)

## GROWTH CURVES
ggplot(fig_1_data,
       aes(group = replicate)) +
  geom_path(aes(time_h, calculated_frac * calibrated_OD / 125 * 1e6,
                colour = "E"),
            size = 0.2) +
  geom_path(aes(time_h, (1-calculated_frac) * calibrated_OD / 125 * 1e6,
                colour = "C"),
            size = 0.2) +
  geom_path(aes(time_h, calibrated_OD / 125 * 1e6,
                colour = "total"),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac * calibrated_OD / 125 * 1e6,
                 colour = "E"),
             size = 0.2) +
  geom_point(aes(time_h, (1-calculated_frac) * calibrated_OD / 125 * 1e6,
                 colour = "C"),
             size = 0.2) +
  geom_point(aes(time_h, calibrated_OD / 125 * 1e6,
                 colour = "total"),
             size = 0.2) +
  scale_y_continuous(expression("cells L"^-1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000")) +
  scale_fill_manual("", values = c("#56B4E9", "#E69F00", "#000000")) +
  facet_wrap(~plasmid2) +
  theme_ajf(base_size = 8)

## RATIO CURVES
ggplot(fig_1_data,
       aes(group = replicate)) +
  geom_path(aes(time_h, calculated_frac,
                colour = "E"),
            size = 0.2) +
  geom_path(aes(time_h, (1-calculated_frac),
                colour = "C"),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac,
                 colour = "E"),
             size = 0.2) +
  geom_point(aes(time_h, (1-calculated_frac),
                 colour = "C"),
             size = 0.2) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000")) +
  scale_fill_manual("", values = c("#56B4E9", "#E69F00", "#000000")) +
  facet_wrap(~plasmid2) +
  theme_ajf(base_size = 8)



# PLOT FIGURE 2 -----------------------------------------------------------

fig_2_data <- plate_data %>%
  filter(date %in% c(200227)) %>%
  filter(init_dilution == 0.140625) %>%
  filter(concentration == 0)


## GROWTH CURVES
ggplot(fig_2_data %>%
         filter(init_ratio == 0.2)) +
  geom_line(aes(time_h, rolling_frac * calibrated_OD / 125 * 1e6,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac) * calibrated_OD / 125 * 1e6,
                colour = "C",
                group = well),
            size = 0.2) +
  geom_line(aes(time_h, calibrated_OD / 125 * 1e6,
                colour = "total",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac * calibrated_OD / 125 * 1e6,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac) * calibrated_OD / 125 * 1e6,
                 colour = "C",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, calibrated_OD / 125 * 1e6,
                 colour = "total",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression("cells L"^-1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  theme_ajf(base_size = 8)

## RATIO CURVES
ggplot(fig_2_data %>%
         filter(init_ratio == 0.2)) +
  geom_line(aes(time_h, rolling_frac,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac),
                colour = "C",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac),
                 colour = "C",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  theme_ajf(base_size = 8)

## GRID
ggplot(fig_2_data) +
  geom_tile(aes(x = time_h, y = init_ratio, fill = as.numeric(as.character(d_ratio)))) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("time (hr)") +
  scale_fill_gradient2("proportional population change",
                       low = "#56B4E9", mid = "white", high = "#E69F00",
                       midpoint = 0, na.value = NA, limits = c(-1, 1)) +
  theme_ajf(base_size = 8)



# PLOT FIGURE 3 -----------------------------------------------------------

fig_3_data <- plate_data %>%
  filter(date %in% c(200227)) %>%
  filter(concentration == 0)


## GROWTH CURVES
ggplot(fig_3_data %>%
         filter(init_ratio == 0.2)) +
  geom_line(aes(time_h, rolling_frac * calibrated_OD / 125 * 1e6,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac) * calibrated_OD / 125 * 1e6,
                colour = "C",
                group = well),
            size = 0.2) +
  geom_line(aes(time_h, calibrated_OD / 125 * 1e6,
                colour = "total",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac * calibrated_OD / 125 * 1e6,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac) * calibrated_OD / 125 * 1e6,
                 colour = "C",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, calibrated_OD / 125 * 1e6,
                 colour = "total",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression("cells L"^-1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  facet_wrap(~init_dilution, nrow = 1) +
  theme_ajf(base_size = 8)

## RATIO CURVES
ggplot(fig_3_data %>%
         filter(init_ratio == 0.2)) +
  geom_line(aes(time_h, rolling_frac,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac),
                colour = "C",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac),
                 colour = "C",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  facet_wrap(~init_dilution, nrow = 1) +
  theme_ajf(base_size = 8)

## GRID
ggplot(fig_3_data %>%
         filter(round(time_h) == 5)) +
  geom_tile(aes(x = 1/init_dilution, y = init_ratio, fill = as.numeric(as.character(d_ratio)))) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("initial culture density", trans = "log10") +
  scale_fill_gradient2("proportional population change",
                       low = "#56B4E9", mid = "white", high = "#E69F00",
                       midpoint = 0, na.value = NA, limits = c(-1, 1)) +
  theme_ajf(base_size = 8)



# PLOT FIGURE 5 -----------------------------------------------------------

fig_5_data <- plate_data %>%
  filter(date %in% c(200107))


## GROWTH CURVES
ggplot(fig_5_data %>%
         filter(init_ratio == 0.4)) +
  geom_line(aes(time_h, rolling_frac * calibrated_OD / 125 * 1e6,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac) * calibrated_OD / 125 * 1e6,
                colour = "C",
                group = well),
            size = 0.2) +
  geom_line(aes(time_h, calibrated_OD / 125 * 1e6,
                colour = "total",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac * calibrated_OD / 125 * 1e6,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac) * calibrated_OD / 125 * 1e6,
                 colour = "C",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, calibrated_OD / 125 * 1e6,
                 colour = "total",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression("cells L"^-1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  facet_wrap(~concentration, nrow = 1) +
  theme_ajf(base_size = 8)

## RATIO CURVES
ggplot(fig_5_data %>%
         filter(init_ratio == 0.4)) +
  geom_line(aes(time_h, rolling_frac,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac),
                colour = "C",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac),
                 colour = "C",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  facet_wrap(~concentration, nrow = 1) +
  theme_ajf(base_size = 8)

## GRID
ggplot(fig_5_data %>%
         filter(round(time_h) == 5)) +
  geom_tile(aes(x = concentration, y = init_ratio, fill = as.numeric(as.character(d_ratio)))) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("initial culture density", trans = "log10") +
  scale_fill_gradient2("proportional population change",
                       low = "#56B4E9", mid = "white", high = "#E69F00",
                       midpoint = 0, na.value = NA, limits = c(-1, 1)) +
  theme_ajf(base_size = 8)



# PLOT FIGURE 8 -----------------------------------------------------------

fig_8_data <- plate_data %>%
  filter(date %in% c(191212))


## RATIO CURVES
ggplot(fig_8_data,
       aes(group = replicate)) +
  geom_line(aes(time_h, rolling_frac,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac),
                colour = "C",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac),
                 colour = "C",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression(X / (E + C)), limits = c(0, 1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  facet_wrap(~concentration, nrow = 1) +
  theme_ajf(base_size = 8)

## GROWTH CURVES
ggplot(fig_8_data,
         aes(group = replicate)) +
  geom_line(aes(time_h, rolling_frac * calibrated_OD / 125 * 1e6,
                colour = "E"),
            size = 0.2) +
  geom_line(aes(time_h, (1 - rolling_frac) * calibrated_OD / 125 * 1e6,
                colour = "C",
                group = well),
            size = 0.2) +
  geom_line(aes(time_h, calibrated_OD / 125 * 1e6,
                colour = "total",
                group = well),
            size = 0.2) +
  geom_point(aes(time_h, calculated_frac * calibrated_OD / 125 * 1e6,
                 colour = "E",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, (1 - calculated_frac) * calibrated_OD / 125 * 1e6,
                 colour = "C",
                 group = well),
             size = 0.1) +
  geom_point(aes(time_h, calibrated_OD / 125 * 1e6,
                 colour = "total",
                 group = well),
             size = 0.1) +
  scale_y_continuous(expression("cells L"^-1)) +
  scale_x_continuous("time (hr)") +
  scale_colour_manual("", values = c("#56B4E9", "#E69F00", "#000000"), guide = F) +
  facet_wrap(~concentration, nrow = 1) +
  theme_ajf(base_size = 8)

