import logging
import numba as nb
import numpy.random as np_random
import random as py_random

logger = logging.getLogger(__name__)


# make local references to chosen methods.
# TODO profile np.random against random. This would best be done after unit tests created, so as to validate changes.
uniform = np_random.uniform
randint = np_random.randint
choice = np_random.choice
normal = np_random.normal
lognormal = np_random.lognormal


@nb.jit(nb.void(nb.int64))
def numba_init_state(seed):
    """
    Initialise the random state for "within" Numba decorated code.

    Numba reimplements the random generators, we must explicitly set the seed within
    a Numba function context.

    :param seed: seed value to use
    """
    np_random.seed(seed)


def init_random_state(seed):
    """
    Initialise random generator APIs using a specific seed value.
    Currently initialisation the entire Numpy API.

    :param seed: the integer seed to use for initialisation
    """
    np_random.seed(seed)
    py_random.seed(seed)
    numba_init_state(seed)
    logger.debug('Initialized random state using seed {}'.format(seed))
