#!/bin/bash
#
# This simple shell script encapsulates the set-up required to reproduce the results
# for the manuscript "qc3C - reference-free quality control for Hi-C sequencing data"
#
# It may be advisable to inspect the commands below and decide if this is suitable for
# your runtime environment.
#
# The analysis requires Linux, due to qc3C's dependency on Jellyfish. Although a
# bioconda version of jellyfish exists, it does not contain Python hooks and qc3C will
# fail to execute.
#

# setup the conda environment, where we'll use the qc3c env for nextflow execution
conda create --name qc3c --file qc3C_specfile.txt
conda create --name sim3c_py3 --file sim3C_specfile.txt
conda install -n qc3c nextflow

# custom machine profile data needs to be copied to the sim3C package location
PROFILE_DIR=$CONDA_PREFIX/envs/sim3c_py3/lib/python3.8/site-packages/sim3C/Illumina_profiles/
if [ ! -d $PROFILE_DIR ]
then
	echo "ERROR: The expected machine profile directory was not found: ${PROFILE_DIR}"
	echo "Please extract the custom profiles in DRR_machine_profile.tar.gz to the Illumina_profiles subdirectory of the sim3C installation"
else
	tar -C $PROFILE_DIR -czvf DRR_machine_profile.tar.gz
fi

# install the tarballs for specific versions of qc3C and sim3C used in the manuscript
conda activate qc3c
pip install qc3C-0.5rc10.tar.gz

conda activate sim3c_py3
pip install sim3C-0.3.2-py3.tar.gz
