#SetWD and Libraries#
setwd("c:/Amphibians&Crayfish/")

#Step [24]####
#Libraries
#install.packages(c('MuMIn', 'SSN', 'rgdal', 'modEvA'), dependencies = T)

library(MuMIn)
library(SSN)
library(rgdal)
library(modEvA)


options(na.action = "na.fail") #Option for dredge function to work

load("start.rdata")

for (s in 1:length(Sps)){
#s=1
Sps.sh[s]

##Step [25]####
#Import SSN Object
SSN <- importSSN(paste("c:/Amphibians&Crayfish/lsn", Sps.sh[s],".ssn/", sep = "")) 
  
#distance matrix
createDistMat(SSN)
  
Dt <- as.SpatialPointsDataFrame(SSN)

#Step [26]####

#Full Model Enviromental
Mdls.M.Env <- glm(formula(paste(Sps[s]," ~ SO_N * ALT_N + PP_N  + WATER_N", sep = "")),
                       family = binomial, data = Dt)

#Full Model Biotic
Mdls.M.biotic <- glm(formula(paste(Sps[s]," ~ PRCL_N + PALE_N", sep = "")),
                          family = binomial, data = Dt)

#Full Model Enviromental + Biotic
Mdls.M.full <- glm(formula(paste(Sps[s]," ~ SO_N * ALT_N + PRCL_N + PALE_N + PP_N + WATER_N", sep = "")),
                        family = binomial, data = Dt)
#Step [27]####
#Fit all possible models
D.Env <- dredge(Mdls.M.Env)
D.biotic <- dredge(Mdls.M.biotic)
D.full <- dredge(Mdls.M.full)

print('Best Model Enviromental')
print(summary(Best.Mdls.Env <- eval(attributes(D.Env)$model.calls[[1]])))

print('Best Model Biotic')
print(summary(Best.Mdls.biotic <- eval(attributes(D.biotic)$model.calls[[1]])))

print('Best Model Enviromental + Biotic')
print(summary(Best.Mdls.full <- eval(attributes(D.full)$model.calls[[1]])))

#Step [28]####
#Get Residuals
SSN@obspoints@SSNPoints[[1]]@point.data$RES <- resid(Best.Mdls.full)

#Torgegram for residuals
Torg <- Torgegram(SSN, 'RES', nlag = 10, maxlag = 80000)
plot(Torg)

#Step [29]####
#This step takes about 1 hour for each species

SSN.Res <-  list()

for (m in 1:length(CorMdls)){
    #for (m in 1:5){
    #m=1
  print(paste(eval(CorMdls[[m]])))
  SSN.Res[[m]] <- try(glmssn(RES ~ 1, SSN, 
                               CorModels= eval(CorMdls[[m]]),
                              addfunccol = "afvCatch"))
}

SSN.Mdls <- InfoCritCompare(SSN.Res)

print('Best Spatial structure for Residuals')
CorMdls[[which.min(SSN.Mdls$AIC)]]

#Step [30]####
#Enviromental model
SSN.ENV <- try(glmssn(Best.Mdls.Env$formula, SSN,
                           CorModels= NULL,
                           family = "binomial",
                           control = list(max.range.factor = 4, trunc.pseudo = 20, maxiter.pseudo = 50, beta.converge = 1e-5)))

print('Enviromental model')

print(summary(SSN.ENV))
print(try(t(varcomp(SSN.ENV))))

res.ENV.SSN <- residuals(SSN.ENV, cross.validation = T)
res.ENV.data <- getSSNdata.frame(res.ENV.SSN)
res.ENV.data$pred <- 1/(1+exp(-res.ENV.data$`_CrossValPred_`))

print('AUC')
print(AUC(obs = res.ENV.data[,s+4], 
          pred = res.ENV.data$pred, 
          simplif = T))

print(t(threshMeasures(obs = res.ENV.data[,s+4], 
                       pred = res.ENV.data$pred, 
                       simplif = T, thresh = "preval", measures = c("kappa", "TSS"), standardize = F)))

  
#Biotic
SSN.BIO <- try(glmssn(Best.Mdls.biotic$formula, SSN,
                             CorModels= NULL,
                             family = "binomial",
                             control = list(max.range.factor = 4, trunc.pseudo = 20, maxiter.pseudo = 50, beta.converge = 1e-5)))
  
print('Biotic model')
print(summary(SSN.BIO))
print(try(t(varcomp(SSN.BIO))))

res.BIO.SSN <- residuals(SSN.BIO, cross.validation = T)
res.BIO.data <- getSSNdata.frame(res.BIO.SSN)
res.BIO.data$pred <- 1/(1+exp(-res.BIO.data$`_CrossValPred_`))

print('AUC')
print(AUC(obs = res.BIO.data[,s+4], 
          pred = res.BIO.data$pred, 
          simplif = T))

print(t(threshMeasures(obs = res.BIO.data[,s+4], 
                       pred = res.BIO.data$pred, 
                       simplif = T, thresh = "preval", measures = c("kappa", "TSS"), standardize = F)))

#Enviromental + Biotic model
SSN.ENV.BIO <- try(glmssn(Best.Mdls.full$formula, SSN,
                               CorModels= NULL,
                               family = "binomial",
                               control = list(max.range.factor = 4, trunc.pseudo = 20, maxiter.pseudo = 50, beta.converge = 1e-5)))
  
print(summary(SSN.ENV.BIO))
print(try(t(varcomp(SSN.ENV.BIO))))

res.ENV.BIO.SSN <- residuals(SSN.ENV.BIO, cross.validation = T)
res.ENV.BIO.data <- getSSNdata.frame(res.ENV.BIO.SSN)
res.ENV.BIO.data$pred <- 1/(1+exp(-res.ENV.BIO.data$`_CrossValPred_`))

print('AUC')
print(AUC(obs = res.ENV.BIO.data[,s+4], 
          pred = res.ENV.BIO.data$pred, 
          simplif = T))

print(t(threshMeasures(obs = res.ENV.BIO.data[,s+4], 
                       pred = res.ENV.BIO.data$pred, 
                       simplif = T, thresh = "preval", measures = c("kappa", "TSS"), standardize = F)))

#Step [31]####
#Env + Bio + Spatial Model
SSN.ENV.BIO.SPT <- try(glmssn(Best.Mdls.full$formula, SSN,
                                     CorModels= eval(CorMdls[[which.min(SSN.Mdls$AIC)]]),
                                     addfunccol = "afvCatch", family = "binomial",
                                     control = list(max.range.factor = 5, trunc.pseudo = 20, maxiter.pseudo = 100, beta.converge = 1e-4)))

print('Enviromental + Biotic + Spatial model')
print(summary(SSN.ENV.BIO.SPT))
print(try(t(varcomp(SSN.ENV.BIO.SPT))))

res.ENV.BIO.SPT.SSN <- residuals(SSN.ENV.BIO.SPT, cross.validation = T)
res.ENV.BIO.SPT.data <- getSSNdata.frame(res.ENV.BIO.SPT.SSN)
res.ENV.BIO.SPT.data$pred <- 1/(1+exp(-res.ENV.BIO.SPT.data$`_CrossValPred_`))

print('AUC')
print(AUC(obs = res.ENV.BIO.SPT.data[,s+4], 
          pred = res.ENV.BIO.SPT.data$pred, 
          simplif = T))

print(t(threshMeasures(obs = res.ENV.BIO.SPT.data[,s+4], 
                       pred = res.ENV.BIO.SPT.data$pred, 
                       simplif = T, thresh = "preval", measures = c("kappa", "TSS"), standardize = F)))


save.image(paste(Sps.sh[s], "_Rslts", Sys.Date(), ".rdata", sep = ""))

#Objects to use in the loop for crayfish expansion scenarios#
RR <- c(1, 2, 3, 5)
cc <- paste("c", RR, sep = "")
ll <- paste("l", RR, sep = "")

Scns_names <- paste(expand.grid(cc, ll)[,1], expand.grid(cc, ll)[,2], sep = "")

SSN.scns.Spt <- SSN.scns.NSpt <-list()

print(Sps[s])

#Step [32]####
print('# of presences')
print(pres <- sum(as.SpatialPointsDataFrame(SSN)[,3+s]@data))
print('# of sites included in analisis')
print(n_site <- nrow(as.SpatialPointsDataFrame(SSN)[,3+s]@data))
print('Prevalence')
print(prev <- pres/n_site)

for (i in 1:length(Scns_names)) {
  #i=1
  print(Scns_names[i])
  
  #Step [33]####
  #Non-Spatial Predictions
  
  #Step [33.a]
  #Import Scenario to SSN object
  SSN.ENV.BIO <- importPredpts(target = SSN.ENV.BIO, predpts = Scns_names[i], obj.type = "glm")
  createDistMat(SSN.ENV.BIO$ssn.object, Scns_names[i], o.write = TRUE, amongpreds = TRUE)
  
  #Step [33.b]
  #make predictions
  SSN.scns.NSpt[[i]] <- predict.glmssn(SSN.ENV.BIO, predpointsID = Scns_names[i])
  
  #Step [33.c]
  #Number of collums; Predictions are on last but one colum
  nc <- ncol(SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data)
  #Transform predictions from the logit scale to probabilities
  SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$Prob <- 1/(1+exp(-SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data[,nc-1]))
  
  #Step [33.d]
  #Estimate presences
  SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$PredP <- 0
  SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$PredP[SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$Prob>=prev] <- 1
  
  #Total Linear Habitat available
  Tt_hb <- sum(SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$LENGTH)
  
  print('Linear habitat occupied')
  print(Hb_m.NSpt <- sum(SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$PredP * SSN.scns.NSpt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$LENGTH))
  print('% of linear habitat occupied')
  print(Hb_r.NSpt <- Hb_m.NSpt/Tt_hb*100)
  
  #Step [34]####
  #Non-Spatial Predictions
  
  #Step [34.a]
  #Import scenario to SSN object
  SSN.ENV.BIO.SPT <- importPredpts(target = SSN.ENV.BIO.SPT, predpts = Scns_names[i], obj.type = "glm")
  createDistMat(SSN.ENV.BIO.SPT$ssn.object, Scns_names[i], o.write = TRUE, amongpreds = TRUE)
  
  #Step [34.b]
  #make predictions
  SSN.scns.Spt[[i]] <- predict.glmssn(SSN.ENV.BIO.SPT, predpointsID = Scns_names[i])
  
  #Step [34.d]
  #Number of collums; Predictions are on last but one colum
  nc <- ncol(SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data)
  #Transform predictions from the logit scale to probabilities
  SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$Prob <- 1/(1+exp(-SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data[,nc-1])) #Transform predictions from the logit scale to probabilities
  
  #Step [34.d]
  #Estimate presences
  SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$PredP <- 0
  SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$PredP[SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$Prob>=prev] <- 1
  
  Tt_hb <- sum(SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$LENGTH)
  
  print('Linear habitat occupied')
  print(Hb_m.SPT <- sum(SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$PredP * SSN.scns.Spt[[i]]$ssn.object@predpoints@SSNPoints[[i]]@point.data$LENGTH))
  print('% of linear habitat occupied')
  print(Hb_r.SPT <- Hb_m.SPT/Tt_hb)
  
}

#Step [35]####
save.image(paste(Sps.sh[s], "_Rslts_scns_", Sys.Date(), ".rdata", sep = ""))

}
