!---------------------------------------------------------------------- 
!---------------------------------------------------------------------- 
!  Muensteranian Torturials on Nonlinear Science
!  edited by Uwe Thiele, Oliver Kamps, Svetlana Gurevich
!  (Center for Nonlinear Science, Universitaet Muenster)
!----------------------------------------------------------------------
!  Section: Continuation with auto07p
!  Tutorial: SLIDROP: sliding drops on an inclined homogeneous substrate
!  by Uwe Thiele (www.uwethiele.de), supported by Christian Schelte,
!  Frank Ehebrecht, Thomas Seidel
!  Version 3, Feb 2021
!  for complete set of files and up to date version see
!  http://dx.doi.org/10.5281/zenodo.4546381
!----------------------------------------------------------------------
!  Files: thfi.f90 - auto07p file for a thin film equation for a liquid
!  layer or drop on an inclined homogeneous substrate - sliding drops
!----------------------------------------------------------------------
!----------------------------------------------------------------------

      SUBROUTINE FUNC(NDIM,U,ICP,PAR,IJAC,F,DFDU,DFDP) 
!     ---------- ---- 

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM, IJAC, ICP(*)
      DOUBLE PRECISION, INTENT(IN) :: U(NDIM), PAR(*)
      DOUBLE PRECISION, INTENT(OUT) :: F(NDIM), DFDU(NDIM,*), DFDP(NDIM,*)

      DOUBLE PRECISION H0,HH,HX,HXX,PER,C0,ALP,VV,QQ,FH,FH0,FHH,FHH0,CHI

      H0  = PAR(1)
      HH  = H0 + U(1)
      HX  = U(2)
      HXX = U(3)

      PER = PAR(5)
      C0  = PAR(6)
      ALP = PAR(41)
      VV  = PAR(42)

      QQ = HH**(3.0)
      CHI = ALP*HH**(3.0)
      FHH =  -3.*HH**(-4.0) + 6.*HH**(-7.0)

      F(1) = PER*HX
      F(2) = PER*HXX
      F(3) = PER*(FHH*HX + (C0 - CHI + VV*HH)/QQ)

      END SUBROUTINE FUNC

      SUBROUTINE STPNT(NDIM,U,PAR,T) 
!     ---------- ----- 

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM
      DOUBLE PRECISION, INTENT(INOUT) :: U(NDIM), PAR(*)
      DOUBLE PRECISION, INTENT(IN) :: T
      DOUBLE PRECISION H0,HH,HX,HXX,TPI,PER,C0,ALP,VV,QQ,FH,FH0,FHH,FHH0,CHI
      DOUBLE PRECISION AMPL,ANZ

       TPI = 8.0*ATAN(1.0)
       H0 = 5.0  ! MEAN THICKNESS
       C0 = 0.0  ! FLUX IN COMOVING FRAME
       ALP = 0.0   ! SUBSTRATE INCLINATION ANGLE
       VV = 0.0  ! VELOCITY
       ANZ = 1.0  ! NUMBER OF PERIODS
 
       FHH0 =  -3.0*H0**(-4.0) + 6.*H0**(-7.0)
       PER   = ANZ*TPI/SQRT(-FHH0)

       PAR(1) = H0
       PAR(5) = PER
       PAR(6) = C0	            
       PAR(11) = 1.0  ! INTERNAL PERIOD (NOT USED OR CHANGED)
       PAR(41) = ALP
       PAR(42) = VV

       AMPL = 0.001
       U(1) = AMPL*SIN(TPI*T*ANZ)
       U(2) = AMPL*TPI*ANZ*COS(TPI*T*ANZ)
       U(3) = -AMPL*TPI*TPI*ANZ*ANZ*SIN(TPI*T*ANZ)

      END SUBROUTINE STPNT

      SUBROUTINE BCND(NDIM,PAR,ICP,NBC,U0,U1,FB,IJAC,DBC) 
!     ---------- ---- 

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM, ICP(*), NBC, IJAC
      DOUBLE PRECISION, INTENT(IN) :: PAR(*), U0(NDIM), U1(NDIM)
      DOUBLE PRECISION, INTENT(OUT) :: FB(NBC)
      DOUBLE PRECISION, INTENT(INOUT) :: DBC(NBC,*)

      FB(1)=U0(1)-U1(1); 
      FB(2)=U0(2)-U1(2); 
      FB(3)=U0(3)-U1(3); 

      END SUBROUTINE BCND

       SUBROUTINE ICND(NDIM,PAR,ICP,NINT,U,UOLD,UDOT,UPOLD,FI,IJAC,DINT)
!      ---------- ----

       IMPLICIT NONE
       INTEGER, INTENT(IN) :: NDIM, ICP(*), NINT, IJAC
       DOUBLE PRECISION, INTENT(IN) :: PAR(*)
       DOUBLE PRECISION, INTENT(IN) :: U(NDIM), UOLD(NDIM), UDOT(NDIM), UPOLD(NDIM)
       DOUBLE PRECISION, INTENT(OUT) :: FI(NINT)
       DOUBLE PRECISION, INTENT(INOUT) :: DINT(NINT,*)
       
! fix mean thickness fixed to H0, i.e. mean of U(1) is zero */
       FI(1) = U(1) - 0.0
! integral pinning condition to break Translationssym. of homogeneous substrate
       IF (NINT>1)  FI(2) = U(1)*UPOLD(1)

       ! other options for integral pinning condition
       !       FI(2)=UOLD(1)*U(2) 
       !       FI(2)=U(2)*UPOLD(2) 
       !       FI(2)=U(1)*UOLD(2) 
       !       FI(2)=U(2)*UOLD(3) 
       END SUBROUTINE ICND

      DOUBLE PRECISION FUNCTION GETU2(U,NDX,NTST,NCOL)
!     ------ --------- -------- -----
      INTEGER, INTENT(IN) :: NDX,NCOL,NTST
      DOUBLE PRECISION, INTENT(IN) :: U(NDX,0:NCOL*NTST)

        GETU2 = U(2,0)

      END FUNCTION GETU2

      SUBROUTINE PVLS(NDIM,U,PAR)
!     ---------- ----

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM
      DOUBLE PRECISION, INTENT(IN) :: U(NDIM)
      DOUBLE PRECISION, INTENT(INOUT) :: PAR(*)

      DOUBLE PRECISION, EXTERNAL :: GETP,GETU2
      INTEGER NDX,NCOL,NTST
!---------------------------------------------------------------------- 
! NOTE : 
! Parameters set in this subroutine should be considered as ``solution 
! measures'' and be used for output purposes only.
! 
! They should never be used as `true'' continuation parameters. 
!
! They may, however, be added as ``over-specified parameters'' in the 
! parameter list associated with the AUTO-Constant NICP, in order to 
! print their values on the screen and in the ``p.xxx file.
!
! They may also appear in the list associated with AUTO-constant NUZR.
!
!---------------------------------------------------------------------- 
! For algebraic problems the argument U is, as usual, the state vector.
! For differential equations the argument U represents the approximate 
! solution on the entire interval [0,1]. In this case its values can
! be accessed indirectly by calls to GETP, as illustrated below, or
! by obtaining NDIM, NCOL, NTST via GETP and then dimensioning U as
! U(NDIM,0:NCOL*NTST) in a seperate subroutine that is called by PVLS.
!---------------------------------------------------------------------- 

! Set PAR(7) equal to the Amplitude of U(0)
       PAR(7) = getp("MAX", 1, U)-getp("MIN", 1, U)

! Set PAR(8) equal to the Integral of U(0)
       PAR(8) = getp("INT", 1,U)

! Set PAR(46) equal to the maximal slope of profile
       PAR(46) = abs(getp("MIN", 2,U))
       PAR(47) = getp("MAX", 2,U)

! Set PAR(5) equal to the value of U(2) at the left boundary using
! another method
!       NDX = NINT(GETP('NDX',0,U))
!       NTST = NINT(GETP('NTST',0,U))
!       NCOL = NINT(GETP('NCOL',0,U))
!       PAR(5) = GETU2(U,NDX,NTST,NCOL)
!---------------------------------------------------------------------- 
! The first argument of GETP may be one of the following:
!        'NRM' (L2-norm),     'MAX' (maximum),
!        'INT' (integral),    'BV0 (left boundary value),
!        'MIN' (minimum),     'BV1' (right boundary value).
!        'MNT' (t value for minimum)
!        'MXT' (t value for maximum)
!        'NDIM', 'NDX' (effective (active) number of dimensions)
!        'NTST' (NTST from constant file)
!        'NCOL' (NCOL from constant file)
!        'NBC'  (active NBC)
!        'NINT' (active NINT)
!        'DTM'  (delta t for all t values, I=1...NTST)
!        'WINT' (integration weights used for interpolation, I=0...NCOL)
!
! Also available are
!   'STP' (Pseudo-arclength step size used).
!   'FLD' (`Fold function', which vanishes at folds).
!   'BIF' (`Bifurcation function', which vanishes at singular points).
!   'HBF' (`Hopf function'; which vanishes at Hopf points).
!   'SPB' ( Function which vanishes at secondary periodic bifurcations).
!   'EIG' ( Eigenvalues/multipliers, I=1...2*NDIM, alternates real/imag parts).
!   'STA' ( Number of stable eigenvalues/multipliers).
!---------------------------------------------------------------------- 

      END SUBROUTINE PVLS

      SUBROUTINE FOPT 
      END SUBROUTINE FOPT
