!---------------------------------------------------------------------- 
!---------------------------------------------------------------------- 
!  Muensteranian Torturials on Nonlinear Science
!  edited by Uwe Thiele, Oliver Kamps, Svetlana Gurevich
!  (Center for Nonlinear Science, Universitaet Muenster)
!----------------------------------------------------------------------
!  Section: Continuation with auto07p
!  Tutorial: LINDROP: linear stability of steady states on a horizontal
!  homogeneous substrate
!  by Uwe Thiele (www.uwethiele.de), supported by Christian Schelte,
!  Frank Ehebrecht, Thomas Seidel
!  Version 3, Feb 2021
!  for complete set of files and up to date version see
!  http://dx.doi.org/10.5281/zenodo.4546375
!----------------------------------------------------------------------
!  Files: lindrop.f90 - auto07p file for linear stability of the thin 
!  film equation - steady solutions for a horizontal homogeneous substrate
!----------------------------------------------------------------------
!----------------------------------------------------------------------


      SUBROUTINE FUNC(NDIM,U,ICP,PAR,IJAC,F,DFDU,DFDP) 
!     ---------- ---- 

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM, IJAC, ICP(*)
      DOUBLE PRECISION, INTENT(IN) :: U(NDIM), PAR(*)
      DOUBLE PRECISION, INTENT(OUT) :: F(NDIM), DFDU(NDIM,*), DFDP(NDIM,*)

      DOUBLE PRECISION HMEAN,H0,H0X,H0XX,H0XXX,H1,H1X,H1XX,H1XXX,TPI&
           &,EPS,PER,C1,ANZ,FH0,FHH0,FHHH0,FHHHH0,BETA,QQ,QQ2,M0,M0H&
           &,DXDFFH,DXXDFFH,RHS

      HMEAN  = PAR(1)
      H0 = HMEAN+U(1)
      H0X= U(2)
      H1 = U(3)
      H1X= U(4)
      H1XX= U(5)
      H1XXX= U(6)

      TPI = 8.0*ATAN(1.0)
      EPS = PAR(2)
      PER = PAR(5)
      C1  = PAR(6)
      BETA = PAR(7)
      QQ = PAR(8)
      ANZ = PAR(43)

      FH0 = H0**(-3.0) - H0**(-6.0)
      FHH0 = -3.0*H0**(-4.0) + 6.0*H0**(-7.0)
      FHHH0 = 12.0*H0**(-5.0) - 42.0*H0**(-8.0)
      FHHHH0 = -60.0*H0**(-6.0) + 336.0*H0**(-9.0)
      QQ2 = QQ*QQ
      H0XX = FH0 - C1

      DXDFFH = FHHH0*H0X*H1 + FHH0*H1X
      DXXDFFH = FHHHH0*H0X*H0X*H1 + FHHH0*H0XX*H1 + 2.0*FHHH0*H0X*H1X + FHH0*H1XX
      M0 = H0*H0*H0
      M0H= 3.0*H0*H0

      RHS = -BETA*H1/M0 + QQ2*H1XX + DXXDFFH - M0H*H0X/M0*(H1XXX-QQ2*H1X-DXDFFH) + QQ2*(H1XX-QQ2*H1-FHH0*H1)

      F(1) = PER*H0X - EPS * (FH0 - C1)
      F(2) = PER*(FH0 - C1)
      F(3) = PER*H1X
      F(4) = PER*H1XX
      F(5) = PER*H1XXX
      F(6) = PER*(RHS)

      END SUBROUTINE FUNC

      SUBROUTINE STPNT(NDIM,U,PAR,T) 
!     ---------- ----- 

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM
      DOUBLE PRECISION, INTENT(INOUT) :: U(NDIM), PAR(*)
      DOUBLE PRECISION, INTENT(IN) :: T
      DOUBLE PRECISION HMEAN,H0,H0X,H0XX,H0XXX,H1,H1X,H1XX,H1XXX,TPI&
           &,EPS,PER,C1,ANZ,FH0,FHH0,FHHH0,FHHHH0,BETA,QQ,QQ2,M0,M0H&
           &,DXDFFH,DXXDFFH,RHS
      DOUBLE PRECISION FHMEAN,FHHMEAN,AMPL

       TPI = 8.0*ATAN(1.0)
       HMEAN = 3.0              
       ANZ = 1.0  ! NUMBER OF PERIODS
 
       FH0 =  HMEAN**(-3.0) - HMEAN**(-6.0)
       FHHMEAN =  -3.*HMEAN**(-4.0) + 6.*HMEAN**(-7.0)
       C1 = FH0
       BETA = 0.0 ! EIGENVALUE (REAL)
       QQ = 0.05 ! TRANSVERSAL WAVENUMBER
       PER   = ANZ*TPI/SQRT(-FHHMEAN)

       PAR(1) = HMEAN
       PAR(2) = 0.0   ! EPS                 
       PAR(5) = PER
       PAR(6) = C1
       PAR(7) = BETA
       PAR(8) = QQ
       PAR(9) = 0.0   !	NORM EIGENFUNCTION H1
       PAR(11) = 1.0  ! INTERNAL PERIOD (NOT USED OR CHANGED)
       PAR(43) = ANZ

! INITIAL SMALL AMPLITUDE SINUSOIDAL PROFILE
       AMPL = 0.0001
       U(1) = AMPL*SIN(TPI*T*ANZ)
       U(2) = AMPL*TPI*ANZ*COS(TPI*T*ANZ)
       U(3) = 0.0
       U(4) = 0.0
       U(5) = 0.0
       U(6) = 0.0

      END SUBROUTINE STPNT

      SUBROUTINE BCND(NDIM,PAR,ICP,NBC,U0,U1,FB,IJAC,DBC) 
!     ---------- ---- 

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM, ICP(*), NBC, IJAC
      DOUBLE PRECISION, INTENT(IN) :: PAR(*), U0(NDIM), U1(NDIM)
      DOUBLE PRECISION, INTENT(OUT) :: FB(NBC)
      DOUBLE PRECISION, INTENT(INOUT) :: DBC(NBC,*)

! PERIODIC BOUNDARY CONDITIONS
      FB(1)=U0(1)-U1(1); 
      FB(2)=U0(2)-U1(2); 
      FB(3)=U0(3)-U1(3); 
      FB(4)=U0(4)-U1(4); 
      FB(5)=U0(5)-U1(5); 
      FB(6)=U0(6)-U1(6); 

      END SUBROUTINE BCND

       SUBROUTINE ICND(NDIM,PAR,ICP,NINT,U,UOLD,UDOT,UPOLD,FI,IJAC,DINT)
!      ---------- ----

       IMPLICIT NONE
       INTEGER, INTENT(IN) :: NDIM, ICP(*), NINT, IJAC
       DOUBLE PRECISION, INTENT(IN) :: PAR(*)
       DOUBLE PRECISION, INTENT(IN) :: U(NDIM), UOLD(NDIM), UDOT(NDIM), UPOLD(NDIM)
       DOUBLE PRECISION, INTENT(OUT) :: FI(NINT)
       DOUBLE PRECISION, INTENT(INOUT) :: DINT(NINT,*)
       DOUBLE PRECISION HMEAN,FF,FF0,H0,H0X
       
! fix mean thickness to HMEAN, i.e. mean of U(1) is zero */
       FI(1) = U(1) - 0.0
! integral pinning condition to break Translationssym. of homogeneous substrate
       IF (NINT>1)  FI(2) = U(1)*UPOLD(1)
! energy defined as PAR(9) WE COULD HAVE 4 INTEGRAL CONDITIONS HERE,
       ! BUT THIS MIGHT GET MESSY - SO IF YOU WANT TO CALCULATE
       ! ENERGIES USE DEMO 'DROP' - HERE WE SWITCH ENERGY OF AND
       ! IMPLEMENT THE NORMALISATION CONDITION FOR THE EIGENVECTOR H1
!!$       HMEAN  = PAR(1); 
!!$       H0=HMEAN+U(1);
!!$       H0X=U(2);
!!$       FF = -H0**(-2.0)/2. + H0**(-5.0)/5.
!!$       FF0 = -HMEAN**(-2.0)/2. + HMEAN**(-5.0)/5.
!!$       IF (NINT>2)  FI(3) = H0X*H0X/2. + FF - FF0 - PAR(9)

! norm of eigenfunction h1
       IF (NINT>2)  FI(3) = U(3)*U(3) - PAR(9)

       ! other options for integral pinning condition
       !       FI(2)=UOLD(1)*U(2) 
       !       FI(2)=U(2)*UPOLD(2) 
       !       FI(2)=U(1)*UOLD(2) 
       !       FI(2)=U(2)*UOLD(3) 
       END SUBROUTINE ICND

      DOUBLE PRECISION FUNCTION GETU2(U,NDX,NTST,NCOL)
!     ------ --------- -------- -----
      INTEGER, INTENT(IN) :: NDX,NCOL,NTST
      DOUBLE PRECISION, INTENT(IN) :: U(NDX,0:NCOL*NTST)

        GETU2 = U(2,0)

      END FUNCTION GETU2

      SUBROUTINE PVLS(NDIM,U,PAR)
!     ---------- ----

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NDIM
      DOUBLE PRECISION, INTENT(IN) :: U(NDIM)
      DOUBLE PRECISION, INTENT(INOUT) :: PAR(*)

      DOUBLE PRECISION, EXTERNAL :: GETP,GETU2
      INTEGER NDX,NCOL,NTST
!---------------------------------------------------------------------- 
! NOTE : 
! Parameters set in this subroutine should be considered as ``solution 
! measures'' and be used for output purposes only.
! 
! They should never be used as `true'' continuation parameters. 
!
! They may, however, be added as ``over-specified parameters'' in the 
! parameter list associated with the AUTO-Constant NICP, in order to 
! print their values on the screen and in the ``p.xxx file.
!
! They may also appear in the list associated with AUTO-constant NUZR.
!
!---------------------------------------------------------------------- 
! For algebraic problems the argument U is, as usual, the state vector.
! For differential equations the argument U represents the approximate 
! solution on the entire interval [0,1]. In this case its values can
! be accessed indirectly by calls to GETP, as illustrated below, or
! by obtaining NDIM, NCOL, NTST via GETP and then dimensioning U as
! U(NDIM,0:NCOL*NTST) in a seperate subroutine that is called by PVLS.
!---------------------------------------------------------------------- 

! Set PAR(44) equal to the Amplitude of U(0)
       PAR(44) = getp("MAX", 1, U)-getp("MIN", 1, U)

! Set PAR(45) equal to the Integral of U(0)
       PAR(45) = getp("INT", 1,U)

! Set PAR(46) equal to the maximal slope of profile
       PAR(46) = getp("MAX", 2,U)

! Set PAR(5) equal to the value of U(2) at the left boundary using
! another method
!       NDX = NINT(GETP('NDX',0,U))
!       NTST = NINT(GETP('NTST',0,U))
!       NCOL = NINT(GETP('NCOL',0,U))
!       PAR(5) = GETU2(U,NDX,NTST,NCOL)
!---------------------------------------------------------------------- 
! The first argument of GETP may be one of the following:
!        'NRM' (L2-norm),     'MAX' (maximum),
!        'INT' (integral),    'BV0 (left boundary value),
!        'MIN' (minimum),     'BV1' (right boundary value).
!        'MNT' (t value for minimum)
!        'MXT' (t value for maximum)
!        'NDIM', 'NDX' (effective (active) number of dimensions)
!        'NTST' (NTST from constant file)
!        'NCOL' (NCOL from constant file)
!        'NBC'  (active NBC)
!        'NINT' (active NINT)
!        'DTM'  (delta t for all t values, I=1...NTST)
!        'WINT' (integration weights used for interpolation, I=0...NCOL)
!
! Also available are
!   'STP' (Pseudo-arclength step size used).
!   'FLD' (`Fold function', which vanishes at folds).
!   'BIF' (`Bifurcation function', which vanishes at singular points).
!   'HBF' (`Hopf function'; which vanishes at Hopf points).
!   'SPB' ( Function which vanishes at secondary periodic bifurcations).
!   'EIG' ( Eigenvalues/multipliers, I=1...2*NDIM, alternates real/imag parts).
!   'STA' ( Number of stable eigenvalues/multipliers).
!---------------------------------------------------------------------- 

      END SUBROUTINE PVLS

      SUBROUTINE FOPT 
      END SUBROUTINE FOPT
