## Synopsis

The land surface parameter fields dataset is a compilation of land surface property data at 0.5 deg horizontal resolution, which are required to run the HydroPy model.

## Motivation

The dataset is provided as boundary conditions for the default setup of the HydroPy model. The purpose of the dataset is to provide an easy start for users to test the HydroPy model. However, for specific studies, users should adapt the dataset to their needs concerning resolution, region and even content in case the model was modified.

## Documentation and References

The dataset contains 18 variables which are shortly described in the following table. A documentation paper is currently under preparation and will be published in GMD.<br>

Variable | Description | Unit | Source
-------- | ----------- | ---- | ------
lsm | Fractional land sea mask | / | based on Hagemann (2002)
area | Grid cell area | m-2 | based on own computation
glacier | Fractional glacier cover relative to LSM | / | based on Hagemann (2002)
perm | Fractional permafrost cover relative to LSM | / | based on GEWEX ISLSCP Project (2007)
flake | Fractional lake cover relative to land fraction | / | based on Lehner and Doell (2004)
fwetl | Fractional wetland cover relative to fraction | / | based on Lehner and Doell (2004)
fveg | Fractional vegetation cover climatology relative to LSM | / | based on Hagemann (2002)
lai | Leaf area index | m2 m-2 | based on Hagemann (2002)
srftopo | Surface (rock + ice) elevation | m | based on Amante and Eakins (2009)
topo_std | Std of subgrid elevation | m | based on Amante and Eakins (2009)
slope_avg | Mean subgrid slope (inner slope) | m m-1 | based on Amante and Eakins (2009)
wcap | Maximum soil water capacity | kg m-2 | based on Hagemann and Stacke (2015)
wava | Plant available water | kg m-2 | based on Hagemann and Stacke (2015)
wmin | Minimum subgrid water holding capacity | kg m-2 | based on Hagemann and Gates (2003)
wmax | Maximum subgrid water holding capacity | kg m-2 | based on Hagemann and Gates (2003)
beta | Beta parameter distribution | / | based on Hagemann and Gates (2003)
rout_lat | River flow target indices for latitudes | / | based on Hagemann and Duemenil (1997)
rout_lon | River flow target indices for longitudes | / | based on Hagemann and Duemenil (1997)

The original sources are:

* Hagemann and Duemenil (1997): <https://doi.org/10.1007/s003820050205>
* Hagemann (2002): <http://hdl.handle.net/11858/00-001M-0000-002B-539B-6>
* Hagemann and Gates (2003): <https://doi.org/10.1007/s00382-003-0349-x>
* Lehner and Doell (2004): <https://doi.org/10.1016/j.jhydrol.2004.03.028>
* GEWEX ISLSCP Project (2007): <https://catalogue.ceda.ac.uk/uuid/d80ea7f75faffd71a051a1517f3b2c05>
* Amante and Eakins (2009): <https://doi.org/10.7289/V5C8276M>
* Hagemann and Stacke (2015): <https://doi.org/10.1007/s00382-014-2221-6>

## Contributors

* Tobias Stacke (tobias.stacke@hzg.de)
* Stefan Hagemann (stefan.hagemann@hzg.de)

## License

This dataset is licensed under the Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0) license. It is intented to be used only in combination with the HydroPy model. In case you want to use any of the included datasets for a different purpose, please aquire a copy from the primary sources and give credit to the original dataset creators.