% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterations.R
\name{getPeriodicityWithIterations}
\alias{getPeriodicityWithIterations}
\alias{getPeriodicityWithIterations.DNAStringSet}
\alias{getPeriodicityWithIterations.GRanges}
\title{A function to compute PSDs with iterations}
\usage{
getPeriodicityWithIterations(x, ...)

\method{getPeriodicityWithIterations}{DNAStringSet}(
  x,
  motif,
  n_shuffling = 10,
  cores_shuffling = 1,
  cores_computing = 1,
  order = 1,
  verbose = 1,
  ...
)

\method{getPeriodicityWithIterations}{GRanges}(x, genome, ...)
}
\arguments{
\item{x}{DNAStringSet, sequences of interest}

\item{...}{Arguments passed to S3 methods}

\item{motif}{character, k-mer of interest}

\item{n_shuffling}{integer, Number of shuffling}

\item{cores_shuffling}{integer, Number of cores used for shuffling}

\item{cores_computing}{integer, split the workload over several processors 
using BiocParallel}

\item{order}{Integer, which order to take into consideration for shuffling
(ushuffle python library must be installed for orders > 1)}

\item{verbose}{integer, Should the function be verbose?}

\item{genome}{genome ID, BSgenome or DNAStringSet object 
(optional, if x is a GRanges)}
}
\value{
Several metrics
}
\description{
This function computes PSD values of a given k-mer of interest in 
a set of input sequences. It also iterates the PSD calculation process 
over shuffled sequences, if n_shuffling is used.
}
\section{Methods (by class)}{
\itemize{
\item \code{DNAStringSet}: S3 method for DNAString

\item \code{GRanges}: S3 method for GRanges
}}

\examples{
data(ce11_proms_seqs)
res <- getPeriodicityWithIterations(
    ce11_proms_seqs[1:10], 
    genome = 'BSgenome.Celegans.UCSC.ce11', 
    motif = 'TT', 
    cores_shuffling = 1
)
res$observed_PSD
res$shuffled_PSD
}
