#pragma rtGlobals=1		// Use modern global access method and strict wave access.
\\ Written by Rick Wehr, University of Arizona, 2019

Function AmeriFluxHo1_gsCalc()
	
	wave Ho1h_wTime, Ho1h_wT, Ho1h_wP, Ho1h_wWindSpd, Ho1h_wWindDir, Ho1h_wH2O, Ho1h_wRH, Ho1h_wVPD, Ho1h_wPAR, Ho1h_wNetRad, Ho1h_wUstar, Ho1h_wRain, Ho1h_wLE, Ho1h_wH
	variable LAI = 5.5
	
	variable useSeasonalAvgEBRforHourlyCorr = 1
	variable uStarCutoff = 0.17
	
	variable sidesOfLeafWithStomata = 2 //1 for hypostomatous leaves, 2 for amphistomatous leaves
	// Howland Forest is 90% conifer, which is split roughly half and half between red pine and hemlock.
	// Red pine has square needles with two to four lines of stomata on each side, according to Conifers of the World: The Complete Reference, by James E. Eckenwalder.
	// Hemlock has flat needles with two lines of stomata on the underside only, according to Conifers of the World: The Complete Reference, by James E. Eckenwalder.
	
	variable/G gasConstR = 8.314472 //J/mol/K
	variable/G c_p = 1012 //specific heat of air, J/kg/K
	variable/G vonKarman = 0.41
	variable/G gravAccel = 9.8
	variable/G airMolarMass_dry = 0.02897 //molar mass of dry air, kg mol-1
	variable/G lambda = 2.45e6 //latent heat of vaporization of water, J/kg (approx)
	variable/G Sc_CO2 = 1.05 //1.02 //Schmidt number = 1.02 for CO2 from Ogee et al (2003), 1.0347 based on ozone value of Lamaud and ratio of binary diffusion coefficients, 1.14 from a website, 1.1 by my calculations based on another website
	variable/G Sc_H2O = Sc_CO2/1.57278 //1.57278 is ratio of binary diffusion coefficients of H2O and CO2 //Schmidt number = 0.6 for H2O, from Kramm et al (2002)
	variable/G Pr = 0.71 //Prandtl number = 0.72 from Ogee et al (2003) but can be between 0.5 and 1 according to Kramm et al 2002
	
	variable/G dataLength = numpnts(Ho1h_wTime)
	
	variable i, j
	
	make/O/D/N=(dataLength) Ho1h_wE, Ho1h_wVP, Ho1h_wAirConc_dry, Ho1h_wAirConc_wet, Ho1h_wHeatCapacity_dry, Ho1h_wHeatCapacity_waterVapor, Ho1h_wHeatCapacity_wet, Ho1h_wAirDensity_dry, Ho1h_wWaterVaporDensity, Ho1h_wAirDensity_wet, Ho1h_wGamma
	make/O/D/N=(dataLength) Ho1h_wR_e, Ho1h_wR_b, Ho1h_wR_bH, Ho1h_wR_bV, Ho1h_wR_s, Ho1h_wR_sV
	make/O/D/N=(dataLength) Ho1h_wG_e, Ho1h_wG_b, Ho1h_wG_bH, Ho1h_wG_bV, Ho1h_wG_s, Ho1h_wG_sV
	make/O/D/N=(dataLength) Ho1h_wT_n, Ho1h_wVP_n
	make/O/D/N=(dataLength) Ho1h_wT_leaf, Ho1h_wSatVP_leaf
	make/O/D/N=(dataLength) Ho1h_wLeafAirVPD, Ho1h_wLeafAirConcDiff
	make/O/D/N=(dataLength) Ho1h_wSatVP, Ho1h_wSatVPslope
	make/O/D/N=(dataLength) Ho1h_wVPDcheck, Ho1h_wG_s_FLAG
	make/O/D/N=(dataLength) Ho1h_wG_sV_hCorr, Ho1h_wG_sV_dCorr
	make/O/D/N=(dataLength) Ho1h_wG_sV_PM_hCorr, Ho1h_wG_sV_PM_dCorr
	
	// Finding hourly and daily energy budget gap...
	
	duplicate/O Ho1h_wNetRad, Ho1h_wG_guess, Ho1h_wAvailableEnergy, Ho1h_wTotalTurbHeatFlux, Ho1h_wEnergyImbalance
	Ho1h_wG_guess = Ho1h_wNetRad*15/700 // this is a rough estimate of heat flux to ground, considered roughly propotional to Rnet based on Lindroth et al 2010
	Ho1h_wTotalTurbHeatFlux = Ho1h_wH + Ho1h_wLE
	Ho1h_wAvailableEnergy = Ho1h_wNetRad - Ho1h_wG_guess
	Ho1h_wEnergyImbalance = Ho1h_wAvailableEnergy - Ho1h_wTotalTurbHeatFlux
	
	make/O/D/N=(dataLength) Ho1h_wUstarFilter = (Ho1h_wUstar > 0)
	make/O/D/N=(dataLength) Ho1h_wTimeFilter = ((Ho1h_wTime > date2secs(2014,6,21)) && (Ho1h_wTime < date2secs(2015,9,21)))
	
	Extract/O Ho1h_wTotalTurbHeatFlux, Ho1h_wTotalTurbHeatFlux_filt, ((Ho1h_wUstarFilter==1) && (Ho1h_wTimeFilter==1))
	Extract/O Ho1h_wAvailableEnergy, Ho1h_wAvailableEnergy_filt, ((Ho1h_wUstarFilter==1) && (Ho1h_wTimeFilter==1))
	
	CurveFit line Ho1h_wTotalTurbHeatFlux_filt /X=Ho1h_wAvailableEnergy_filt
	wave W_coef
	variable hourlyEnergyBudgetRatio = W_coef[1]
	print hourlyEnergyBudgetRatio
	
	AmeriFluxHo1_DailyAvgs()
	wave Ho1h_daTime, Ho1h_daNetRad, Ho1h_daG, Ho1h_daH, Ho1h_daLE
	duplicate/O Ho1h_daNetRad, Ho1h_daAvailableEnergy, Ho1h_daTotTurbHeatFlux
	Ho1h_daTotTurbHeatFlux = Ho1h_daH + Ho1h_daLE
	Ho1h_daAvailableEnergy = Ho1h_daNetRad - Ho1h_daG
	
	CurveFit line Ho1h_daTotTurbHeatFlux /X=Ho1h_daAvailableEnergy
	variable dailyEnergyBudgetRatio = W_coef[1]
	print dailyEnergyBudgetRatio
	
	duplicate/O Ho1h_wLE, Ho1h_wBowenRatio
	Ho1h_wBowenRatio = Ho1h_wH/Ho1h_wLE
	
	// Flux correction to achieve hourly budget closure...
	
	if(useSeasonalAvgEBRforHourlyCorr==1)
		// Flux correction to achieve hourly budget closure (using annual-average gap)...
		duplicate/O Ho1h_wH, Ho1h_wTotalTurbHeatFlux_hCorr, Ho1h_wH_hCorr, Ho1h_wLE_hCorr
		Ho1h_wTotalTurbHeatFlux_hCorr = Ho1h_wTotalTurbHeatFlux/hourlyEnergyBudgetRatio
		Ho1h_wH_hCorr = Ho1h_wH/hourlyEnergyBudgetRatio
		Ho1h_wLE_hCorr = Ho1h_wLE/hourlyEnergyBudgetRatio
	else
		// Flux correction to achieve hourly budget closure (using individual hourly gaps)...
		duplicate/O Ho1h_wLE, Ho1h_wEBR
		Ho1h_wEBR = Ho1h_wTotalTurbHeatFlux/Ho1h_wAvailableEnergy
		duplicate/O Ho1h_wH, Ho1h_wTotalTurbHeatFlux_hCorr, Ho1h_wH_hCorr, Ho1h_wLE_hCorr
		Ho1h_wTotalTurbHeatFlux_hCorr = Ho1h_wTotalTurbHeatFlux/Ho1h_wEBR
		Ho1h_wH_hCorr = Ho1h_wH/Ho1h_wEBR
		Ho1h_wLE_hCorr = Ho1h_wLE/Ho1h_wEBR
	endif
	
	// Flux correction to achieve daily budget closure...
	
	duplicate/O Ho1h_wH, Ho1h_wTotalTurbHeatFlux_dCorr, Ho1h_wH_dCorr, Ho1h_wLE_dCorr, Ho1h_wEnergyStorage_dCorr
	Ho1h_wTotalTurbHeatFlux_dCorr = Ho1h_wTotalTurbHeatFlux/dailyEnergyBudgetRatio
	Ho1h_wH_dCorr = Ho1h_wH/dailyEnergyBudgetRatio
	Ho1h_wLE_dCorr = Ho1h_wLE/dailyEnergyBudgetRatio
	Ho1h_wEnergyStorage_dCorr = Ho1h_wAvailableEnergy - (Ho1h_wH_dCorr + Ho1h_wLE_dCorr)
	
	AmeriFluxHo1_TimeSinceRain()
	wave Ho1h_wTimeSinceRain, Ho1h_wCumNetRadSinceRain
	
	// gs CALCULTIONS USING FLUXES CORRECTED FOR HOURLY ENERGY BUDGET CLOSURE...
	
	//Compute wet and dry air concentrations and heat capacities...
	Ho1h_wE = Ho1h_wLE_hCorr/(lambda*0.018) //mol m-2 s-1, water flux
	Ho1h_wSatVP = 100*6.112*exp(17.62*Ho1h_wT/(243.12 + Ho1h_wT)) //Pa
	Ho1h_wSatVPslope = Ho1h_wSatVP*((17.62/(243.12+Ho1h_wT)) - ((17.62*Ho1h_wT)/((243.12+Ho1h_wT)^2))) //Pa K-1
	Ho1h_wVP = (Ho1h_wH2O/1000)*Ho1h_wP //1000 is to convert wH2O from mmol/mol to mol/mol
	Ho1h_wVPDcheck = Ho1h_wSatVP - Ho1h_wVP //Pa
	Ho1h_wVP = Ho1h_wSatVP - Ho1h_wVPD //Pa
	Ho1h_wAirConc_dry = (Ho1h_wP - Ho1h_wVP)/(gasConstR*(Ho1h_wT+273.15)) //dry air molar concentration, mol/m3
	Ho1h_wAirConc_wet = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)) //wet air molar concentration, should be mol/m3
	Ho1h_wHeatCapacity_dry = 1003 + (1008 - 1003)*((Ho1h_wT + 23.16)/100) //J/kg/K, linear interpolation of values from http://www.ohio.edu/mechanical/thermo/property_tables/air/air_Cp_Cv.html
	Ho1h_wHeatCapacity_waterVapor = 1855 + (1880 - 1855)*((Ho1h_wT + 23.16)/100) //J/kg/K, linear interpolation of values from http://www.engineeringtoolbox.com/water-vapor-d_979.html
	Ho1h_wAirDensity_dry = Ho1h_wAirConc_dry*airMolarMass_dry
	Ho1h_wWaterVaporDensity = (Ho1h_wAirConc_wet - Ho1h_wAirConc_dry)*0.018
	Ho1h_wAirDensity_wet = Ho1h_wAirDensity_dry + Ho1h_wWaterVaporDensity
	Ho1h_wHeatCapacity_wet = (Ho1h_wAirDensity_dry*Ho1h_wHeatCapacity_dry + Ho1h_wWaterVaporDensity*Ho1h_wHeatCapacity_waterVapor)/Ho1h_wAirDensity_wet //J/kg/K, heat capacity of wet air weighted by partial pressures of dry air and water vapor
	Ho1h_wGamma = Ho1h_wHeatCapacity_wet*Ho1h_wP/(lambda*0.62198) //~66.1 //psychrometric constant, Pa/K
	
//	wR_e = (wC_n - wCO2)/wFco2
	Ho1h_wR_e = 1e-16 //in absence of CO2 profiles, this line just assumes no turbulent eddy resistance
	Ho1h_wG_e = 1/Ho1h_wR_e
	Ho1h_wR_e = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wG_e)
	
	//canopy air values for temperature and water vapor...
	Ho1h_wT_n = (Ho1h_wH_hCorr*Ho1h_wR_e/(Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet)) + Ho1h_wT
//	wVP_n = gasConstR*(wT+273.15)*wE*wR_e + wVP //does not assume E is all transpiration, since all fluxes must pass through the canopy airspace in a diffusion model like this
	Ho1h_wVP_n = Ho1h_wVP //because Re is taken to be zero in this version of the code
	
	Ho1h_wR_bH = 10 // s m-1
	Ho1h_wR_b = (2/sidesOfLeafWithStomata)*Ho1h_wR_bH*((Sc_CO2/Pr)^(2/3)) //(Sc_CO2/Pr)^(2/3) gives 1.26, not (1.4*0.92) //factor of 2 because leaves are hypostomatic but heat comes from both sides, 2*wR_bH*((Sc/Pr)^(2/3)) //boundary layer resistance (s m-1) for CO2 //1.4 ~ 1.6^(2/3) for quasi-diffusion
	Ho1h_wR_bV = (2/sidesOfLeafWithStomata)*Ho1h_wR_bH*((Sc_H2O/Pr)^(2/3)) //(Sc_H2O/Pr)^(2/3) gives 0.88, not 0.92 //valid for transpiration only, factor of 2 because leaves are hypostomatic but heat comes from both sides, wR_b/1.4
		
	Ho1h_wG_bH = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_bH) //but temperature here should be closer to leaf temperature (maybe not significant)?
	Ho1h_wG_b = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_b) //but temperature here should be closer to leaf temperature (maybe not significant)?
	Ho1h_wG_bV = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_bV) //but temperature here should be closer to leaf temperature (maybe not significant)?
		
	Ho1h_wT_leaf = (Ho1h_wH_hCorr*Ho1h_wR_bH/(Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet)) + Ho1h_wT_n
	Ho1h_wSatVP_leaf = 100*6.112*exp(17.62*Ho1h_wT_leaf/(243.12 + Ho1h_wT_leaf)) //Pa
	Ho1h_wLeafAirVPD = (Ho1h_wSatVP_leaf - Ho1h_wVP_n)
	Ho1h_wLeafAirConcDiff = (1/(gasConstR*(Ho1h_wT_n+273.15)))*(Ho1h_wSatVP_leaf - Ho1h_wVP_n)
		
	duplicate/O Ho1h_wE, Ho1h_wE_pos, Ho1h_wLE_hCorr_pos
	Ho1h_wE_pos = max(Ho1h_wE,1e-12)
	Ho1h_wLE_hCorr_pos = (lambda*0.018)*Ho1h_wE_pos
	
	Ho1h_wR_sV = Ho1h_wLeafAirConcDiff/Ho1h_wE_pos - Ho1h_wR_bV //this will be more correct if concentration gradients drive diffusion, rather than partial pressure gradients
	Ho1h_wR_s = Ho1h_wR_sV*1.57278 //because binary diffusion rate of CO2-N2 is about 1.6 times slower than that of H2O-N2
		
	Ho1h_wG_s_FLAG = ((Ho1h_wR_s <= 0) || (Ho1h_wE <= 0))
	Ho1h_wR_sV = max(Ho1h_wR_sV,1e-12)
	Ho1h_wR_s = max(Ho1h_wR_s,1e-12)
		
	Ho1h_wG_sV_hCorr = Ho1h_wP/(gasConstR*(Ho1h_wT_leaf+273.15)*Ho1h_wR_sV) //conversion from s/m to mol/m2/s given by Grace et al. (1995)
	Ho1h_wG_s = Ho1h_wP/(gasConstR*(Ho1h_wT_leaf+273.15)*Ho1h_wR_s) //conversion from s/m to mol/m2/s given by Grace et al. (1995)
		
	duplicate/O Ho1h_wR_sV, Ho1h_wR_sV_PM, Ho1h_wG_sV_PM
	Ho1h_wR_sV_PM = (Ho1h_wSatVPslope*(Ho1h_wR_bH + Ho1h_wR_e)*(0.95*Ho1h_wNetRad - 0 - Ho1h_wLE_hCorr_pos) + Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet*Ho1h_wVPD)/(Ho1h_wGamma*Ho1h_wLE_hCorr_pos) - (Ho1h_wR_bV + Ho1h_wR_e)
	Ho1h_wG_sV_PM_hCorr = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_sV_PM)
	
	// gs CALCULTIONS USING FLUXES CORRECTED FOR DAILY ENERGY BUDGET CLOSURE...
	
	//Compute wet and dry air concentrations and heat capacities...
	Ho1h_wE = Ho1h_wLE_dCorr/(lambda*0.018) //mol m-2 s-1, water flux
	Ho1h_wSatVP = 100*6.112*exp(17.62*Ho1h_wT/(243.12 + Ho1h_wT)) //Pa
	Ho1h_wSatVPslope = Ho1h_wSatVP*((17.62/(243.12+Ho1h_wT)) - ((17.62*Ho1h_wT)/((243.12+Ho1h_wT)^2))) //Pa K-1
	Ho1h_wVP = (Ho1h_wH2O/1000)*Ho1h_wP //1000 is to convert wH2O from mmol/mol to mol/mol
	Ho1h_wVPDcheck = Ho1h_wSatVP - Ho1h_wVP //Pa
	Ho1h_wVP = Ho1h_wSatVP - Ho1h_wVPD //Pa
	Ho1h_wAirConc_dry = (Ho1h_wP - Ho1h_wVP)/(gasConstR*(Ho1h_wT+273.15)) //dry air molar concentration, mol/m3
	Ho1h_wAirConc_wet = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)) //wet air molar concentration, should be mol/m3
	Ho1h_wHeatCapacity_dry = 1003 + (1008 - 1003)*((Ho1h_wT + 23.16)/100) //J/kg/K, linear interpolation of values from http://www.ohio.edu/mechanical/thermo/property_tables/air/air_Cp_Cv.html
	Ho1h_wHeatCapacity_waterVapor = 1855 + (1880 - 1855)*((Ho1h_wT + 23.16)/100) //J/kg/K, linear interpolation of values from http://www.engineeringtoolbox.com/water-vapor-d_979.html
	Ho1h_wAirDensity_dry = Ho1h_wAirConc_dry*airMolarMass_dry
	Ho1h_wWaterVaporDensity = (Ho1h_wAirConc_wet - Ho1h_wAirConc_dry)*0.018
	Ho1h_wAirDensity_wet = Ho1h_wAirDensity_dry + Ho1h_wWaterVaporDensity
	Ho1h_wHeatCapacity_wet = (Ho1h_wAirDensity_dry*Ho1h_wHeatCapacity_dry + Ho1h_wWaterVaporDensity*Ho1h_wHeatCapacity_waterVapor)/Ho1h_wAirDensity_wet //J/kg/K, heat capacity of wet air weighted by partial pressures of dry air and water vapor
	Ho1h_wGamma = Ho1h_wHeatCapacity_wet*Ho1h_wP/(lambda*0.62198) //~66.1 //psychrometric constant, Pa/K
	
//	wR_e = (wC_n - wCO2)/wFco2
	Ho1h_wR_e = 1e-16 //in absence of CO2 profiles, this line just assumes no turbulent eddy resistance
	Ho1h_wG_e = 1/Ho1h_wR_e
	Ho1h_wR_e = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wG_e)
	
	//canopy air values for temperature and water vapor...
	Ho1h_wT_n = (Ho1h_wH_dCorr*Ho1h_wR_e/(Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet)) + Ho1h_wT
//	wVP_n = gasConstR*(wT+273.15)*wE*wR_e + wVP //does not assume E is all transpiration, since all fluxes must pass through the canopy airspace in a diffusion model like this
	Ho1h_wVP_n = Ho1h_wVP //because Re is taken to be zero in this version of the code
	
	Ho1h_wR_bH = 10 // s m-1
	Ho1h_wR_b = (2/sidesOfLeafWithStomata)*Ho1h_wR_bH*((Sc_CO2/Pr)^(2/3)) //(Sc_CO2/Pr)^(2/3) gives 1.26, not (1.4*0.92) //factor of 2 because leaves are hypostomatic but heat comes from both sides, 2*wR_bH*((Sc/Pr)^(2/3)) //boundary layer resistance (s m-1) for CO2 //1.4 ~ 1.6^(2/3) for quasi-diffusion
	Ho1h_wR_bV = (2/sidesOfLeafWithStomata)*Ho1h_wR_bH*((Sc_H2O/Pr)^(2/3)) //(Sc_H2O/Pr)^(2/3) gives 0.88, not 0.92 //valid for transpiration only, factor of 2 because leaves are hypostomatic but heat comes from both sides, wR_b/1.4
		
	Ho1h_wG_bH = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_bH) //but temperature here should be closer to leaf temperature (maybe not significant)?
	Ho1h_wG_b = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_b) //but temperature here should be closer to leaf temperature (maybe not significant)?
	Ho1h_wG_bV = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_bV) //but temperature here should be closer to leaf temperature (maybe not significant)?
		
	Ho1h_wT_leaf = (Ho1h_wH_dCorr*Ho1h_wR_bH/(Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet)) + Ho1h_wT_n
	Ho1h_wSatVP_leaf = 100*6.112*exp(17.62*Ho1h_wT_leaf/(243.12 + Ho1h_wT_leaf)) //Pa
	Ho1h_wLeafAirVPD = (Ho1h_wSatVP_leaf - Ho1h_wVP_n)
	Ho1h_wLeafAirConcDiff = (1/(gasConstR*(Ho1h_wT_n+273.15)))*(Ho1h_wSatVP_leaf - Ho1h_wVP_n)
		
	duplicate/O Ho1h_wE, Ho1h_wE_pos, Ho1h_wLE_dCorr_pos
	Ho1h_wE_pos = max(Ho1h_wE,1e-12)
	Ho1h_wLE_dCorr_pos = (lambda*0.018)*Ho1h_wE_pos
	
	Ho1h_wR_sV = Ho1h_wLeafAirConcDiff/Ho1h_wE_pos - Ho1h_wR_bV //this will be more correct if concentration gradients drive diffusion, rather than partial pressure gradients
	Ho1h_wR_s = Ho1h_wR_sV*1.57278 //because binary diffusion rate of CO2-N2 is about 1.6 times slower than that of H2O-N2
		
	Ho1h_wG_s_FLAG = ((Ho1h_wR_s <= 0) || (Ho1h_wE <= 0))
	Ho1h_wR_sV = max(Ho1h_wR_sV,1e-12)
	Ho1h_wR_s = max(Ho1h_wR_s,1e-12)
		
	Ho1h_wG_sV_dCorr = Ho1h_wP/(gasConstR*(Ho1h_wT_leaf+273.15)*Ho1h_wR_sV) //conversion from s/m to mol/m2/s given by Grace et al. (1995)
	Ho1h_wG_s = Ho1h_wP/(gasConstR*(Ho1h_wT_leaf+273.15)*Ho1h_wR_s) //conversion from s/m to mol/m2/s given by Grace et al. (1995)
		
	duplicate/O Ho1h_wR_sV, Ho1h_wR_sV_PM, Ho1h_wG_sV_PM
	Ho1h_wR_sV_PM = (Ho1h_wSatVPslope*(Ho1h_wR_bH + Ho1h_wR_e)*(0.95*Ho1h_wNetRad - 0 - Ho1h_wLE_dCorr_pos) + Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet*Ho1h_wVPD)/(Ho1h_wGamma*Ho1h_wLE_dCorr_pos) - (Ho1h_wR_bV + Ho1h_wR_e)
	Ho1h_wG_sV_PM_dCorr = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_sV_PM)
	
	// gs CALCULTIONS USING ORIGINAL MEASURED FLUXES...
	
	//Compute wet and dry air concentrations and heat capacities...
	Ho1h_wE = Ho1h_wLE/(lambda*0.018) //mol m-2 s-1, water flux
	Ho1h_wSatVP = 100*6.112*exp(17.62*Ho1h_wT/(243.12 + Ho1h_wT)) //Pa
	Ho1h_wSatVPslope = Ho1h_wSatVP*((17.62/(243.12+Ho1h_wT)) - ((17.62*Ho1h_wT)/((243.12+Ho1h_wT)^2))) //Pa K-1
	Ho1h_wVP = (Ho1h_wH2O/1000)*Ho1h_wP //1000 is to convert wH2O from mmol/mol to mol/mol
	Ho1h_wVPDcheck = Ho1h_wSatVP - Ho1h_wVP //Pa
	Ho1h_wVP = Ho1h_wSatVP - Ho1h_wVPD //Pa
	Ho1h_wAirConc_dry = (Ho1h_wP - Ho1h_wVP)/(gasConstR*(Ho1h_wT+273.15)) //dry air molar concentration, mol/m3
	Ho1h_wAirConc_wet = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)) //wet air molar concentration, should be mol/m3
	Ho1h_wHeatCapacity_dry = 1003 + (1008 - 1003)*((Ho1h_wT + 23.16)/100) //J/kg/K, linear interpolation of values from http://www.ohio.edu/mechanical/thermo/property_tables/air/air_Cp_Cv.html
	Ho1h_wHeatCapacity_waterVapor = 1855 + (1880 - 1855)*((Ho1h_wT + 23.16)/100) //J/kg/K, linear interpolation of values from http://www.engineeringtoolbox.com/water-vapor-d_979.html
	Ho1h_wAirDensity_dry = Ho1h_wAirConc_dry*airMolarMass_dry
	Ho1h_wWaterVaporDensity = (Ho1h_wAirConc_wet - Ho1h_wAirConc_dry)*0.018
	Ho1h_wAirDensity_wet = Ho1h_wAirDensity_dry + Ho1h_wWaterVaporDensity
	Ho1h_wHeatCapacity_wet = (Ho1h_wAirDensity_dry*Ho1h_wHeatCapacity_dry + Ho1h_wWaterVaporDensity*Ho1h_wHeatCapacity_waterVapor)/Ho1h_wAirDensity_wet //J/kg/K, heat capacity of wet air weighted by partial pressures of dry air and water vapor
	Ho1h_wGamma = Ho1h_wHeatCapacity_wet*Ho1h_wP/(lambda*0.62198) //~66.1 //psychrometric constant, Pa/K
	
//	wR_e = (wC_n - wCO2)/wFco2
	Ho1h_wR_e = 1e-16 //in absence of CO2 profiles, this line just assumes no turbulent eddy resistance
	Ho1h_wG_e = 1/Ho1h_wR_e
	Ho1h_wR_e = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wG_e)
	
	//canopy air values for temperature and water vapor...
	Ho1h_wT_n = (Ho1h_wH*Ho1h_wR_e/(Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet)) + Ho1h_wT
//	wVP_n = gasConstR*(wT+273.15)*wE*wR_e + wVP //does not assume E is all transpiration, since all fluxes must pass through the canopy airspace in a diffusion model like this
	Ho1h_wVP_n = Ho1h_wVP //because Re is taken to be zero in this version of the code
	
	Ho1h_wR_bH = 10 // s m-1
	Ho1h_wR_b = (2/sidesOfLeafWithStomata)*Ho1h_wR_bH*((Sc_CO2/Pr)^(2/3)) //(Sc_CO2/Pr)^(2/3) gives 1.26, not (1.4*0.92) //factor of 2 because leaves are hypostomatic but heat comes from both sides, 2*wR_bH*((Sc/Pr)^(2/3)) //boundary layer resistance (s m-1) for CO2 //1.4 ~ 1.6^(2/3) for quasi-diffusion
	Ho1h_wR_bV = (2/sidesOfLeafWithStomata)*Ho1h_wR_bH*((Sc_H2O/Pr)^(2/3)) //(Sc_H2O/Pr)^(2/3) gives 0.88, not 0.92 //valid for transpiration only, factor of 2 because leaves are hypostomatic but heat comes from both sides, wR_b/1.4
		
	Ho1h_wG_bH = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_bH) //but temperature here should be closer to leaf temperature (maybe not significant)?
	Ho1h_wG_b = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_b) //but temperature here should be closer to leaf temperature (maybe not significant)?
	Ho1h_wG_bV = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_bV) //but temperature here should be closer to leaf temperature (maybe not significant)?
		
	Ho1h_wT_leaf = (Ho1h_wH*Ho1h_wR_bH/(Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet)) + Ho1h_wT_n
	Ho1h_wSatVP_leaf = 100*6.112*exp(17.62*Ho1h_wT_leaf/(243.12 + Ho1h_wT_leaf)) //Pa
	Ho1h_wLeafAirVPD = (Ho1h_wSatVP_leaf - Ho1h_wVP_n)
	Ho1h_wLeafAirConcDiff = (1/(gasConstR*(Ho1h_wT_n+273.15)))*(Ho1h_wSatVP_leaf - Ho1h_wVP_n)
		
	duplicate/O Ho1h_wE, Ho1h_wE_pos, Ho1h_wLE_pos
	Ho1h_wE_pos = max(Ho1h_wE,1e-12)
	Ho1h_wLE_pos = (lambda*0.018)*Ho1h_wE_pos
	
	Ho1h_wR_sV = Ho1h_wLeafAirConcDiff/Ho1h_wE_pos - Ho1h_wR_bV //this will be more correct if concentration gradients drive diffusion, rather than partial pressure gradients
	Ho1h_wR_s = Ho1h_wR_sV*1.57278 //because binary diffusion rate of CO2-N2 is about 1.6 times slower than that of H2O-N2
		
	Ho1h_wG_s_FLAG = ((Ho1h_wR_s <= 0) || (Ho1h_wE <= 0))
	Ho1h_wR_sV = max(Ho1h_wR_sV,1e-12)
	Ho1h_wR_s = max(Ho1h_wR_s,1e-12)
		
	Ho1h_wG_sV = Ho1h_wP/(gasConstR*(Ho1h_wT_leaf+273.15)*Ho1h_wR_sV) //conversion from s/m to mol/m2/s given by Grace et al. (1995)
	Ho1h_wG_s = Ho1h_wP/(gasConstR*(Ho1h_wT_leaf+273.15)*Ho1h_wR_s) //conversion from s/m to mol/m2/s given by Grace et al. (1995)
		
	Ho1h_wG_s_FLAG = ((Ho1h_wG_s_FLAG == 1) || (Ho1h_wG_s > 100)) //flags unrealistically high (usually effectively infinite) stomatal conductances
	Ho1h_wG_s_FLAG = ((Ho1h_wG_s_FLAG == 1) || (Ho1h_wPAR < 10))
		
	Extract/O Ho1h_wG_s, Ho1h_wG_s_noFlag, (Ho1h_wG_s_FLAG==0)
	Extract/O Ho1h_wTime, Ho1h_wTime_noFlag, (Ho1h_wG_s_FLAG==0)
	SetScale d 0,0,"dat", Ho1h_wTime_noFlag
	
	duplicate/O Ho1h_wR_sV, Ho1h_wR_sV_PM, Ho1h_wG_sV_PM
	Ho1h_wR_sV_PM = (Ho1h_wSatVPslope*(Ho1h_wR_bH + Ho1h_wR_e)*(0.95*Ho1h_wNetRad - 0 - Ho1h_wLE_pos) + Ho1h_wAirDensity_wet*Ho1h_wHeatCapacity_wet*Ho1h_wVPD)/(Ho1h_wGamma*Ho1h_wLE_pos) - (Ho1h_wR_bV + Ho1h_wR_e)
	Ho1h_wG_sV_PM = Ho1h_wP/(gasConstR*(Ho1h_wT+273.15)*Ho1h_wR_sV_PM)
	
	
End

Function AmeriFluxHo1_TimeSinceRain()
	
	variable beSuperConservative = 0 //1 = assume there's rain anytime VPD drops below VPDthreshold, 0 = don't
	variable VPDthreshold = 300 //Pa
	
	wave Ho1h_wRain, Ho1h_wTime, Ho1h_wNetRad, Ho1h_wVPD
	NVAR dataLength
	variable i, lastRainTime = 0, firstRain = 0
	
	make/O/D/N=(dataLength) Ho1h_wImaginedRain = 0
	Ho1h_wImaginedRain = (Ho1h_wVPD<VPDthreshold)
	
	//first to find seconds since end of last rain...
	make/O/D/N=(dataLength) Ho1h_wTimeSinceRain
	for(i=0;i<dataLength;i+=1)
		if((Ho1h_wRain[i]>0) || ((beSuperConservative==1) && (Ho1h_wImaginedRain[i]>0)))
			firstRain = 1
			Ho1h_wTimeSinceRain[i] = 0
			lastRainTime = Ho1h_wTime[i]
		else
			if(firstRain==1)
				Ho1h_wTimeSinceRain[i] = Ho1h_wTime[i] - lastRainTime
			else
				Ho1h_wTimeSinceRain[i] = NaN
			endif
		endif
	endfor
	
	//now to find cumulative net radiation since end of last rain...
	make/O/D/N=(dataLength) Ho1h_wCumNetRadSinceRain
	variable pointsSinceRain, CNRsum, dt
	variable radIncrement, cumRadTally = 0 //for alt method
	dt = 3600 //sec, 1 hour time step in record
	for(i=0;i<dataLength;i+=1)
		if((Ho1h_wRain[i]>0) || ((beSuperConservative==1) && (Ho1h_wImaginedRain[i]>0)))
			firstRain = 1
			Ho1h_wCumNetRadSinceRain[i] = 0
			cumRadTally = 0
		else
			if(firstRain==1)
				radIncrement = Ho1h_wNetRad[i]*dt
				cumRadTally += max(0,radIncrement)
				Ho1h_wCumNetRadSinceRain[i] = cumRadTally
			else
				Ho1h_wCumNetRadSinceRain[i] = NaN
			endif
		endif
	endfor
	
End

Function AmeriFluxHo1_DailyAvgs()
	
	wave Ho1h_wTime, Ho1h_wH, Ho1h_wLE, Ho1h_wNetRad, Ho1h_wG_guess
	
	variable DAminPoints = 12
	variable DAbinDuration = 86400 //seconds
	variable DAfirstBinStart = date2secs(2014,1,1)
	variable DAlastBinEnd = date2secs(2015,1,1)
	variable DAnumBins = round(DAlastBinEnd - DAfirstBinStart)/DAbinDuration
	
	variable i
	
//	duplicate/O Ho1h_wTime, DAtimeofyearTemp
//	for(i=0;i<numpnts(Ho1h_wTime);i+=1)
//		if(Ho1h_wTime[i]<date2secs(2012,1,1))
//			DAtimeofyearTemp[i] = Ho1h_wTime[i] - date2secs(2011,1,1)
//		elseif((GSF_wmTime_REF[i]>date2secs(2012,1,1)) && (GSF_wmTime_REF[i]<date2secs(2013,1,1)))
//			DAtimeofyearTemp[i] = Ho1h_wTime[i] - date2secs(2012,1,1)
//		elseif(GSF_wmTime_REF[i]>date2secs(2013,1,1))
//			DAtimeofyearTemp[i] = Ho1h_wTime[i] - date2secs(2013,1,1)
//		endif
//	endfor
	
	make/O/D/N=0 Ho1h_daTime, Ho1h_daH, Ho1h_daLE, Ho1h_daNetRad, Ho1h_daG
	make/O/D/N=0 Ho1h_daNumPoints
	
	make/O/D/N=(numpnts(Ho1h_wTime)) DAtempMask, DA_dayMaskTemp
	make/O/D/N=1 DAtemp
	
	DA_dayMaskTemp = 1
	
	for(i=0;i<DAnumBins;i+=1)
		
		DAtempMask = ((DA_dayMaskTemp==1) && (Ho1h_wTime >= (DAfirstBinStart+i*DAbinDuration)) && (Ho1h_wTime < (DAfirstBinStart+(i+1)*DAbinDuration)))
		
		if(sum(DAtempMask)>0)
			
			Extract/O Ho1h_wTime, DAtempTime, (DAtempMask==1)
			Extract/O Ho1h_wH, DAtempH, (DAtempMask==1)
			Extract/O Ho1h_wLE, DAtempLE, (DAtempMask==1)
			Extract/O Ho1h_wNetRad, DAtempNetRad, (DAtempMask==1)
			Extract/O Ho1h_wG_guess, DAtempG, (DAtempMask==1)
						
			if(numpnts(DAtempTime)>=DAminPoints)
				
				//24-hour Averages...
				
				wavestats/Q DAtempTime
				DAtemp[0] = V_avg
				Concatenate/NP {DAtemp}, Ho1h_daTime
//				DAtemp[0] = V_avg + (V_sdev/sqrt(numpnts(DAtempGPP)))
//				Concatenate/NP {DAtemp}, DA_Reco_pSE
//				DAtemp[0] = V_avg - (V_sdev/sqrt(numpnts(DAtempGPP)))
//				Concatenate/NP {DAtemp}, DA_Reco_mSE
				
				wavestats/Q DAtempH
				DAtemp[0] = V_avg
				Concatenate/NP {DAtemp}, Ho1h_daH
				
				wavestats/Q DAtempLE
				DAtemp[0] = V_avg
				Concatenate/NP {DAtemp}, Ho1h_daLE
				
				wavestats/Q DAtempNetRad
				DAtemp[0] = V_avg
				Concatenate/NP {DAtemp}, Ho1h_daNetRad
				
				wavestats/Q DAtempG
				DAtemp[0] = V_avg
				Concatenate/NP {DAtemp}, Ho1h_daG
				
			endif
		endif
	endfor
	
	killwaves DAtempMask
	killwaves DAtemp
	killwaves DAtempTime, DAtempH, DAtempLE, DAtempNetRad, DAtempG
	
End