program pvsa
use types; use const
implicit none
integer::iqwav,iqang,i,nwl
integer,parameter :: na = 1000  ! single
real(kind=dp) :: a0,amin,amax,da,pow,a(1:na)
real(kind=dp) :: LP(1:3,1:5)
real(kind=dp),dimension(1:na,1:3)::P30,P60,P90,P120,P150
character::fn*50,fice*8,ppp*3,rmin*7
logical::multiple,allwavel,pangout

!--------------------------------------------------------------------------------
! Figures 4a
!--------------------------------------------------------------------------------
multiple = .false.
!--------------------------------------------------------------------------------
! Figures 4b,c
!--------------------------------------------------------------------------------
!multiple = .true.

allwavel = .false.
pangout  = .false.
amin     = 5.e-3_dp
amax     = 1.e3_dp
da       = (amax/amin)**(1.0/real(na-1,kind=dp))
pow      = 3.5_dp
fice     = "fice0.3"
if(multiple) then
        a0       = 5.0e-3_dp
endif
if(allwavel) then
        nwl = 250
else
        nwl = 3
endif

do i=1,na
        write(*,*) i,"/",na
        a(i) = amin * da ** real(i-1,kind=dp)
        if(multiple) then
                write(rmin,'(1PE7.1)') a0
                write(ppp,'(f3.1)') pow
                fn   = trim(fice)//"_q"//trim(ppp)//"_amin"//trim(rmin)//"um"
                call mie_mrn_opacities(a(i),a0,pow,nwl,fn,fice,allwavel,pangout,LP)
        else
                fn   = trim(fice)
                call mie_single_opacities(a(i),nwl,fn,fice,allwavel,pangout,LP)
        endif
        P30(i,:)  = LP(:,1) 
        P60(i,:)  = LP(:,2) 
        P90(i,:)  = LP(:,3) 
        P120(i,:) = LP(:,4) 
        P150(i,:) = LP(:,5) 
enddo
!
if(multiple) then
        print *, "output: pvsa_mrn_"//trim(fn)//".dat"
        open(30,file="./data/pvsa_mrn_"//trim(fn)//".dat",status="unknown")
        do k=1,3
        write(30,1100) lmdip(k)," = wavelength (um)"
        write(30,1100) a0, " = minimum grain radius (um)"
        write(30,1100) pow, " = power-law index q"
        write(30,1200) trim(fice), " = ice-silicate model"
        write(30,2000) "amax (um)","P (30deg)","P (60deg)","P (90deg)","P (120deg)","P (150deg)"
        do i=1,na
                write(30,1000) a(i),P30(i,k),P60(i,k),P90(i,k),P120(i,k),P150(i,k)
        enddo
        write(30,*)
        enddo
else
        print *, "output: pvsa_single_"//trim(fn)//".dat"
        open(30,file="./data/pvsa_single_"//trim(fn)//".dat",status="unknown")
        do k=1,3
        write(30,1100) lmdip(k)," = wavelength (um)"
        write(30,1200) trim(fice), " = ice-silicate model"
        write(30,2000) "amax (um)","P (30deg)","P (60deg)","P (90deg)","P (120deg)","P (150deg)"
        do i=1,na
                write(30,1000) a(i),P30(i,k),P60(i,k),P90(i,k),P120(i,k),P150(i,k)
        enddo
        write(30,*)
        enddo
endif

1000 format(' ',1P6E15.5)
1100 format('#',1PE15.5,A)
1200 format('#',A15,A)
2000 format('#',6A15)

stop
end program pvsa
