!--------------------------------------------------------------------------------
!
!  Compute polarization feature for various types of grain size distribution      
!
!--------------------------------------------------------------------------------
program dust_opacity
use types
implicit none
integer,parameter :: nmax  = 10
integer,parameter :: nmin  = 6
integer,parameter :: np    = 3
integer,parameter :: nfice = 8
integer           :: i,j,k,m,nwl
real(kind=dp)     :: amax(1:nmax),amin(1:nmin),pow(1:np),LP(1:3,1:5)
character         :: fice(1:nfice)*8,rmax*7,rmin*7,ppp*3,fn*50
data (amax(k), k=1,nmax )  / 0.1_dp, 0.3_dp, 1.0_dp, 3.0_dp, 1.e1_dp, &
                             3.e1_dp, 1.e2_dp, 3.e2_dp, 1.e3_dp, 5.0_dp/
data (amin(k), k=1,nmin )  / 5e-3_dp, 0.3_dp, 3.0_dp, 1.e1_dp, 3.e1_dp, 1.e2_dp /
data (pow (k), k=1,np   )  / 2.5_dp, 3.0_dp, 3.5_dp /
data (fice(k), k=1,nfice)  / "pureice", "fice0.3", "fice0.1", "fice0.03","puresil",& 
                             "fice0.05", "fice0.03", "fice0.02"/
logical::allwavel,pangout

!--------------------------------------------------------------------------------
!
! RUN 1: Figures 5, 8 : q and amax dependence ( fice = 0.3, amin = 0.005 µm )
!
!--------------------------------------------------------------------------------
m        = 2            ! fice = 0.3
i        = 1            ! amin = 0.005 µm
allwavel = .true.       ! all wavelength? If yes, set nwl=250.
pangout  = .false.      ! suppress outputting P.vs.angle data
nwl      =  250          
do j=1,3
        do k=1,9
        write(rmax,'(1PE7.1)') amax(k)
        write(rmin,'(1PE7.1)') amin(i)
        write(ppp,'(f3.1)') pow(j)
        fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
        print *, fn
        call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)
        enddo 
enddo
!--------------------------------------------------------------------------------
!
! RUN 2: Figures 7
!
!--------------------------------------------------------------------------------
m        = 2            ! fice = 0.3
i        = 1            ! amin = 0.005 µm
k        = 5            ! amax = 10 µm
j        = 3            ! pow  = 3.5 
allwavel = .false.      ! false, then only lambda=2.5, 3.07, 3.5 are calculated.
nwl      = 3
pangout  = .true.       ! output P.vs.angle data
write(rmax,'(1PE7.1)') amax(k)
write(rmin,'(1PE7.1)') amin(i)
write(ppp,'(f3.1)') pow(j)
fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)

!--------------------------------------------------------------------------------
!
! RUN 3: Figure 6 : q and amin dependence ( fice = 0.3, amax = 1000 µm )
!
!--------------------------------------------------------------------------------
m        = 2            ! fice = 0.3
k        = 9            ! amax = 1 mm
allwavel = .true.       ! all wavelength? If yes, set nwl=250.
nwl      = 250
pangout  = .false.      ! suppress outputting P.vs.angle data
do j=1,np
        do i=2,nmin
        write(rmax,'(1PE7.1)') amax(k)
        write(rmin,'(1PE7.1)') amin(i)
        write(ppp,'(f3.1)') pow(j)
        fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
        print *, fn
        call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)
        enddo
enddo

!--------------------------------------------------------------------------------
!
! RUN 4:  Figure 9: fice dependence ( amax = 10 µm, amin = 0.005 µm, q=3.5 )
!
!--------------------------------------------------------------------------------
j        = 3            ! pow  = 3.5
k        = 5            ! amax = 10.0
i        = 1            ! amin = 0.005
allwavel = .true.       ! all wavelength? If yes, set nwl=250.
nwl      = 250
pangout  = .false.      ! suppress outputting P.vs.angle data
do m=1,5
        write(rmax,'(1PE7.1)') amax(k)
        write(rmin,'(1PE7.1)') amin(i)
        write(ppp,'(f3.1)') pow(j)
        fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
        print *, fn
        call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)
enddo

!--------------------------------------------------------------------------------
!
! RUN 5:   Figure 15a: L1551 IRS 5 ( amin = 0.005 µm, q=3.5, fice=0.03 )
!
!--------------------------------------------------------------------------------
j        = 3            ! pow  = 3.5
m        = 7            ! fice = 0.03
i        = 1            ! amin = 0.005 µm
allwavel = .true.       ! all wavelength? If yes, set nwl=250.
nwl      = 250
pangout  = .false.      ! suppress outputting P.vs.angle data
do k=3,4                ! amax = 1 µm and 3 µm
        write(rmax,'(1PE7.1)') amax(k)
        write(rmin,'(1PE7.1)') amin(i)
        write(ppp,'(f3.1)') pow(j)
        fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
        print *, fn
        call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)
enddo
k        = 10           ! amax = 5 µm
write(rmax,'(1PE7.1)') amax(k)
write(rmin,'(1PE7.1)') amin(i)
write(ppp,'(f3.1)') pow(j)
fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
print *, fn
call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)

!--------------------------------------------------------------------------------
!
! RUN 6:   Figure 15b: L1551 IRS 5 ( amax = 5 µm, amin = 0.005 µm, q=3.5 )
!
!--------------------------------------------------------------------------------
j        = 3            ! pow  = 3.5
k        = 10           ! amax = 5 µm
i        = 1            ! amin = 0.005 µm
allwavel = .true.       ! all wavelength? If yes, set nwl=250.
nwl      = 250
pangout  = .false.      ! suppress outputting P.vs.angle data
do m=6,8   
        write(rmax,'(1PE7.1)') amax(k)
        write(rmin,'(1PE7.1)') amin(i)
        write(ppp,'(f3.1)') pow(j)
        fn = trim(fice(m))//"_q"//trim(ppp)//"_amax"//trim(rmax)//"um_amin"//trim(rmin)//"um"
        print *, fn
        call mie_mrn_opacities(amax(k),amin(i),pow(j),nwl,fn,fice(m),allwavel,pangout,LP)
enddo

stop
end program dust_opacity
