program phase_tau
implicit none
integer::iwl,i,n
integer,parameter::nwl=250
double precision,dimension(1:nwl)::lmd,re,im
double precision,parameter::pi=acos(-1.d0)
double precision::lam,reip,imip
double precision::wlmin,wlmax,dwl
double precision::rhod,a,x,dphi,tabs
open(10,file="../data/IceSilicate_Iceband_fice0.3.lnk",status="old")
do iwl=1,11
        read(10,'()') 
enddo
        read(10,*) rhod
do iwl=1,6
        read(10,'()') 
enddo
do iwl=1,nwl
        read(10,*) lmd(iwl),re(iwl),im(iwl)
enddo
close(10)
a = 3.0d0
wlmin=2.5d0
wlmax=3.5d0
n=100
dwl=(wlmax-wlmin)/dble(n)
open(10,file="dphitabs_a3.0um_fice0.3.dat",status="unknown")
write(10,2000) a," = grain radius (um)"
write(10,3000) "lam (um)","DelPhi","tau_abs"
do i=1,n
        lam = wlmin + dble(i-1) * dwl
        do iwl=1,nwl-1
                if(lmd(iwl) .lt. lam .and. lmd(iwl+1) .gt. lam) then
                reip = (re(iwl+1)-re(iwl))/(lmd(iwl+1)-lmd(iwl))*(lam-lmd(iwl))+re(iwl)
                imip = log10(im(iwl+1)/im(iwl))/log10(lmd(iwl+1)/lmd(iwl))*log10(lam/lmd(iwl))+log10(im(iwl))
                imip = 10.0 ** imip
                exit
                endif
        enddo
        x = 2.d0*pi*a/lam
        dphi = 2.d0*x*(reip-1.d0)
        tabs = 8.d0*x*imip/3.d0
        write(10,1000) lam,dphi,tabs
enddo
1000 format(' ',1P3E15.5)
2000 format('#',1PE15.5,A)
3000 format('#',3A15)
stop
end program phase_tau
