module types
implicit none
integer, parameter      :: dp = selected_real_kind(P=15)
end module types

program calc_scatmat_by_debye_series
use types
implicit none
real(kind=dp),parameter :: pi = 3.1415926535897932384_dp
integer::i,j,k,ical,ip,nang,np,nwl
real(kind=dp)::rad,rhod,logawidth,dang,tauabs,angip(1:5)
real(kind=dp)::x,ext,sca,back,gs
real(kind=dp),allocatable,dimension(:)::S11,S12,S11Mie,S12Mie
real(kind=dp),allocatable,dimension(:)::wl,refre,refim
real(kind=dp),allocatable,dimension(:,:)::S11p,S12p,S11Mieip,S12Mieip,S11ip,S12ip
real(kind=dp),allocatable,dimension(:)::ang
complex(kind=dp)::refrel
complex(kind=dp),allocatable,dimension(:,:)::S1p,S2p
complex(kind=dp),allocatable,dimension(:)::S1,S2
data (angip(k),k=1,5) / 30.0_dp, 60.0_dp, 90.0_dp, 120.0_dp, 150.0_dp /
character::fn*100
logical::pangout

!--------------------------------------------------------------------------------
! input parameters
!--------------------------------------------------------------------------------
rad       = 10.0_dp
logawidth = 0.1_dp

nang      = 91
ical      = 1
np        = 0
pangout   = .false.
FN        = "pwavel_10mic_lognorm0.1_fice0.3_np0.out"

!nang      = 361
!ical      = 0
!np        = 5
!pangout   = .true.
!FN        = "scatmat_10mic_lognorm0.1_fice0.3_npinf.out"

!--------------------------------------------------------------------------------
! load optical constant
!--------------------------------------------------------------------------------
if(pangout) then
        nwl = 3
        open(50,file="../data/IceSilicate_3bands_fice0.3.lnk",status="old")
else
        nwl = 250
        open(50,file="../data/IceSilicate_Iceband_fice0.3.lnk",status="old")
endif
allocate(wl(1:nwl),refre(1:nwl),refim(1:nwl))
do i=1,11 
    read(50,'()') !skip header
end do
read(50,*) rhod
do i=1,6
    read(50,'()') !skip header
end do
do i=1,nwl
    read(50,*) wl(i),refre(i),refim(i)
end do
close(50)

!--------------------------------------------------------------------------------
! output Fresnel formula's results
!--------------------------------------------------------------------------------
if(pangout) call fresnel_planeparallel(nwl,wl,refre,refim)

allocate(ang(1:2*nang-1),S1(1:2*nang-1),S2(1:2*nang-1),&
        S11(1:2*nang-1),S12(1:2*nang-1),&
        S11Mie(1:2*nang-1),S12Mie(1:2*nang-1))
allocate(S1p(0:np,2*nang-1),S2p(0:np,2*nang-1),&
        S11p(0:np,2*nang-1),S12p(0:np,2*nang-1))
allocate(S11Mieip(1:5,1:nwl),S12Mieip(1:5,1:nwl),&
        S11ip(1:5,1:nwl),S12ip(1:5,1:nwl))

!--------------------------------------------------------------------------------
! Mie and Debye series calculation
!--------------------------------------------------------------------------------
dang=90.0_dp/real(nang-1,kind=dp)
do j=1,2*nang-1
        ang(j)=dang*dble(j-1)
enddo

if(pangout) open(10,file=TRIM(FN),status="unknown")
do i=1,nwl
        print *, i

        x      = 2.0_dp*pi*rad/wl(i)
        refrel = cmplx(refre(i),refim(i))
        tauabs = 8.0_dp*x*refim(i)/3.0_dp
        call lognorm_mie(x,refrel,nang,logawidth,S11Mie,S12Mie)
        call lognorm_debye(x,refrel,nang,logawidth,ical,np,S11,S12,S11p,S12p)

        if(pangout) then
        write(10,2100) rad," = grain radius (um)"
        write(10,2100) wl(i)," = wavelength (um)"
        write(10,2100) x," = size parameter"
        write(10,2100) refre(i)," = Re(m)"
        write(10,2100) refim(i)," = Im(m)"
        write(10,2100) logawidth," = logawidth"
        write(10,2100) tauabs," = tau_abs"
        if(ical .eq. 0) then
                write(10,2301) "Infinite"," = Truncation order of the Debye series"
        elseif(ical .eq. 1) then
                write(10,2300) np," = Truncation order of the Debye series"
        endif
        write(10,2000) "ang (deg)","S11","S11(Mie)","S11(p=0)","S11(p=1)","..."
        do j=1,2*nang-1
                ang(j)=dang*dble(j-1)
                write(10,1000) ang(j),S11(j),S11Mie(j),(S11p(ip,j),ip=0,min(np,5))
        enddo
        write(10,*)
        write(10,2000) "ang (deg)","P","P(Mie)","P(p=0)","P(p=1)","..."
        do j=1,2*nang-1        
                write(10,1000) ang(j),-S12(j)/S11(j),-S12Mie(j)/S11Mie(j),&
                        (-S12p(ip,j)/S11p(ip,j),ip=0,min(np,5))
        enddo
        write(10,*)
        endif

        do k=1,5
        do j=1,2*nang-2
        if(ang(j) .le. angip(k) .and. ang(j+1) .gt. angip(k)) then
        S11MIEip(k,i) = (S11Mie(j+1)-S11Mie(j))/(ang(j+1)-ang(j))*(angip(k)-ang(j))+S11Mie(j)
        S12MIEip(k,i) = (S12Mie(j+1)-S12Mie(j))/(ang(j+1)-ang(j))*(angip(k)-ang(j))+S12Mie(j)
        S11ip(k,i) = (S11(j+1)-S11(j))/(ang(j+1)-ang(j))*(angip(k)-ang(j))+S11(j)
        S12ip(k,i) = (S12(j+1)-S12(j))/(ang(j+1)-ang(j))*(angip(k)-ang(j))+S12(j)
        endif
        enddo
        enddo
enddo
if(pangout) then
        close(10)
        write(*,*) "writing... ",TRIM(FN)
else
        open(10,file=TRIM(FN),status="unknown")
        do k=1,5
                write(10,2100) angip(k)," = scattering angle (deg)"
                write(10,2100) rad," = grain radius (um)"
                write(10,2100) logawidth," = logawidth"
                write(10,2200) np, " = truncation order of debye series"
                write(10,2000) "lambda (um)","P (Mie)","P (debye)"
                do i=1,nwl
                write(10,1000) wl(i),-S12MIEip(k,i)/S11MIEip(k,i),-S12ip(k,i)/S11ip(k,i)
                enddo
                write(10,*)
        enddo
endif

deallocate(ang,S1,S2,S11,S12,S11Mie,S12Mie,S1p,S2p,S11p,S12p)

1000 format(' ',1P10E15.5)
1100 format(' ',I15,1P5E15.5)
2000 format('#',10A15)
2100 format('#',1PE15.5,A)
2200 format('#',I15,A)
2300 format('#',I15,A)
2301 format('#',A15,A)

stop
end program calc_scatmat_by_debye_series
