module const
use types
implicit none
integer,parameter       :: na    = 250  ! number of grain radius grids
real(kind=dp),parameter :: wfact = 3.0  ! width of log-normal size dist
end module

subroutine lognorm_mie(xc,refrel,nang,logawidth,S11ave,S12ave)
use types; use const; use omp_lib
implicit none
integer::nang,np,ia,ical,j
real(kind=dp),dimension(1:na)::xx,nd
real(kind=dp)::xmin,xmax,xc,dx,logawidth,norm
real(kind=dp)::x,ext,sca,back,gs
real(kind=dp),dimension(1:na,1:2*nang-1)::S11,S12
real(kind=dp),dimension(1:2*nang-1)::S11ave,S12ave
complex(kind=dp),dimension(2*nang-1)::S1,S2
complex(kind=dp)::refrel

xmin=exp(log(xc)-wfact*logawidth)
xmax=exp(log(xc)+wfact*logawidth)
dx=(xmax/xmin)**(1.0_dp/real(na-1,kind=dp))
do ia=1,na
        xx(ia) = xmin * dx ** real(ia-1,kind=dp)
        nd(ia) = exp(-0.5_dp*(log(xx(ia)/xc)/logawidth)**2.0_dp)
enddo
norm=0.0_dp
do ia=1,na-1
        norm = norm + 0.5_dp * (nd(ia)+nd(ia+1))
enddo
nd = nd / norm
S11ave = 0.0_dp
S12ave = 0.0_dp

!$OMP parallel do schedule (static,1)                     &
!$OMP default(none)                                       &
!$OMP shared(xx,refrel,nang,S11,S12)                      &
!$OMP private(S1,S2,ext,sca,back,gs,j)
do ia=1,na
        call bhmie_rt(xx(ia),refrel,nang,S1,S2,EXT,SCA,BACK,GS)
        do j=1,2*nang-1
        S11(ia,j)=0.5_dp*abs(S2(j))*abs(S2(j))
        S11(ia,j)=S11(ia,j)+0.5_dp*abs(S1(j))*abs(S1(j))
        S12(ia,j)=0.5_dp*abs(S2(j))*abs(S2(j))
        S12(ia,j)=S12(ia,j)-0.5_dp*abs(S1(j))*abs(S1(j))       
        enddo
enddo
!$OMP end parallel do

! averaging over the size distribution
do ia=1,na-1
        do j=1,2*nang-1
        S11ave(j) = S11ave(j) + 0.5_dp * (S11(ia,j)*nd(ia)+S11(ia+1,j)*nd(ia+1))
        S12ave(j) = S12ave(j) + 0.5_dp * (S12(ia,j)*nd(ia)+S12(ia+1,j)*nd(ia+1))
        enddo
enddo

return
end subroutine lognorm_mie

subroutine lognorm_debye(xc,refrel,nang,logawidth,ical,np,S11ave,S12ave,S11pave,S12pave)
use types; use const; use omp_lib
implicit none
integer::ical,ip,j,np,nang,ia
real(kind=dp),dimension(1:na)::xx,nd
real(kind=dp)::xmin,xmax,xc,dx,logawidth,norm
complex(kind=dp),dimension(2*nang-1)::S1,S2
complex(kind=dp),dimension(0:np,2*nang-1)::S1p,S2p
real(kind=dp),dimension(1:na,1:2*nang-1)::S11,S12
real(kind=dp),dimension(0:np,1:na,1:2*nang-1)::S11p,S12p
real(kind=dp),dimension(1:2*nang-1)::S11ave,S12ave
real(kind=dp),dimension(0:np,1:2*nang-1)::S11pave,S12pave
complex(kind=dp)::refrel
real(kind=dp)::x,ext,sca,back,gs

! size distribution bin
xmin=exp(log(xc)-wfact*logawidth)
xmax=exp(log(xc)+wfact*logawidth)
dx=(xmax/xmin)**(1.0_dp/real(na-1,kind=dp))
do ia=1,na
        xx(ia) = xmin * dx ** real(ia-1,kind=dp)
        nd(ia) = exp(-0.5_dp*(log(xx(ia)/xc)/logawidth)**2.0_dp)
enddo
norm=0.0_dp
do ia=1,na-1
        norm = norm + 0.5_dp * (nd(ia)+nd(ia+1))
enddo
nd = nd / norm

!$OMP parallel do schedule (static,1)                     &
!$OMP default(none)                                       &
!$OMP shared(xx,refrel,nang,np,ical,S11,S12,S11p,S12p)    &
!$OMP private(S1,S2,S1p,S2p,ext,sca,back,gs,j,ip)
do ia=1,na
        call debye_series_rt(xx(ia),refrel,nang,ical,np,s1,s2,s1p,s2p,ext,sca,back,gs)
        do j=1,2*nang-1
        S11(ia,j)=0.5_dp*ABS(S2(J))*ABS(S2(J))
        S11(ia,j)=S11(ia,j)+0.5_dp*ABS(S1(J))*ABS(S1(J))
        S12(ia,j)=0.5_dp*ABS(S2(J))*ABS(S2(J))
        S12(ia,j)=S12(ia,j)-0.5_dp*ABS(S1(J))*ABS(S1(J))       
        do ip=0,np
                S11p(ip,ia,j)=0.5_dp*ABS(S2p(ip,J))*ABS(S2p(ip,J))
                S11p(ip,ia,j)=S11p(ip,ia,j)+0.5_dp*ABS(S1p(ip,J))*ABS(S1p(ip,J))
                S12p(ip,ia,j)=0.5_dp*ABS(S2p(ip,J))*ABS(S2p(ip,J))
                S12p(ip,ia,j)=S12p(ip,ia,j)-0.5_dp*ABS(S1p(ip,J))*ABS(S1p(ip,J))       
       enddo
       enddo
enddo
!$OMP end parallel do

! averaging over the size distribution
S11ave = 0.0_dp
S12ave = 0.0_dp
S11pave = 0.0_dp
S12pave = 0.0_dp
do ia=1,na-1
        do j=1,2*nang-1
        S11ave(j) = S11ave(j) + 0.5_dp * (S11(ia,j)*nd(ia)+S11(ia+1,j)*nd(ia+1))
        S12ave(j) = S12ave(j) + 0.5_dp * (S12(ia,j)*nd(ia)+S12(ia+1,j)*nd(ia+1))
        do ip=0,np
                S11pave(ip,j) = S11pave(ip,j) + 0.5_dp * (S11p(ip,ia,j)*nd(ia)+&
                        S11p(ip,ia+1,j)*nd(ia+1))
                S12pave(ip,j) = S12pave(ip,j) + 0.5_dp * (S12p(ip,ia,j)*nd(ia)+&
                        S12p(ip,ia+1,j)*nd(ia+1))
        enddo
        enddo
enddo

return
end subroutine lognorm_debye
