subroutine fresnel_planeparallel(nwl,wl,refre,refim)
use types
implicit none
integer::i,iwl,nwl
integer,parameter::n=101
real(kind=dp),parameter::pi=acos(-1._dp)
real(kind=dp),parameter::r2d=180.0_dp/pi
real(kind=dp),dimension(1:nwl)::wl,refre,refim
real(kind=dp),dimension(0:2)::Ipa,Ipe,Pol,scaang
real(kind=dp)::theta,thetat,refpa,refpe,trapa,trape,Pref,Ptra
complex(kind=dp)::rpa,rpe,tpa,tpe,sinref,cosref,xi
complex(kind=dp)::refrel

print *, 'writing...fresnel_fice0.3.out'
open(10,file="fresnel_fice0.3.out",status="unknown")
do iwl=1,nwl
write(10,2000) wl(iwl)," = wavelength (um)"
write(10,2000) refre(iwl)," = Re(m)"
write(10,2000) refim(iwl)," = Im(m)"
write(10,1100) "ang (deg,p=0)","ang (deg,p=1)","P (p=0)","P(p=1)"
        refrel=cmplx(refre(iwl),refim(iwl))
        do i=1,n
        theta = 0.5_dp * pi * real(i-1,kind=dp) / real(n-1,kind=dp)
        sinref = sin(theta)/refrel
        thetat = real(asin(sinref))
        cosref = sqrt(1.0_dp - sinref * sinref)
        rpa = (cosref-refrel*cos(theta))/(cosref+refrel*cos(theta))
        rpe = (cos(theta)-refrel*cosref)/(cos(theta)+refrel*cosref)
        tpa = 2.0_dp*cos(theta)/(cosref+refrel*cos(theta))
        tpe = 2.0_dp*cos(theta)/(cos(theta)+refrel*cosref)
        xi = refrel * cosref / cos(theta)
        Ipa(0) = abs(rpa) * abs(rpa)
        Ipe(0) = abs(rpe) * abs(rpe)
        Ipa(1) = abs(tpa) * abs(tpa) * abs(tpa*xi) * abs(tpa*xi)
        Ipe(1) = abs(tpe) * abs(tpe) * abs(tpe*xi) * abs(tpe*xi)
        Ipa(2) = abs(tpa) * abs(tpa) * abs(tpa*xi) * abs(tpa*xi) * abs(-rpa) *  abs(-rpa)
        Ipe(2) = abs(tpe) * abs(tpe) * abs(tpe*xi) * abs(tpe*xi) * abs(-rpe) *  abs(-rpe)
        Pol(0) = (Ipe(0) - Ipa(0)) / (Ipe(0) + Ipa(0))
        Pol(1) = (Ipe(1) - Ipa(1)) / (Ipe(1) + Ipa(1))
        Pol(2) = (Ipe(2) - Ipa(2)) / (Ipe(2) + Ipa(2))
        scaang(0) = (pi-2.0_dp*theta) * r2d
        scaang(1) = 2.0_dp * (theta-thetat) * r2d
        write(10,1000) scaang(0),scaang(1),Pol(0),Pol(1)
        enddo
        write(10,1000)
enddo
close(10)
1000 format(' ',1P7E15.5)
1100 format('#',7A15)
2000 format('#',1PE15.5,A)
return
end subroutine fresnel_planeparallel
