#!/usr/bin/bash

# 
# Figure name
#
fn=fig9a

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
set linestyle 1 lw 3 lc 1 dt 1 
set linestyle 2 lw 3 dt 2 lc rgb "forest-green"
set linestyle 3 lw 3 lc 3 dt 3
set linestyle 4 lw 3 dt 4 lc rgb "dark-pink"
set linestyle 5 lw 3 dt 1 lc rgb "black"
set linestyle 6 lw 3 dt 6 lc rgb "grey40"
set linestyle 7 lw 3 dt 7 lc rgb "grey40"

set xr[2:4.25]
set yr[0:0.8]
set xtics 2.0,0.2,4.25

set tics font ",15"
set xtics offset 0.0,-0.5
set xlabel "$ \\\\lambda~(\\\\mu\\\\mathrm{m})$" offset 0.0,-1.25 font ",16"
set ylabel "$ P(\\\\lambda)=-S_{12}/S_{11}$" offset -2.5,0.0 font ",16"

unset label
set label "$ \\\\theta=60^\\\\circ,~a_\\\\mathrm{max}=10~\\\\mu\\\\mathrm{m},~q=3.5$" at 2.1,0.725 font ",10"
set key font ",11" spacing 1.4 at 4.2,0.7 

plot "../data/pwavel_pureice_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 1 title "$ \\\\mathrm{pure~ice} $",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 2 title "$ f_\\\\mathrm{ice}=0.3 $",\
     "../data/pwavel_fice0.1_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 3 title "$ f_\\\\mathrm{ice}=0.1 $",\
     "../data/pwavel_fice0.03_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 4 title "$ f_\\\\mathrm{ice}=0.03 $",\
     "../data/pwavel_puresil_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 5 title "$ \\\\mathrm{pure~silicate} $"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

