#!/usr/bin/bash

# 
# Figure name
#
fn=fig8

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
#set size sq
set linestyle 1 lw 3 lc 1 dt 1 
set linestyle 2 lw 3 dt 2 lc rgb "forest-green"
set linestyle 3 lw 3 lc 3 dt 3
set linestyle 4 lw 3 dt 4 lc rgb "dark-pink"
set linestyle 5 lw 3 dt 1 lc rgb "black"

set xr[2:4.25]
set yr[-0.3:1.1]
set xtics 2.0,0.2,4.25
set tics font ",15"
set xlabel "$ \\\\lambda~(\\\\mu\\\\mathrm{m})$" offset 0.0,-1.25 font ",16"
#set ylabel "$ -S_{12}/S_{11}$" offset -2.5,0.0 font ",16"
set ylabel "$ -S_{12}/S_{11}$" offset -1.5,0.0 font ",16"
set xtics offset 0.0,-0.5
unset label
set label "$ a_\\\\mathrm{max}=10~\\\\mu\\\\mathrm{m},~f_\\\\mathrm{ice}=0.3,~q=3.5$" at 2.1,1.0 font ",10"
set key at 4.15,0.95 font ",12" spacing 1.2

plot "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::0::0 u 1:7 w l ls 2 title "$ \\\\theta=30^\\\\circ$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 5 title "$ \\\\theta=60^\\\\circ$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::2::2 u 1:7 w l ls 3 title "$ \\\\theta=90^\\\\circ$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::3::3 u 1:7 w l ls 4 title "$ \\\\theta=120^\\\\circ$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::4::4 u 1:7 w l ls 1 title "$ \\\\theta=150^\\\\circ$"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

