#!/usr/bin/bash

# 
# Figure name
#
fn=fig7

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
set linestyle 1 lw 3 dt 1
set linestyle 2 lw 3 dt 3 lc rgb "forest-green"
set linestyle 3 lw 3 dt 4
set linestyle 4 lw 3 dt 2
set linestyle 5 lw 3 dt 5

set xr[0:180]
set yr[-0.4:0.9]
set ylabel "$ -S_{12}/S_{11}$" font ",14" offset -1.5,0.0
set xlabel "Scattering angle (deg)" font ",14" offset 0.0,-0.3
set tics font ",15"

set label "$ \\\\lambda=2.5~\\\\mu\\\\mathrm{m}$" at 65,0.4 font ",14" textcolor rgb "red"
set label "$ \\\\lambda=3.07~\\\\mu\\\\mathrm{m}$" at 118,0.6 font ",14" textcolor rgb "forest-green"
set label "$ \\\\lambda=3.5~\\\\mu\\\\mathrm{m}$" at 80,0.0 font ",14" textcolor rgb "blue"

unset key

plot "../data/pangle_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" u 1:(-\$3/\$2) every:::0::0 w l ls 1 title "$ \\\\lambda=2.5~\\\\mu\\\\mathrm{m}$",\
     "../data/pangle_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" u 1:(-\$3/\$2) every:::1::1 w l ls 2 title "$ \\\\lambda=3.07~\\\\mu\\\\mathrm{m}$",\
     "../data/pangle_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" u 1:(-\$3/\$2) every:::2::2 w l ls 3 title "$ \\\\lambda=3.5~\\\\mu\\\\mathrm{m}$"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

