#!/usr/bin/bash

# 
# Figure name
#
fn="fig6"

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz size 12,4
set colors classic
set output "graph.tex"

#
# Plot data
#
#set size sq

set linestyle 1 lw 2 lc 1 dt 1 
set linestyle 2 lw 2 dt 2 lc rgb "forest-green"
set linestyle 3 lw 2 lc 3 dt 3
set linestyle 4 lw 2 dt 4 lc rgb "dark-pink"
set linestyle 5 lw 2 dt 1 lc rgb "black"


set multiplot layout 1,3
set macros
LPANEL="set lmargin at screen 0.1; set rmargin at screen 0.4"
MPANEL="set lmargin at screen 0.4; set rmargin at screen 0.7"
RPANEL="set lmargin at screen 0.7; set rmargin at screen 1.0"

TPANEL="set bmargin at screen 0.1; set tmargin at screen 0.9"
BPANEL="set bmargin at screen 0.15; set tmargin at screen 0.5"

set tmargin 0
set bmargin 0

NOYTICS="set format y ''; unset ylabel"
NOXTICS="set format x ''; unset xlabel"
XTICS="set format x; set xlabel '$ \\\\lambda~(\\\\mu\\\\mathrm{m})$' offset 0.0,-0.5"
XTICS2="set format x; unset xlabel"
YTICS="set format y; set ylabel '$ P(\\\\lambda)=-S_{12}/S_{11}$' offset -0.5,-0.0"
YTICS2="set format y"

set xtics 2.0,0.5,4.5 offset 0.0,-0.3
set mxtics 5

set ytics -0.2,0.2,1.0 offset 0.0,0.0
set mytics 2

@LPANEL;@TPANEL;@YTICS;@XTICS
unset label
set xr[2:4.25]
set yr[-0.2:1.2]
set title "$ q=3.5$"
unset key

plot "../data/pwavel_fice0.3_q3.5_amax1.0E+03um_amin1.0E+02um.dat" every:::1::1 u 1:7 w l ls 5,\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+03um_amin3.0E-01um.dat" every:::1::1 u 1:7 w l ls 1,\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+03um_amin3.0E+00um.dat" every:::1::1 u 1:7 w l ls 2,\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+03um_amin1.0E+01um.dat" every:::1::1 u 1:7 w l ls 3,\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+03um_amin3.0E+01um.dat" every:::1::1 u 1:7 w l ls 4

unset key
@MPANEL;@TPANEL;@NOYTICS;@XTICS
unset key
unset label
set label at 3.0,0.0 "$ a_\\\\mathrm{min}=0.3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "red"
set label at 3.55,0.23 "$ 3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "forest-green"
set label at 3.5,0.4 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "blue"
set label at 3.5,0.8 "$ 30~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "dark-pink"
set label at 2.1,1.06 "$ a_\\\\mathrm{min}=100~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "black"
set title "$ q=3.0$"

plot "../data/pwavel_fice0.3_q3.0_amax1.0E+03um_amin1.0E+02um.dat" every:::1::1 u 1:7 w l ls 5,\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+03um_amin3.0E-01um.dat" every:::1::1 u 1:7 w l ls 1,\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+03um_amin3.0E+00um.dat" every:::1::1 u 1:7 w l ls 2,\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+03um_amin1.0E+01um.dat" every:::1::1 u 1:7 w l ls 3,\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+03um_amin3.0E+01um.dat" every:::1::1 u 1:7 w l ls 4

@RPANEL;@TPANEL;@NOYTICS;@XTICS
set title "$ q=2.5$"
unset label

plot "../data/pwavel_fice0.3_q2.5_amax1.0E+03um_amin1.0E+02um.dat" every:::1::1 u 1:7 w l ls 5,\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+03um_amin3.0E-01um.dat" every:::1::1 u 1:7 w l ls 1,\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+03um_amin3.0E+00um.dat" every:::1::1 u 1:7 w l ls 2,\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+03um_amin1.0E+01um.dat" every:::1::1 u 1:7 w l ls 3,\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+03um_amin3.0E+01um.dat" every:::1::1 u 1:7 w l ls 4

unset multiplot

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

