#!/usr/bin/bash

# 
# Figure name
#
fn="fig5"

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz size 12,8
set colors classic
set output "graph.tex"

#
# Plot data
#
#set size sq

set linestyle 1 lw 2 dt 1 
set linestyle 2 lw 2 dt 1 
set linestyle 3 lw 2 dt 1
set linestyle 4 lw 2 dt 1 
set linestyle 5 lw 2 dt 1 

set linestyle 6 lw 2 lc 1 dt 1 
set linestyle 7 lw 2 dt 1 lc rgb "forest-green"
set linestyle 8 lw 2 lc 3 dt 1
set linestyle 9 lw 2 dt 1 lc rgb "dark-pink"
set linestyle 10 lw 2 dt 1 lc rgb "#4D4D4D"


set multiplot layout 1,3
set macros
LPANEL="set lmargin at screen 0.1; set rmargin at screen 0.4"
MPANEL="set lmargin at screen 0.4; set rmargin at screen 0.7"
RPANEL="set lmargin at screen 0.7; set rmargin at screen 1.0"

TPANEL="set bmargin at screen 0.5; set tmargin at screen 0.85"
BPANEL="set bmargin at screen 0.15; set tmargin at screen 0.5"

set tmargin 0
set bmargin 0

NOYTICS="set format y ''; unset ylabel"
NOXTICS="set format x ''; unset xlabel"
XTICS="set format x; set xlabel '$ \\\\lambda~(\\\\mu\\\\mathrm{m})$' offset 0.0,-0.5"
XTICS2="set format x; unset xlabel"
YTICS="set format y; set ylabel '$ P(\\\\lambda)=-S_{12}/S_{11}$' offset -0.5,-4.0"
YTICS2="set format y"

set xtics 2.0,0.5,4.5 offset 0.0,-0.3
set mxtics 5

set ytics -0.2,0.2,1.0 offset 0.0,0.0
set mytics 2

@LPANEL;@TPANEL;@YTICS;@NOXTICS
unset label
set xr[2:4.25]
set yr[-0.1:0.9]
set title "$ q=3.5$"
#set key 
unset key

set label at 2.3,0.7 "$ a_\\\\mathrm{max}=0.1~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "red"
set label at 2.1,0.5 "$ 0.3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "forest-green"
set label at 3.6,0.4 "$ 1~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "blue"
set label at 3.5,0.25 "$ 3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "dark-pink"
set label at 3.5,0.0 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" textcolor rgb "#4D4D4D"

plot "../data/pwavel_fice0.3_q3.5_amax1.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 6 title "$ 0.1~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax3.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 7 title "$ 0.3~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 8 title "$ 1.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax3.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 9 title "$ 3.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 10 title "$ 10~\\\\mu\\\\mathrm{m}$"

unset key
@MPANEL;@TPANEL;@NOYTICS;@NOXTICS
unset key
unset label
set label at 2.3,0.7 "$ a_\\\\mathrm{max}=0.1~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "red"
set label at 2.1,0.5 "$ 0.3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "forest-green"
set label at 3.6,0.4 "$ 1~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "blue"
set label at 3.5,0.2 "$ 3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "dark-pink"
set label at 3.45,-0.02 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" textcolor rgb "#4D4D4D"

set title "$ q=3.0$"

plot "../data/pwavel_fice0.3_q3.0_amax1.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 6 title "$ 0.1~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.0_amax3.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 7 title "$ 0.3~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 8 title "$ 1.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.0_amax3.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 9 title "$ 3.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 10 title "$ 10~\\\\mu\\\\mathrm{m}$"

@RPANEL;@TPANEL;@NOYTICS;@NOXTICS
set title "$ q=2.5$"
unset label
set label at 2.3,0.7 "$ a_\\\\mathrm{max}=0.1~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "red"
set label at 2.1,0.5 "$ 0.3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "forest-green"
set label at 3.6,0.4 "$ 1~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "blue"
set label at 3.5,0.16 "$ 3~\\\\mu\\\\mathrm{m}$" font ",6" textcolor "dark-pink"
set label at 2.9,0.005 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" textcolor rgb "#4D4D4D"


plot "../data/pwavel_fice0.3_q2.5_amax1.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 6 title "$ 0.1~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q2.5_amax3.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 7 title "$ 0.3~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 8 title "$ 1.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q2.5_amax3.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 9 title "$ 3.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 10 title "$ 10~\\\\mu\\\\mathrm{m}$"

load "rdgy.pal"
set style data lines
unset colorbox

set yr[-0.1:0.9]
@LPANEL;@BPANEL;@YTICS2;@XTICS
unset key
set notitle
unset label
set label at 3.0,0.4 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" rotate by -70 textcolor "#4D4D4D"
set label at 3.15,0.6 "$ 1~\\\\mathrm{mm}$" font ",6" rotate by -68 textcolor rgb "#B2192B"

plot "../data/pwavel_fice0.3_q3.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 4.0/4.0 title "$ 10~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax3.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 3.0/4.0  title "$ 30~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+02um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 2.0/4.0  title "$ 0.1~\\\\mathrm{mm}$",\
     "../data/pwavel_fice0.3_q3.5_amax3.0E+02um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 1.0/4.0  title "$ 0.3~\\\\mathrm{mm}$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+03um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 0.0/4.0  title "$ 1~\\\\mathrm{mm}$"

@MPANEL;@BPANEL;@NOYTICS
unset label
set label at 3.0,0.35 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" rotate by -70 textcolor rgb "#4D4D4D"
set label at 3.2,0.75 "$ 1~\\\\mathrm{mm}$" font ",6" rotate by -66 textcolor rgb "#B2192B"

plot "../data/pwavel_fice0.3_q3.0_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 4.0/4.0 title "$ 10~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.0_amax3.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 3.0/4.0  title "$ 30~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+02um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 2.0/4.0  title "$ 0.1~\\\\mathrm{mm}$",\
     "../data/pwavel_fice0.3_q3.0_amax3.0E+02um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 1.0/4.0  title "$ 0.3~\\\\mathrm{mm}$",\
     "../data/pwavel_fice0.3_q3.0_amax1.0E+03um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 0.0/4.0  title "$ 1~\\\\mathrm{mm}$"

@RPANEL;@BPANEL;@NOYTICS
unset label
set label at 3.05,0.35 "$ 10~\\\\mu\\\\mathrm{m}$" font ",6" rotate by -70 textcolor rgb "#4D4D4D"
set label at 3.33,0.8 "$ 1~\\\\mathrm{mm}$" font ",6" rotate by -64 textcolor rgb "#B2192B"

plot "../data/pwavel_fice0.3_q2.5_amax1.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 4.0/4.0 title "$ 10~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q2.5_amax3.0E+01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 3.0/4.0  title "$ 30~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+02um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 2.0/4.0  title "$ 0.1~\\\\mathrm{mm}$",\
     "../data/pwavel_fice0.3_q2.5_amax3.0E+02um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 1.0/4.0  title "$ 0.3~\\\\mathrm{mm}$",\
     "../data/pwavel_fice0.3_q2.5_amax1.0E+03um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l lw 2 lc palette frac 0.0/4.0  title "$ 1~\\\\mathrm{mm}$"

unset multiplot

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

