#!/usr/bin/bash

# 
# Figure name
#
fn=fig4b

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#

set linestyle 1 lw 4 dt 1
set linestyle 2 lw 4 dt 1 lc rgb "forest-green"
set linestyle 3 lw 4 dt 3
set linestyle 4 lw 4 dt 4
set linestyle 5 lw 4 dt 5

set log x
set format x "$ 10^{%L}$"
set xlabel "$ a_\\\\mathrm{max}~(\\\\mu\\\\mathrm{m})$" font ",14" offset 0.0,-0.5
set ylabel "$ P(\\\\lambda)=-S_{12}/S_{11}$" font ",14" offset -2.0,0.0
set xtics font ",14" offset 0.0,-0.5
set ytics font ",14"
set xr[1.0e-2:1.e3]
set yr[-0.15:1.0]
set label at 1.4e-2,0.86 "(b) Power-law dist. $ q=3.5,~\\\\theta=60^\\\\circ$" font ",12"
set label at 10.0,0.43 "$ \\\\lambda=3.07~\\\\mu\\\\mathrm{m}$" font ",14" textcolor "forest-green"
set label at 10.0,0.2 "$ \\\\lambda=2.5~\\\\mu\\\\mathrm{m}$" font ",14" textcolor "red"
set key at 0.7,0.15 spacing 1.5


plot "../data/pvsa_mrn_fice0.3_q3.5_amin5.0E-03um.dat" every:::1::1 u 1:3 w l ls 2 title "$ \\\\lambda=3.07~\\\\mu\\\\mathrm{m}$",\
     "../data/pvsa_mrn_fice0.3_q3.5_amin5.0E-03um.dat" every:::0::0 u 1:3 w l ls 1 title "$ \\\\lambda=2.5~\\\\mu\\\\mathrm{m}$"

EOF
#
# Compiling Figure data with LATEX.
#
make
mv figure.pdf $fn'.pdf'
# 
# Clean-up files...
#
make clean

