#!/usr/bin/bash

# 
# Figure name
#
fn=fig4a

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
set linestyle 1 lw 2 dt 1
set linestyle 2 lw 2 dt 1 lc rgb "forest-green"
set linestyle 3 lw 2 dt 3
set linestyle 4 lw 2 dt 4
set linestyle 5 lw 2 dt 5

set xlabel "$ a~(\\\\mu\\\\mathrm{m})$" font ",14" offset 0.0,-0.5
set ylabel "$ P(\\\\lambda)=-S_{12}/S_{11}$" font ",14" offset -2.0,0.0
set xtics font ",14" offset 0.0,-0.5
set ytics font ",14"

set log x
set yr[-1:1.15]
set format x "$ 10^{%L}$"

set key at 0.8,0.-0.6 spacing 1.5 font ",12"
set label at 8.0e-3,0.84 "(a) Single size,~$\\\\theta=60^\\\\circ$" font ",12"

#
# IceSil_fice0.3_3Bands.lnk 
#
# Lambda = 3.07 micron
lam_cent = 3.07
n_lam_cent=1.40507E+00
k_lam_cent=4.56574E-01
# Lambda = 2.5 micron
lam_outs = 2.5
n_lam_outs=1.35365E+00
k_lam_outs=1.01034E-02

#
#
# Compute grain radius at which phase shift=1 and tau_{abs} = 1 or 10 
#
a_phase1_cent = lam_cent/(4.0*pi*(n_lam_cent-1))
a_phase1_outs = lam_outs/(4.0*pi*(n_lam_outs-1))
a_tau1_cent = 3.0*lam_cent/(16.0*pi*k_lam_cent)
a_tau1_outs = 3.0*lam_outs/(16.0*pi*k_lam_outs)
a_tau10_cent = 30.0*lam_cent/(16.0*pi*k_lam_cent)
a_tau10_outs = 30.0*lam_outs/(16.0*pi*k_lam_outs)
#

set arrow from a_phase1_cent,1.0 to a_phase1_cent,1.1 nohead lc rgb "forest-green" lw 2 
set arrow from a_phase1_outs,1.0 to a_phase1_outs,1.1 nohead lc rgb "red" lw 2 
set arrow from a_tau10_cent,1.0 to a_tau10_cent,1.1 nohead lc rgb "forest-green" lw 2 dt 4 
set arrow from a_tau10_outs,1.0 to a_tau10_outs,1.1 nohead lc rgb "red" lw 2 dt 4

plot "../data/pvsa_single_fice0.3.dat" every:::1::1 u 1:3 w l ls 2 title "$ \\\\lambda=3.07~\\\\mu\\\\mathrm{m}$",\
     "../data/pvsa_single_fice0.3.dat" every:::0::0 u 1:3 w l ls 1 title "$ \\\\lambda=2.5~\\\\mu\\\\mathrm{m}$"

EOF
#
# Compiling Figure data with LATEX.
#
make
mv figure.pdf $fn'.pdf'
# 
# Clean-up files...
#
make clean

