import math
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.collections as mcoll
import matplotlib.cm as cm
import matplotlib as mpl


def multicolored_lines():
    """
    http://nbviewer.ipython.org/github/dpsanders/matplotlib-examples/blob/master/colorline.ipynb
    http://matplotlib.org/examples/pylab_examples/multicolored_line.html
    """

    mpl.rcParams["text.usetex"] = True

    wavel_a03,dphi_a03,tau_a03 = np.loadtxt('../data/dphitabs_a0.3um_fice0.3.dat',unpack=True,comments='#',usecols=(0,1,2))
    wavel_a1,dphi_a1,tau_a1 = np.loadtxt('../data/dphitabs_a1.0um_fice0.3.dat',unpack=True,comments='#',usecols=(0,1,2))
    wavel_a3,dphi_a3,tau_a3 = np.loadtxt('../data/dphitabs_a3.0um_fice0.3.dat',unpack=True,comments='#',usecols=(0,1,2))

    fig, ax = plt.subplots()
    #lc=colorline(dphi_a03,tau_a03,wavel_a03,cmap=cm.cividis)
    lc=colorline(dphi_a03,tau_a03,wavel_a03,cmap='jet_r')
    lc=colorline(dphi_a1,tau_a1,wavel_a1,cmap='jet_r')
    lc=colorline(dphi_a3,tau_a3,wavel_a3,cmap='jet_r')
    ax.set_xscale('log')
    ax.set_yscale('log')
    ax.set_xlim(1.e-1,2.e1)
    ax.set_ylim(5.e-3,3.e1)
    ax.set_xlabel(r'$\Delta\phi\propto x(n-1)$',fontsize=20)
    ax.set_ylabel(r'$\tau_\mathrm{abs}\propto kx$',fontsize=20)
    ax.tick_params(labelsize=20)
    ax.vlines(x=1.0, ymin=5e-3, ymax=1.0)
    ax.hlines(y=1.0, xmin=1.0, xmax=3.e1)
    cbar=fig.colorbar(lc,ax=ax)
    cbar.set_label(r'$\lambda\ (\mu\mathrm{m})$',fontsize=18)
    cbar.ax.tick_params(labelsize=18)
   
    ax.text(1.5,0.011, '$\mathrm{Low\ polarization\ degree}$', fontsize=12)
    ax.text(0.15,10.5, '$\mathrm{High\ polarization\ degree}$', fontsize=12)

    a25,dphi25,tabs25 = np.loadtxt('../data/dphitabs_lam2.5.dat',unpack=True,comments='#',usecols=(0,1,2))
    a307,dphi307,tabs307 = np.loadtxt('../data/dphitabs_lam3.07.dat',unpack=True,comments='#',usecols=(0,1,2))
    ax.plot(dphi307[:],tabs307[:],color='g',linestyle='--',marker='o')
    ax.plot(dphi25[:],tabs25[:],color='r',linestyle='--',marker='o')

    ax.set_title(r'$ f_\mathrm{ice}=0.3$',fontsize=20)
    ax.text(0.12,0.6, r'$0.3\ \mu\mathrm{m}$', fontsize=12)
    ax.text(0.5,2.5, r'$1\ \mu\mathrm{m}$', fontsize=12)
    ax.text(1.5,7.0, r'$3\ \mu\mathrm{m}$', fontsize=12)
    fig.tight_layout()
    plt.savefig('fig3.pdf')
    #plt.show()

def colorline(
        x, y, z, cmap,
        linewidth=3, alpha=1.0):
#        x, y, z=None, cmap='copper', norm=plt.Normalize(0.0, 1.0),
#        linewidth=3, alpha=1.0):
    """
    http://nbviewer.ipython.org/github/dpsanders/matplotlib-examples/blob/master/colorline.ipynb
    http://matplotlib.org/examples/pylab_examples/multicolored_line.html
    Plot a colored line with coordinates x and y
    Optionally specify colors in the array z
    Optionally specify a colormap, a norm function and a line width
    """

#    # Default colors equally spaced on [0,1]:
#    if z is None:
#        z = np.linspace(0.0, 1.0, len(x))
#
#    # Special case if a single number:
#    # to check for numerical input -- this is a hack
#    if not hasattr(z, "__iter__"):
#        z = np.array([z])
#
#    z = np.asarray(z)

    segments = make_segments(x, y)
#    lc = mcoll.LineCollection(segments, array=z, cmap=cmap, norm=norm,
#                              linewidth=linewidth, alpha=alpha)
    lc = mcoll.LineCollection(segments, array=z, cmap=cmap,
                              linewidth=linewidth, alpha=alpha)
    ax = plt.gca()
    ax.add_collection(lc)

    return lc

def make_segments(x, y):
    """
    Create list of line segments from x and y coordinates, in the correct format
    for LineCollection: an array of the form numlines x (points per line) x 2 (x
    and y) array
    """

    points = np.array([x, y]).T.reshape(-1, 1, 2)
    segments = np.concatenate([points[:-1], points[1:]], axis=1)
    return segments

multicolored_lines()
