#!/usr/bin/bash

# 
# Figure name
#
fn=fig2

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
set linestyle 1 lw 4 lc 1 dt 1 
set linestyle 2 lw 4 dt 1 lc rgb "blue"
set linestyle 3 lw 4 dt 1 lc rgb "black"

set xr[2:4.25]
set yr[0:0.8]

set tics font ",15"
set xtics 2.0,0.2,4.25
set xtics offset 0.0,-0.5
set mxtics 4
set mytics 4

set xlabel "$ \\\\lambda~(\\\\mu\\\\mathrm{m})$" offset 0.0,-1.4 font ",20"
set ylabel "$ P(\\\\lambda)=-S_{12}/S_{11}$" offset -2.5,0.0 font ",20"
unset label
set label "$ \\\\theta=60^\\\\circ,~f_\\\\mathrm{ice}=0.3,~q=3.5$" at 2.1,0.72 font ",10"
set key font ",8"

set label at 3.3,0.65 "$ a_\\\\mathrm{max}=0.3~\\\\mu\\\\mathrm{m}$" font ",14" textcolor rgb "red"
set label at 3.6,0.4 "$ 1~\\\\mu\\\\mathrm{m}$" font ",14" textcolor rgb "blue"
set label at 3.65,0.2 "$ 3~\\\\mu\\\\mathrm{m}$" font ",14" textcolor rgb "black"

unset key

plot "../data/pwavel_fice0.3_q3.5_amax3.0E-01um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 1 title "$ a_\\\\mathrm{max}=0.3~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax1.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 2 title "$ a_\\\\mathrm{max}=1.0~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.3_q3.5_amax3.0E+00um_amin5.0E-03um.dat" every:::1::1 u 1:7 w l ls 3 title "$ a_\\\\mathrm{max}=3.0~\\\\mu\\\\mathrm{m}$"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'
# 
# Clean-up files...
#
make clean
