#!/usr/bin/bash

# 
# Figure name
#
fn=fig1a

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#

gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#

set linestyle 1 lw 3 dt 1 
set linestyle 2 lw 3 dt 2 lc rgb "forest-green"
set linestyle 3 lw 3 dt 3
set linestyle 4 lw 3 dt 4
set linestyle 5 lw 3 dt 5

set linestyle 6 lw 3 dt 4 lc rgb "black"
set linestyle 7 lw 3 dt 8 lc rgb "black"

set xlabel "$ \\\\lambda$ ($ \\\\mu\\\\mathrm{m}$)" font ",15"
set ylabel "$ n$" font ",15"
set tics font ",15"

set xlabel offset 0,-1
set ylabel offset -2,0
set xtics offset 0,-0.5
set xr[2.0:4.25]
set yr[0.9:1.75]
set key right bottom spacing 1.2

plot "../data/IceSilicate_Iceband_fice1.0.lnk" u 1:2 w l ls 1 title "$ f_\\\\mathrm{ice}=1.0$",\
     "../data/IceSilicate_Iceband_fice0.3.lnk" u 1:2 w l ls 2 title "$ f_\\\\mathrm{ice}=0.3$",\
     "../data/IceSilicate_Iceband_fice0.1.lnk" u 1:2 w l ls 3 title "$ f_\\\\mathrm{ice}=0.1$",\
     "../data/IceSilicate_Iceband_fice0.03.lnk" u 1:2 w l ls 4 title "$ f_\\\\mathrm{ice}=0.03$",\
     "../data/IceSilicate_Iceband_fice0.01.lnk" u 1:2 w l ls 5 title "$ f_\\\\mathrm{ice}=0.01$",\
     "../data/IceSilicate_Iceband_pureice.lnk" u 1:2 w l ls 6 title "$ \\\\mathrm{pure~ice}$",\
     "../data/IceSilicate_Iceband_puresil.lnk" u 1:2 w l ls 7 title "$ \\\\mathrm{pure~silicate}$"


EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'
# 
# Clean-up files...
#
make clean
