#!/usr/bin/bash

# 
# Figure name
#
fn="fig17b"

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#

set linestyle 1 lw 2 dt 4 lc rgb "grey70"
set linestyle 2 lw 2 lc rgb "black"
set linestyle 3 lw 1.5 dt 1 lc rgb "red"
set linestyle 4 lw 1.5 dt 1 lc rgb "web-green"
set linestyle 5 lw 1.5 dt 1 lc rgb "blue"
set linestyle 6 lw 1.5 dt 1 lc rgb "navy"

set tics font ",14"
set xtics offset 0.0,-0.25
set xlabel "Scattering angle (deg)" font ",14" offset 0.0,-0.5
set ylabel "$ S_{11}$" font ",14" offset -1.0,0.0 
set yr[1.0e-1:1.e8]
set mytics 10
set log y
set format y "$ 10^{%L}$"
set xr[0:180]
set label "(b) $ x=100,~m=1.1+0i$" at 5,3e7 font ",12"
set key at 90,5.e6 font ",12" spacing 1.25
set label "Surf. sca." at 10,5.0e1 textcolor rgb "red"
set label "$ p=1$" at 70,1.e0 textcolor rgb "forest-green"
set label "$ p=2$" at 40,2.0 textcolor rgb "blue"
set label "$ p=3$" at 105,0.6 textcolor rgb "navy"

set label "$ \\\\langle \\\\cos\\\\theta \\\\rangle=0.951$" at 125,3e7

plot "../data/debye_x100_m1.1k0.dat" every:::0::0 u 1:2 w l ls 2 title "Debye series",\
     "../data/debye_x100_m1.1k0.dat" every:::0::0 u 1:3 w l ls 1 title "Mie theory",\
     "../data/debye_x100_m1.1k0.dat" every:::0::0 u 1:4 w l ls 3 notitle,\
     "../data/debye_x100_m1.1k0.dat" every:::0::0 u 1:5 w l ls 4 notitle,\
     "../data/debye_x100_m1.1k0.dat" every:::0::0 u 1:6 w l ls 5 notitle,\
     "../data/debye_x100_m1.1k0.dat" every:::0::0 u 1:7 w l ls 6 notitle

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean
