#!/usr/bin/bash

# 
# Figure name
#
fn=fig15b

# 
# Make clean 
#
make clean


#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
#set size sq
set linestyle 1 lw 3 lc rgb "royalblue" dt 4
set linestyle 2 lw 3 dt 1 lc rgb "red"
set linestyle 3 lw 3 dt 4 lc rgb "web-green"
set linestyle 4 lw 2 dt 5 lc rgb "grey30"

set xr[2:4.25]
set yr[0:90]
set xtics 2.0,0.2,4.25
set tics font ",15"
set xlabel "$ \\\\lambda~(\\\\mu\\\\mathrm{m})$" offset 0.0,-1.25 font ",16"
set ylabel "$ P~[\\\\%]$" offset -2.5,0.0 font ",16"
set xtics offset 0.0,-0.5
unset label

set label " (b)" at 2.1,80 font ",14"
set key at 4.2,80 spacing 1.3

plot "../data/Kobayashi99_Fig3_Digitized.txt" u 1:2:4:6 w yerrorbars pt 6 ps 2 lw 2 lc rgb "black" title "Kobayashi+99",\
     "../data/Nagata_et_al_1983.txt" u 1:2:4 w yerrorbars pt 4 ps 2 lw 2 lc rgb "grey40" title "Nagata+83",\
     "../data/pwavel_fice0.05_q3.5_amax5.0E+00um_amin5.0E-03um.dat" every:::2::2 u 1:(\$7*100) w l ls 3 title "$ f_\\\\mathrm{ice}=0.05,~5~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.03_q3.5_amax5.0E+00um_amin5.0E-03um.dat" every:::2::2 u 1:(\$7*100) w l ls 2 title "$ f_\\\\mathrm{ice}=0.03,~5~\\\\mu\\\\mathrm{m}$",\
     "../data/pwavel_fice0.02_q3.5_amax5.0E+00um_amin5.0E-03um.dat" every:::2::2 u 1:(\$7*100) w l ls 1 title "$ f_\\\\mathrm{ice}=0.02,~5~\\\\mu\\\\mathrm{m}$"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

