#!/usr/bin/bash

# 
# Figure name
#
fn=fig14c

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
set linestyle 1 lw 3 dt 1 lc rgb "black"
set linestyle 2 lw 3 dt 4 lc rgb "red"

set xr[2:4.25]
set yr[-0.3:1.1]
set xtics 2.0,0.2,4.25
set tics font ",15"
set xlabel "$ \\\\lambda~(\\\\mu\\\\mathrm{m})$" offset 0.0,-1.25 font ",16"
set ylabel "$ -S_{12}/S_{11}$" offset -2.5,0.0 font ",16"
set xtics offset 0.0,-0.5
unset label

set label at 2.1,0.95 "$ \\\\langle a\\\\rangle=10~\\\\mu\\\\mathrm{m},~\\\\sigma=0.1,~f_\\\\mathrm{ice}=0.3$" font ",10" 
set label "$ \\\\theta=150^\\\\circ$" at 2.8,0.4 font ",10" textcolor rgb "black"

unset key

plot "../data/pwavel_10mic_lognorm0.1_fice0.3_np0.out" every:::4::4 u 1:2 w l ls 1 title "full scattering (Mie theory)",\
     "../data/pwavel_10mic_lognorm0.1_fice0.3_np0.out" every:::4::4 u 1:3 w l ls 2 title "only surface scattering"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

