#!/usr/bin/bash

# 
# Figure name
#
fn="fig13b"

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#
gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#

set linestyle 1 lw 3 dt 4 lc rgb "grey50"
set linestyle 2 lw 3 lc rgb "red"
set linestyle 3 lw 1.5 dt 1 lc rgb "black"
set linestyle 4 lw 1.5 dt 5 lc rgb "blue"
set linestyle 5 lw 1.5 dt 1  lc rgb "forest-green

set linestyle 7 lw 1.5 dt 4 lc rgb "black"
set linestyle 8 lw 1.5 dt 4 lc rgb "blue"

set tics font ",14"
set xtics offset 0.0,-0.25
set xlabel "Scattering angle (deg)" font ",14" offset 0.0,-0.5
set ylabel "$ -S_{12}/S_{11}$" font ",14" offset -1.0,0.0
set xr[0:180]
set yr[0:1]
set key spacing 1.2 at 180,0.94

plot "../data/scatmat_10mic_lognorm0.1_fice0.3_npinf.out" every:::3::3 u 1:2 w l ls 2 title "Debye series",\
     "../data/scatmat_10mic_lognorm0.1_fice0.3_npinf.out" every:::3::3 u 1:3 w l ls 1 title "Mie theory",\
     "../data/scatmat_10mic_lognorm0.1_fice0.3_npinf.out" every:::3::3 u 1:4 w l ls 3 notitle,\
     "../data/fresnel_fice0.3.out" every:::1::1 u 1:3 w l ls 7 notitle,\

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean

