#!/usr/bin/bash

# 
# Figure name
#
fn=fig11

# 
# Make clean 
#
make clean

#
# PLOT BASE FIGURE WITH GNUPLOT
#

gnuplot <<EOF
#
# Preparing tex output 
#
set terminal tikz createstyle
set terminal tikz
set colors classic
set output "graph.tex"

#
# Plot data
#
set linestyle 1 lw 3 dt 1 lc rgb "red" 
set linestyle 2 lw 3 dt 2 lc rgb "forest-green"
set linestyle 3 lw 3 dt 3
set linestyle 4 lw 3 dt 4
set linestyle 5 lw 3 dt 5
set linestyle 6 lw 3 dt 5

set xlabel "$ \\\\lambda$ ($ \\\\mu\\\\mathrm{m}$)" font ",15"
set ylabel "$ \\\\tau_\\\\mathrm{abs}$" font ",15"
set tics font ",15"

set xlabel offset 0,-1
set ylabel offset -2,0
set xtics offset 0,-0.5

set log y
set format y "$ 10^{%L}$"
set xr[2.0:4.25]
set yr[1.0e-2:1.0e2]
set key right top spacing 1.2

a1 = 0.5
a2 = 3.0
a3 = 10.0

set key at 4.2,65 font ",12" spacing 1.25

#
# tau_abs = 8.0*x*Im(m)/3.0 = 16.0*pi*a*Im(m)/(3.0*lambda)
#
plot "../data/IceSilicate_Iceband_fice0.3.lnk" u 1:(16.0*pi*a3*\$3/(3.0*\$1)) w l ls 1 title "$ a=10~\\\\mu\\\\mathrm{m}$",\
     "../data/IceSilicate_Iceband_fice0.3.lnk" u 1:(16.0*pi*a2*\$3/(3.0*\$1)) w l ls 2 title "$ a=3.0~\\\\mu\\\\mathrm{m}$",\
     "../data/IceSilicate_Iceband_fice0.3.lnk" u 1:(16.0*pi*a1*\$3/(3.0*\$1)) w l ls 3 title "$ a=0.5~\\\\mu\\\\mathrm{m}$"

EOF
#
# Compiling Figure date with LATEX.
#
make
mv figure.pdf $fn'.pdf'

# 
# Clean-up files...
#
make clean
