
# Reproduction package for the paper "Scattering polarization of 3 µm water-ice feature by large icy grains"

This is a basic reproduction package for the paper "Scattering polarization of 3 µm water-ice feature by large icy grains" by [Tazaki et al. (2021)](https://ui.adsabs.harvard.edu/abs/2021arXiv210107635T).

## Raw Data

No raw data is included in RP since it is all public. 
Optical constants of water ice and astronomical silicate are available at the following links.

- Water Ice: [Warren & Brandt (2008)](https://atmos.uw.edu/ice_optical_constants/)

- Astronomical Silicate: [Draine (2003)](https://www.astro.princeton.edu/~draine/dust/dust.diel.html)

## Software

List of OS, programing language, and software used to reproduce the results.

* OS used for all analysis: mac OS Mojave Version 10.14.1/Cent OS 7 
* Programming languages used: gcc version 9.1.0 / ifort 13.1.0 / python 3.8.5
* GNUPLOT v 5.4 
* TeX, Version 3.14159265 (TeX Live 2017)
* [PlotDigitizer X](http://www.surf.nuqe.nagoya-u.ac.jp/~nakahara/software/plotdigitizerx/index-e.html)

## Figures and Tables

List of files used to reproduce figures and a table.

- `figures.tar.gz` : figure scripts and .pdf files.
- `data.tar.gz`       : All data used to make figures and Table 1

For example, in `figures.tar.gz`, `fig1.sh` is the script file used to make Figure 1, and data files, which can be found in `data.tar.gz`,  necessary to plot Figure 1 is given in the script file. 

## End-to-End analysis codes 

In `codes.tar.gz`, source codes used to perform all analysis are provided. The list of working directories is as follows. 

* `opcont`
  This directory contains Fortran 90 programs to calculate the optical constant of the ice-silicate mixture. 
* `polfeat ` 
  This directory contains Fortran 90 programs to calculate the scattering polarization feature for various grain-size distributions by using the Mie theory. 
* `phase_diagram`
  This directory contains Fortran 90 programs used to calculate the optical thickness and phase shift of spherical particles. 
* `debye` 
  This directory contains Fortran 90 programs to calculate the scattering polarization feature utilizing the Debye series.
* `debye_benchmark `
  This directory contains Fortran 90 programs to perform benchmark calculations of the Debye series code.

All output files generated by the above codes are available in `data.tar.gz`.

## Extra information

- To run the Fortran 90 codes, one may need to put data files of optical constants of ice-silicate mixtures in each working directory. The optical constant data files have `.lnk` extension and can be found in `data.tar.gz`.  For example, `IceSilicate_Iceband_fice0.3.lnk` for the case of the fice=0.3 model.

- To run fig*.sh, both GNUPLOT and TeX are necessary. 

- In `data.tar.gz`, `Kobayashi99_Fig3_Digitized.txt` is the data file to reproduce Figure 3 (middle panel) of Kobayashi et al. (1999).  Because the original digital data is not available anymore, we digitized the data points in Figure 3 of their paper with the software [PlotDigitizer X](http://www.surf.nuqe.nagoya-u.ac.jp/~nakahara/software/plotdigitizerx/index-e.html) using a by-eye fit.

