ProbeInit[];

VerificationTest[ProbeGetGroundstates[]
	, ProbeGetGroundstates[]
	, TestID -> "ProbeGetGroundstates-inited"
];


ProbeInit[PauliMatrix[{1,2,3}], Probe->"Laplace", StartingPoint->{1,0,0}];

VerificationTest[ProbeGetGroundstates[]
	, {{-0.707107 + 0. I, -0.707107 + 0. I}}
	, TestID -> "ProbeGetGroundstates-1"
	, SameTest -> Function[{list1,list2}, Block[{i, same},
		same = True;
		
		For[i=1,i<=Length[list1],i++,
			If[Norm[list1[[i]]-list2[[i]]] > 10^-4,
			same = False;
			];
		];
	
		Return[same];
	]]
];

ProbeScan[StepSize->0.8];

VerificationTest[ProbeGetGroundstates[]
	, {{-0.707107+0. I,-0.707107+0. I},{0.552158 -0.441726 I,0.707107 +0. I},{0.552158 +0.441726 I,0.707107 +0. I},{-0.901303+0. I,-0.433189+0. I},{-0.433189+0. I,-0.901303+0. I},{0.7038 -0.56304 I,0.433189 +0. I},{-0.338264+0.270611 I,-0.901303+0. I},{0.155116 -0.689883 I,0.707107 +0. I},{0.7038 +0.56304 I,0.433189 +0. I},{-0.338264-0.270611 I,-0.901303+0. I},{0.155116 +0.689883 I,0.707107 +0. I},{-0.993892+0. I,-0.110358+0. I},{-0.110358+0. I,-0.993892+0. I},{0.205238 -0.775782 I,0.596691 +0. I},{0.104467 -0.977489 I,0.183308 +0. I},{-0.152608+0.576846 I,-0.802471+0. I},{-0.0194797+0.18227 I,-0.983056+0. I},{0.197717 -0.87935 I,0.433189 +0. I},{-0.0950275+0.422637 I,-0.901303+0. I},{0.30969 +0.635682 I,-0.707107+0. I},{0.205238 +0.775782 I,0.596691 +0. I},{0.104467 +0.977489 I,0.183308 +0. I},{-0.152608-0.576846 I,-0.802471+0. I},{-0.0194797-0.18227 I,-0.983056+0. I},{0.197717 +0.87935 I,0.433189 +0. I},{-0.0950275-0.422637 I,-0.901303+0. I},{0.30969 -0.635682 I,-0.707107+0. I},{0.97442 -8.33004*10^-15 I,-0.224733+0. I},{0.224733 +1.92117*10^-15 I,-0.97442+0. I},{0.348303 +0.820534 I,-0.45322+0. I},{0.0884933 +0.606198 I,-0.790375+0. I},{0.824976 +0.435804 I,-0.359845+0. I},{0.17709 +0.41719 I,-0.891399+0. I},{0.114169 +0.782086 I,-0.612623+0. I},{0.318178 +0.168081 I,-0.933012+0. I},{0.684515 -0.481919 I,0.546985 +0. I},{-0.44726+0.314884 I,-0.837142+0. I},{0.639032 +0.302718 I,-0.707107+0. I},{0.348303 -0.820534 I,-0.45322+0. I},{0.0884933 -0.606198 I,-0.790375+0. I},{0.824976 -0.435804 I,-0.359845+0. I},{0.17709 -0.41719 I,-0.891399+0. I},{0.114169 -0.782086 I,-0.612623+0. I},{0.318178 -0.168081 I,-0.933012+0. I},{0.684515 +0.481919 I,0.546985 +0. I},{-0.44726-0.314884 I,-0.837142+0. I},{0.639032 -0.302718 I,-0.707107+0. I},{0.845017 -7.47959*10^-13 I,-0.534739+0. I},{0.534739 -7.36586*10^-13 I,-0.845017+0. I},{0.699139 +0.392247 I,-0.597785+0. I},{-0.285674+0.46541 I,-0.837725+0. I},{0.4965 +0.51044 I,-0.702096+0. I},{0.160602 +0.304753 I,-0.938793+0. I},{0.521339 +0.292494 I,-0.801656+0. I},{0.438235 -0.713956 I,0.546092 +0. I},{0.437679 +0.830524 I,-0.344481+0. I},{0.934901 -0.237803 I,0.263458 +0. I},{-0.430876+0.444328 I,-0.785442+0. I},{0.54679 -0.563861 I,0.618936 +0. I},{-0.255328+0.0649456 I,-0.964671+0. I},{0.699139 -0.392247 I,-0.597785+0. I},{-0.285674-0.46541 I,-0.837725+0. I},{0.4965 -0.51044 I,-0.702096+0. I},{0.160602 -0.304753 I,-0.938793+0. I},{0.521339 -0.292494 I,-0.801656+0. I},{0.438235 +0.713956 I,0.546092 +0. I},{0.437679 -0.830524 I,-0.344481+0. I},{0.934901 +0.237803 I,0.263458 +0. I},{-0.430876-0.444328 I,-0.785442+0. I},{0.54679 +0.563861 I,0.618936 +0. I},{-0.255328-0.0649456 I,-0.964671+0. I},{0.725365 -0.102273 I,-0.680724+0. I},{0.630345 +0.648458 I,-0.42681+0. I},{0.306572 +0.314983 I,-0.89822+0. I},{0.705584 +0.0882519 I,-0.703109+0. I},{-0.192841+0.336928 I,-0.92157+0. I},{0.47841 +0.157762 I,-0.863849+0. I},{0.0810859 -0.0174715 I,-0.996554+0. I},{0.457783 -0.799829 I,0.388212 +0. I},{0.820393 +0.270535 I,-0.503751+0. I},{0.974196 -0.209909 I,-0.0829468+0. I},{0.630345 -0.648458 I,-0.42681+0. I},{0.306572 -0.314983 I,-0.89822+0. I},{-0.192841-0.336928 I,-0.92157+0. I},{0.47841 -0.157762 I,-0.863849+0. I},{0.457783 +0.799829 I,0.388212 +0. I},{0.820393 -0.270535 I,-0.503751+0. I},{0.900052 +0.0795059 I,-0.428468+0. I},{-0.512545+0.182226 I,-0.839102+0. I},{0.367209 +0.519408 I,-0.771604+0. I},{0.0300686 -0.34537 I,-0.937985+0. I},{0.404611 -0.0516613 I,-0.913029+0. I},{0.79062 -0.281091 I,0.543975 +0. I},{0.0813552 -0.93445 I,-0.346676+0. I},{-0.512545-0.182226 I,-0.839102+0. I},{0.367209 -0.519408 I,-0.771604+0. I},{0.79062 +0.281091 I,0.543975 +0. I}}
	, TestID -> "ProbeGetGroundstates-2"
	, SameTest -> Function[{list1,list2}, Block[{i, same},
		same = True;
		
		For[i=1,i<=Length[list1],i++,
			If[Norm[list1[[i]]-list2[[i]]] > 10^-4,
			same = False;
			];
		];
	
		Return[same];
	]]
];

ProbeReset[];

VerificationTest[ProbeGetGroundstates[]
	, {{-0.707107 + 0. I, -0.707107 + 0. I}}
	, TestID -> "ProbeGetGroundstates-3"
	, SameTest -> Function[{list1,list2}, Block[{i, same},
		same = True;
		
		For[i=1,i<=Length[list1],i++,
			If[Norm[list1[[i]]-list2[[i]]] > 10^-4,
			same = False;
			];
		];
	
		Return[same];
	]]
];