## Parcels

**Parcels** (**P**robably **A** **R**eally **C**omputationally **E**fficient **L**agrangian **S**imulator) is a set of Python classes and methods to create customisable particle tracking simulations using output from Ocean Circulation models. Parcels can be used to track passive and active particulates such as water, plankton, [plastic](http://www.topios.org/) and [fish](https://github.com/Jacketless/IKAMOANA).

![Arctic-SO-medusaParticles](https://github.com/OceanParcels/oceanparcels_website/blob/master/images/homepage.gif)

*Animation of virtual particles carried by ocean surface flow in the global oceans. The particles are advected with [Parcels](http://oceanparcels.org/) in data from the [NEMO Ocean Model](https://www.nemo-ocean.eu/).*

### Parcels manuscript and code

The manuscript detailing the first release of Parcels, version 0.9, has been published in [Geoscientific Model Development](https://www.geosci-model-dev.net/10/4175/2017/gmd-10-4175-2017.html) and can be cited as 

*Lange, M. and E van Sebille (2017) Parcels v0.9: prototyping a Lagrangian Ocean Analysis framework for the petascale age. Geoscientific Model Development, 10, 4175-4186. https://doi.org/10.5194/gmd-2017-167*

The manuscript detailing version 2.0 of Parcels is available at [Geoscientific Model Development](https://www.geosci-model-dev.net/12/3571/2019/gmd-12-3571-2019-discussion.html) and can be cited as:

*Delandmeter P. and E van Sebille (2019) The Parcels v2.0 Lagrangian framework: new field interpolation schemes. Geoscientific Model Development, 12, 3571-3584. https://doi.org/10.5194/gmd-12-3571-2019*

### Further information

See [oceanparcels.org](http://oceanparcels.org/) for further information about [installing](http://oceanparcels.org/#installing) and [running](http://oceanparcels.org/#tutorials) the Parcels code, as well as extended [documentation](http://oceanparcels.org/gh-pages/html/) of the methods and classes.


### Launch Parcels Tutorials on mybinder.org

[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/OceanParcels/parcels_examples_binder/master?urlpath=lab/tree/parcels_examples/parcels_tutorial.ipynb)
[![Build Status](https://github.com/oceanparcels/parcels/workflows/test-suite/badge.svg?branch=master)](https://github.com/OceanParcels/parcels/actions?query=workflow%3Atest-suite+branch%3Amaster)
[![Anaconda-release](https://anaconda.org/conda-forge/parcels/badges/version.svg)](https://anaconda.org/conda-forge/parcels/)
[![Anaconda-date](https://anaconda.org/conda-forge/parcels/badges/latest_release_date.svg)](https://anaconda.org/conda-forge/parcels/)
