# Additional Resources / Readings

## Style Guides

* ["The tidyverse style guide"](https://style.tidyverse.org/)
  - Hadley Wickham's online resource with details on naming and styling R code

* ["Style Guide for Python Code"](https://www.python.org/dev/peps/pep-0008/)
  - the Python Enhancement Proposal from Guido van Rossum, Barry Warsaw, and Nick Coghlan

## Code Smells and Recommendations

* ["Code Smells and Feels"](https://github.com/jennybc/code-smells-and-feels)
  - GitHub repo from Jenny Bryan on "code smells" - also check out the related [slides](https://speakerdeck.com/jennybc/code-smells-and-feels)

* ["Writing clear code"](https://kbroman.org/AdvData/14_clearcode.pdf)
  - notes from Karl Broman

* ["Writing Clean Scientific Software"](https://zenodo.org/record/3922957)
  - slides from Nick Murphy on clean coding (examples in Python, a bit physics-oriented)
  
* ["Column Names as Contracts"](https://emilyriederer.netlify.app/post/column-name-contracts/)
  - Blogpost from Emily Riederer on selecting good column names to facilitate a data analysis workflow

## Writing Functions

* ["Functions"](https://r4ds.had.co.nz/functions.html)
  - book chapter from Hadley Wickham & Garrett Grolemund's "R for Data Science"
  
## Advanced Topics

* ["RMarkdown Driven Development (RmdDD)"](https://emilyriederer.netlify.app/post/rmarkdown-driven-development/)
  - Blogpost from Emily Riederer on structuring RMarkdown documents for data analysis; see also the ["RMarkdown Driven Development: the Technical Appendix"](https://emilyriederer.netlify.app/post/rmddd-tech-appendix/)
  
* ["The Wrong Abstraction"](https://sandimetz.com/blog/2016/1/20/the-wrong-abstraction)
  - blogpost from Sandi Metz on refactoring and complexity
  
* ["The drake R package"](https://docs.ropensci.org/drake/)
  - `drake` is a workflow package to help manage large and complex analyses
  
## Book Recommendations from Twitter

* ["The Art of Readable Code"](https://www.oreilly.com/library/view/the-art-of/9781449318482/)
  - via https://twitter.com/mv_evans/status/1354435566981545988
  
* ["Clean Code: A Handbook of Craftsmanship"](https://www.oreilly.com/library/view/clean-code-a/9780136083238/)
  - via https://twitter.com/mxwlj/status/1354170627695861761
  