<a id="top"></a>
[<img src ="https://zenodo.org/badge/DOI/10.5281/zenodo.2628755.svg"/>](https://doi.org/10.5281/zenodo.2628755) 
![GitHub release (latest by date)](https://img.shields.io/github/v/release/ESIPFed/science-on-schema.org)
[![Twitter Follow](https://img.shields.io/twitter/follow/ScienceOnSchema.svg?style=social&label=Follow)](https://twitter.com/ScienceOnSchema)

![GitHub last commit](https://img.shields.io/github/last-commit/ESIPFed/science-on-schema.org)
![GitHub contributors](https://img.shields.io/github/contributors/ESIPFed/science-on-schema.org)


<a id="guides"></a>
## Science On Schema.Org (SOSO) Guidance Documents ##

This repository provides guidance for repository operators and others to follow consistent conventions to provide schema.org markup in Dataset landing pages to improve data discovery through search engines. The main guides help describe Datasets and Data Repositories.

* __[Dataset](/guides/Dataset.md)__ - guidelines for schema.org for a scientific Dataset
* __[Data Repository](/guides/DataRepository.md)__ - guidelines for schema.org for a research data repository
* [Getting Started](/guides/GETTING-STARTED.md) - explains some useful techniques that will be common across all schema.org types

This guidance has been created by members of the ESIP [science-on-schema.org cluster](http://wiki.esipfed.org/index.php/Schema.org_Cluster). The cluster will be seeking endorsement across all members of ESIP, and in the meantime is releasing a series of progressively more mature guidance documents for the community. Your feedback and contributions are welcome. The cluster meets twice monthly, and all are welcome:

- When: 
    - 1st Monday at 5pmET
    - 4th Thursday, 2:30pmET
- Where: Telecons via GoToMeeting
    - Connection: https://global.gotomeeting.com/join/431083909
    - Access Code: 431-083-909
    - Phone Access: United States: +1 (786) 535-3211
- [Living Agenda](https://docs.google.com/document/d/1tIlDVnKeocO1E_SSbNaldv0avORfGFdmYDNk_3ub6ik/edit?ts=5d9ed12d)

## Citation

Science on Schema.org (SOSO) releases are archived on Zenodo, and the current release should be cited as:

> Adam Shepherd, Matthew B. Jones, Dave Vieglais, Stephen Richard, Doug Fils. (2020). Schema.org Publishing Guidelines for the Geosciences v1.2 (Version 1.2.0). Zenodo. https://doi.org/10.5281/zenodo.4477164

## Upcoming Work

v1.3 ([issues](https://github.com/ESIPFed/science-on-schema.org/milestone/6), [develop branch](https://github.com/ESIPFed/science-on-schema.org/tree/develop))

## Version DOIs

| Version | DOI |
| ------------- | ------------- |
|[1.2.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.2.0)|[<img src="https://zenodo.org/badge/DOI/10.5281/zenodo.4477164.svg"/>](https://doi.org/10.5281/zenodo.4477164)|
|[1.1.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.1.0)|[<img src="https://zenodo.org/badge/DOI/10.5281/zenodo.3736235.svg"/>](https://doi.org/10.5281/zenodo.3736235)|
|[1.0.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.0.0)|[<img src ="https://zenodo.org/badge/DOI/10.5281/zenodo.2628756.svg"/>](https://doi.org/10.5281/zenodo.2628756)|

## Resources

* ESIP and this group
  * [Learn about ESIP](https://www.esipfed.org/)
  * [Join ESIP Slack](https://esip-slack-invite.herokuapp.com/) for real time chat
  * Chat on the [`sci-schemaorg`](https://esip-all.slack.com/archives/sci-schemaorg) Slack channel
  * [`sci-schemaorg` mailing list](https://lists.esipfed.org/mailman/listinfo/esip-schema-dot-org)
  * [`sci-schemaorg` wiki](http://wiki.esipfed.org/index.php/Schema.org_Cluster)
* History
  * This guide is a continuation of the [P418 NSF EarthCube](https://github.com/earthcubearchitecture-project418/p418Vocabulary) vocabulary guidance which ended in April 2018.
* Broader Community
  * [Schema.org development](https://github.com/schemaorg/schemaorg)
  * [Schema.org archived history](https://www.w3.org/wiki/index.php?title=WebSchemas/SchemaDotOrgProposalsArchive#2011-2014_Proposals_for_Schema.org), can be helpful when determining intent
  * [Data Catalog Vocabulary](https://www.w3.org/TR/vocab-dcat/) (DCAT)
  * [Bioschemas](https://bioschemas.org/)
  * [Geoschemas](https://geoschemas.org/)
  * [Shape Constraint Language](https://www.w3.org/TR/shacl/) (SHACL)
  * [Comparison of SHACL tool implementations](https://w3c.github.io/data-shapes/data-shapes-test-suite/#validate-rdf-data-tests)
* Tools
  * [Gleaner](https://gleaner.io) EarthCube developed tools for working with structure data 
  * [`exstruct`](https://github.com/scrapinghub/extruct) python tool for extracting microdata
  * [Google structured data test tool](https://search.google.com/structured-data/testing-tool/u/0/)
  * [Google dataset search](https://toolbox.google.com/datasetsearch)
  * TopQuadrant TopBraid [SHACL validator](https://github.com/TopQuadrant/shacl)
  * [pySHACL](https://github.com/RDFLib/pySHACL)
  * [SHACL playground](https://shacl.org/playground/)
